/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    public abstract void onFailure(@NonNull Status var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @KeepForSdk
    public final void onResult(@NonNull R result) {
        String string2;
        Status status = result.getStatus();
        if (status.isSuccess()) {
            this.onSuccess(string2);
            return;
        }
        this.onFailure(status);
        if (!(string2 instanceof Releasable)) return;
        try {
            ((Releasable)((Object)string2)).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            string2 = String.valueOf(string2);
            String.valueOf(string2).length();
            Log.w("ResultCallbacks", "Unable to release ".concat(String.valueOf(string2)), runtimeException);
            return;
        }
    }

    public abstract void onSuccess(@NonNull R var1);
}

