/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.abt;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.firebase.abt.AbtException;
import com.google.firebase.abt.AbtExperimentInfo;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inject.Provider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FirebaseABTesting {
    @VisibleForTesting
    static final String ABT_PREFERENCES = "com.google.firebase.abt";
    @VisibleForTesting
    static final String ORIGIN_LAST_KNOWN_START_TIME_KEY_FORMAT = "%s_lastKnownExperimentStartTime";
    private final Provider<AnalyticsConnector> analyticsConnector;
    private final String originService;
    @Nullable
    private Integer maxUserProperties;

    public FirebaseABTesting(Context unusedAppContext, Provider<AnalyticsConnector> analyticsConnector, String originService) {
        this.analyticsConnector = analyticsConnector;
        this.originService = originService;
        this.maxUserProperties = null;
    }

    @WorkerThread
    public void replaceAllExperiments(List<Map<String, String>> replacementExperiments) throws AbtException {
        this.throwAbtExceptionIfAnalyticsIsNull();
        if (replacementExperiments == null) {
            throw new IllegalArgumentException("The replacementExperiments list is null.");
        }
        this.replaceAllExperimentsWith(FirebaseABTesting.convertMapsToExperimentInfos(replacementExperiments));
    }

    @WorkerThread
    public void removeAllExperiments() throws AbtException {
        this.throwAbtExceptionIfAnalyticsIsNull();
        this.removeExperiments(this.getAllExperimentsInAnalytics());
    }

    @WorkerThread
    public List<AbtExperimentInfo> getAllExperiments() throws AbtException {
        this.throwAbtExceptionIfAnalyticsIsNull();
        List<AnalyticsConnector.ConditionalUserProperty> experimentsInAnalytics = this.getAllExperimentsInAnalytics();
        ArrayList<AbtExperimentInfo> experimentInfos = new ArrayList<AbtExperimentInfo>();
        for (AnalyticsConnector.ConditionalUserProperty experimentInAnalytics : experimentsInAnalytics) {
            experimentInfos.add(AbtExperimentInfo.fromConditionalUserProperty(experimentInAnalytics));
        }
        return experimentInfos;
    }

    @WorkerThread
    public void reportActiveExperiment(AbtExperimentInfo activeExperiment) throws AbtException {
        this.throwAbtExceptionIfAnalyticsIsNull();
        AbtExperimentInfo.validateAbtExperimentInfo(activeExperiment);
        ArrayList<AbtExperimentInfo> activeExperimentList = new ArrayList<AbtExperimentInfo>();
        Map<String, String> activeExperimentMap = activeExperiment.toStringMap();
        activeExperimentMap.remove("triggerEvent");
        activeExperimentList.add(AbtExperimentInfo.fromMap(activeExperimentMap));
        this.addExperiments(activeExperimentList);
    }

    @WorkerThread
    public void validateRunningExperiments(List<AbtExperimentInfo> runningExperiments) throws AbtException {
        this.throwAbtExceptionIfAnalyticsIsNull();
        HashSet<String> runningExperimentIds = new HashSet<String>();
        for (AbtExperimentInfo runningExperiment : runningExperiments) {
            runningExperimentIds.add(runningExperiment.getExperimentId());
        }
        ArrayList<AnalyticsConnector.ConditionalUserProperty> experimentsToRemove = this.getExperimentsToRemove(this.getAllExperimentsInAnalytics(), runningExperimentIds);
        this.removeExperiments(experimentsToRemove);
    }

    private void replaceAllExperimentsWith(List<AbtExperimentInfo> replacementExperiments) throws AbtException {
        if (replacementExperiments.isEmpty()) {
            this.removeAllExperiments();
            return;
        }
        HashSet<String> replacementExperimentIds = new HashSet<String>();
        for (AbtExperimentInfo replacementExperiment : replacementExperiments) {
            replacementExperimentIds.add(replacementExperiment.getExperimentId());
        }
        List<AnalyticsConnector.ConditionalUserProperty> experimentsInAnalytics = this.getAllExperimentsInAnalytics();
        HashSet<String> idsOfExperimentsInAnalytics = new HashSet<String>();
        for (AnalyticsConnector.ConditionalUserProperty experimentInAnalytics : experimentsInAnalytics) {
            idsOfExperimentsInAnalytics.add(experimentInAnalytics.name);
        }
        ArrayList<AnalyticsConnector.ConditionalUserProperty> experimentsToRemove = this.getExperimentsToRemove(experimentsInAnalytics, replacementExperimentIds);
        this.removeExperiments(experimentsToRemove);
        ArrayList<AbtExperimentInfo> experimentsToAdd = this.getExperimentsToAdd(replacementExperiments, idsOfExperimentsInAnalytics);
        this.addExperiments(experimentsToAdd);
    }

    private ArrayList<AnalyticsConnector.ConditionalUserProperty> getExperimentsToRemove(List<AnalyticsConnector.ConditionalUserProperty> experimentsInAnalytics, Set<String> replacementExperimentIds) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> experimentsToRemove = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        for (AnalyticsConnector.ConditionalUserProperty experimentInAnalytics : experimentsInAnalytics) {
            if (replacementExperimentIds.contains(experimentInAnalytics.name)) continue;
            experimentsToRemove.add(experimentInAnalytics);
        }
        return experimentsToRemove;
    }

    private ArrayList<AbtExperimentInfo> getExperimentsToAdd(List<AbtExperimentInfo> replacementExperiments, Set<String> idsOfExperimentsInAnalytics) {
        ArrayList<AbtExperimentInfo> experimentsToAdd = new ArrayList<AbtExperimentInfo>();
        for (AbtExperimentInfo replacementExperiment : replacementExperiments) {
            if (idsOfExperimentsInAnalytics.contains(replacementExperiment.getExperimentId())) continue;
            experimentsToAdd.add(replacementExperiment);
        }
        return experimentsToAdd;
    }

    private void addExperiments(List<AbtExperimentInfo> experimentsToAdd) {
        ArrayDeque<AnalyticsConnector.ConditionalUserProperty> dequeOfExperimentsInAnalytics = new ArrayDeque<AnalyticsConnector.ConditionalUserProperty>(this.getAllExperimentsInAnalytics());
        int fetchedMaxUserProperties = this.getMaxUserPropertiesInAnalytics();
        for (AbtExperimentInfo experimentToAdd : experimentsToAdd) {
            while (dequeOfExperimentsInAnalytics.size() >= fetchedMaxUserProperties) {
                this.removeExperimentFromAnalytics(((AnalyticsConnector.ConditionalUserProperty)dequeOfExperimentsInAnalytics.pollFirst()).name);
            }
            AnalyticsConnector.ConditionalUserProperty experiment = experimentToAdd.toConditionalUserProperty(this.originService);
            this.addExperimentToAnalytics(experiment);
            dequeOfExperimentsInAnalytics.offer(experiment);
        }
    }

    private void removeExperiments(Collection<AnalyticsConnector.ConditionalUserProperty> experiments) {
        for (AnalyticsConnector.ConditionalUserProperty experiment : experiments) {
            this.removeExperimentFromAnalytics(experiment.name);
        }
    }

    private static List<AbtExperimentInfo> convertMapsToExperimentInfos(List<Map<String, String>> replacementExperimentsMaps) throws AbtException {
        ArrayList<AbtExperimentInfo> replacementExperimentInfos = new ArrayList<AbtExperimentInfo>();
        for (Map<String, String> replacementExperimentMap : replacementExperimentsMaps) {
            replacementExperimentInfos.add(AbtExperimentInfo.fromMap(replacementExperimentMap));
        }
        return replacementExperimentInfos;
    }

    private void addExperimentToAnalytics(AnalyticsConnector.ConditionalUserProperty experiment) {
        this.analyticsConnector.get().setConditionalUserProperty(experiment);
    }

    private void throwAbtExceptionIfAnalyticsIsNull() throws AbtException {
        if (this.analyticsConnector.get() == null) {
            throw new AbtException("The Analytics SDK is not available. Please check that the Analytics SDK is included in your app dependencies.");
        }
    }

    private void removeExperimentFromAnalytics(String experimentId) {
        this.analyticsConnector.get().clearConditionalUserProperty(experimentId, null, null);
    }

    @WorkerThread
    private int getMaxUserPropertiesInAnalytics() {
        if (this.maxUserProperties == null) {
            this.maxUserProperties = this.analyticsConnector.get().getMaxUserProperties(this.originService);
        }
        return this.maxUserProperties;
    }

    @WorkerThread
    private List<AnalyticsConnector.ConditionalUserProperty> getAllExperimentsInAnalytics() {
        return this.analyticsConnector.get().getConditionalUserProperties(this.originService, "");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OriginService {
        public static final String REMOTE_CONFIG = "frc";
        public static final String INAPP_MESSAGING = "fiam";
    }
}

