/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.bundle.BundleMetadata;
import com.google.firebase.firestore.bundle.NamedQuery;
import com.google.firebase.firestore.local.BundleCache;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.bundle.BundledQuery;
import com.google.protobuf.InvalidProtocolBufferException;

class SQLiteBundleCache
implements BundleCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteBundleCache(SQLitePersistence persistence, LocalSerializer serializer2) {
        this.db = persistence;
        this.serializer = serializer2;
    }

    @Override
    @Nullable
    public BundleMetadata getBundleMetadata(String bundleId) {
        return (BundleMetadata)this.db.query("SELECT schema_version, create_time_seconds, create_time_nanos, total_documents,  total_bytes FROM bundles WHERE bundle_id = ?").binding(bundleId).firstValue(row -> row == null ? null : new BundleMetadata(bundleId, row.getInt(0), new SnapshotVersion(new Timestamp(row.getLong(1), row.getInt(2))), row.getInt(3), row.getLong(4)));
    }

    @Override
    public void saveBundleMetadata(BundleMetadata metadata) {
        this.db.execute("INSERT OR REPLACE INTO bundles (bundle_id, schema_version, create_time_seconds, create_time_nanos, total_documents, total_bytes) VALUES (?, ?, ?, ?, ?, ?)", metadata.getBundleId(), metadata.getSchemaVersion(), metadata.getCreateTime().getTimestamp().getSeconds(), metadata.getCreateTime().getTimestamp().getNanoseconds(), metadata.getTotalDocuments(), metadata.getTotalBytes());
    }

    @Override
    @Nullable
    public NamedQuery getNamedQuery(String queryName) {
        return (NamedQuery)this.db.query("SELECT read_time_seconds, read_time_nanos, bundled_query_proto FROM named_queries WHERE name = ?").binding(queryName).firstValue(row -> {
            if (row != null) {
                try {
                    BundledQuery bundledQuery = BundledQuery.parseFrom(row.getBlob(2));
                    return new NamedQuery(queryName, this.serializer.decodeBundledQuery(bundledQuery), new SnapshotVersion(new Timestamp(row.getLong(0), row.getInt(1))));
                }
                catch (InvalidProtocolBufferException e) {
                    throw Assert.fail("NamedQuery failed to parse: %s", new Object[]{e});
                }
            }
            return null;
        });
    }

    @Override
    public void saveNamedQuery(NamedQuery query) {
        BundledQuery bundledQuery = this.serializer.encodeBundledQuery(query.getBundledQuery());
        this.db.execute("INSERT OR REPLACE INTO named_queries (name, read_time_seconds, read_time_nanos, bundled_query_proto) VALUES (?, ?, ?, ?)", query.getName(), query.getReadTime().getTimestamp().getSeconds(), query.getReadTime().getTimestamp().getNanoseconds(), bundledQuery.toByteArray());
    }
}

