/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzai {
    private final Context zza;
    @GuardedBy(value="this")
    private String zzb;
    @GuardedBy(value="this")
    private String zzc;
    @GuardedBy(value="this")
    private int zzd;
    @GuardedBy(value="this")
    private int zze = 0;

    public zzai(Context context) {
        this.zza = context;
    }

    public final synchronized int zza() {
        List list;
        Intent intent;
        if (this.zze != 0) {
            return this.zze;
        }
        PackageManager packageManager = this.zza.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e("FirebaseInstanceId", "Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zze = 1;
                return this.zze;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zze = 2;
            return this.zze;
        }
        Log.w("FirebaseInstanceId", "Failed to resolve IID implementation package, falling back");
        this.zze = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.zze;
    }

    public static String zza(FirebaseApp firebaseApp) {
        String string2 = firebaseApp.getOptions().getGcmSenderId();
        if (string2 != null) {
            return string2;
        }
        String string3 = firebaseApp.getOptions().getApplicationId();
        if (!string3.startsWith("1:")) {
            return string3;
        }
        String[] stringArray = string3.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string4 = stringArray[1];
        if (string4.isEmpty()) {
            return null;
        }
        return string4;
    }

    public static String zza(PublicKey publicKey) {
        byte[] byArray = publicKey.getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString(byArray2, 0, 8, 11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w("FirebaseInstanceId", "Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public final synchronized String zzb() {
        if (this.zzb == null) {
            this.zze();
        }
        return this.zzb;
    }

    public final synchronized String zzc() {
        if (this.zzc == null) {
            this.zze();
        }
        return this.zzc;
    }

    public final synchronized int zzd() {
        PackageInfo packageInfo;
        if (this.zzd == 0 && (packageInfo = this.zza("com.google.android.gms")) != null) {
            this.zzd = packageInfo.versionCode;
        }
        return this.zzd;
    }

    private final synchronized void zze() {
        PackageInfo packageInfo = this.zza(this.zza.getPackageName());
        if (packageInfo != null) {
            this.zzb = Integer.toString(packageInfo.versionCode);
            this.zzc = packageInfo.versionName;
        }
    }

    private final PackageInfo zza(String string2) {
        try {
            return this.zza.getPackageManager().getPackageInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(nameNotFoundException);
            Log.w("FirebaseInstanceId", new StringBuilder(23 + String.valueOf(string3).length()).append("Failed to find package ").append(string3).toString());
            return null;
        }
    }
}

