/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.firebase.iid.zzaw;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

public final class zzaq {
    private static zzaq zza;
    @GuardedBy(value="this")
    @Nullable
    private String zzb = null;
    private Boolean zzc = null;
    private Boolean zzd = null;
    private final Queue<Intent> zze = new ArrayDeque<Intent>();

    public static synchronized zzaq zza() {
        if (zza == null) {
            zza = new zzaq();
        }
        return zza;
    }

    private zzaq() {
    }

    @MainThread
    public final Intent zzb() {
        return this.zze.poll();
    }

    @MainThread
    public final int zza(Context context, Intent intent) {
        if (Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Starting service");
        }
        this.zze.offer(intent);
        Intent intent2 = new Intent("com.google.firebase.MESSAGING_EVENT");
        intent2.setPackage(context.getPackageName());
        return this.zzb(context, intent2);
    }

    private final int zzb(Context context, Intent intent) {
        String string2 = this.zzc(context, intent);
        if (string2 != null) {
            if (Log.isLoggable("FirebaseInstanceId", 3)) {
                String string3 = String.valueOf(string2);
                Log.d("FirebaseInstanceId", string3.length() != 0 ? "Restricting intent to a specific service: ".concat(string3) : new String("Restricting intent to a specific service: "));
            }
            intent.setClassName(context.getPackageName(), string2);
        }
        try {
            ComponentName componentName;
            if (this.zza(context)) {
                componentName = zzaw.zza(context, intent);
            } else {
                componentName = context.startService(intent);
                Log.d("FirebaseInstanceId", "Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e("FirebaseInstanceId", "Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e("FirebaseInstanceId", "Error while delivering the message to the serviceIntent", securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            Log.e("FirebaseInstanceId", new StringBuilder(45 + String.valueOf(string4).length()).append("Failed to start service while in background: ").append(string4).toString());
            return 402;
        }
    }

    @Nullable
    private final synchronized String zzc(Context context, Intent intent) {
        if (this.zzb != null) {
            return this.zzb;
        }
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e("FirebaseInstanceId", "Failed to resolve target intent service, skipping classname enforcement");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            String string2 = serviceInfo.packageName;
            String string3 = serviceInfo.name;
            Log.e("FirebaseInstanceId", new StringBuilder(94 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string2).append("/").append(string3).toString());
            return null;
        }
        if (serviceInfo.name.startsWith(".")) {
            String string4 = String.valueOf(context.getPackageName());
            String string5 = String.valueOf(serviceInfo.name);
            this.zzb = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        } else {
            this.zzb = serviceInfo.name;
        }
        return this.zzb;
    }

    final boolean zza(Context context) {
        if (this.zzc == null) {
            this.zzc = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        if (!this.zzc.booleanValue() && Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzc;
    }

    final boolean zzb(Context context) {
        if (this.zzd == null) {
            this.zzd = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        if (!this.zzc.booleanValue() && Log.isLoggable("FirebaseInstanceId", 3)) {
            Log.d("FirebaseInstanceId", "Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzd;
    }
}

