/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.cloudmessaging.zza;
import com.google.android.gms.cloudmessaging.zze;
import com.google.android.gms.cloudmessaging.zzr;
import com.google.android.gms.cloudmessaging.zzt;
import com.google.android.gms.cloudmessaging.zzu;
import com.google.android.gms.cloudmessaging.zzv;
import com.google.android.gms.cloudmessaging.zzw;
import com.google.android.gms.cloudmessaging.zzx;
import com.google.android.gms.cloudmessaging.zzy;
import com.google.android.gms.cloudmessaging.zzz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

public class Rpc {
    private static int zza = 0;
    private static PendingIntent zzb;
    private static final Executor zzc;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzd = new SimpleArrayMap();
    private final Context zze;
    private final zzr zzf;
    private final ScheduledExecutorService zzg;
    private Messenger zzh;
    private Messenger zzi;
    private zza zzj;

    public Rpc(@NonNull Context context) {
        this.zze = context;
        this.zzf = new zzr(context);
        this.zzh = new Messenger(new zzy(this, Looper.getMainLooper()));
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        scheduledThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.zzg = scheduledThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(new zza.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zza) {
                    this.zzj = (zza)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzi = (Messenger)((Object)parcelable);
                }
            }
            Intent intent2 = (Intent)message.obj;
            Rpc rpc = this;
            String string2 = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string2)) {
                if (Log.isLoggable("Rpc", 3)) {
                    String string3 = String.valueOf(string2);
                    Log.d("Rpc", string3.length() != 0 ? "Unexpected response action: ".concat(string3) : new String("Unexpected response action: "));
                }
                return;
            }
            String string4 = intent2.getStringExtra("registration_id");
            if (string4 == null) {
                string4 = intent2.getStringExtra("unregistered");
            }
            if (string4 == null) {
                Intent intent3 = intent2;
                Rpc rpc2 = rpc;
                String string5 = intent3.getStringExtra("error");
                if (string5 == null) {
                    String string6 = String.valueOf(intent3.getExtras());
                    Log.w("Rpc", new StringBuilder(49 + String.valueOf(string6).length()).append("Unexpected response, no error or registration id ").append(string6).toString());
                    return;
                }
                if (Log.isLoggable("Rpc", 3)) {
                    String string7 = String.valueOf(string5);
                    Log.d("Rpc", string7.length() != 0 ? "Received InstanceID error ".concat(string7) : new String("Received InstanceID error "));
                }
                if (string5.startsWith("|")) {
                    String[] stringArray = string5.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string8 = String.valueOf(string5);
                        Log.w("Rpc", string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response "));
                        return;
                    }
                    String string9 = stringArray[2];
                    string5 = stringArray[3];
                    if (string5.startsWith(":")) {
                        string5 = string5.substring(1);
                    }
                    rpc2.zza(string9, intent3.putExtra("error", string5).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = rpc2.zzd;
                synchronized (simpleArrayMap) {
                    for (int i = 0; i < rpc2.zzd.size(); ++i) {
                        rpc2.zza((String)rpc2.zzd.keyAt(i), intent3.getExtras());
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string4);
            if (!matcher.matches()) {
                if (Log.isLoggable("Rpc", 3)) {
                    String string10 = String.valueOf(string4);
                    Log.d("Rpc", string10.length() != 0 ? "Unexpected response string: ".concat(string10) : new String("Unexpected response string: "));
                }
                return;
            }
            String string11 = matcher.group(1);
            String string12 = matcher.group(2);
            if (string11 != null) {
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string12);
                rpc.zza(string11, bundle);
            }
            return;
        }
        Log.w("Rpc", "Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string2, @Nullable Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzd;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzd.remove((Object)string2);
            if (taskCompletionSource == null) {
                String string3 = String.valueOf(string2);
                Log.w("Rpc", string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for "));
                return;
            }
            taskCompletionSource.setResult(bundle);
            return;
        }
    }

    @NonNull
    public Task<Bundle> send(@NonNull Bundle bundle) {
        if (this.zzf.zzb() >= 12000000) {
            return com.google.android.gms.cloudmessaging.zze.zza(this.zze).zzb(1, bundle).continueWith(zzc, zzt.zza);
        }
        Bundle bundle2 = bundle;
        Rpc rpc = this;
        if (!(rpc.zzf.zza() != 0)) {
            return Tasks.forException(new IOException("MISSING_INSTANCEID_SERVICE"));
        }
        return rpc.zzc(bundle2).continueWithTask(zzc, new zzv(rpc, bundle2));
    }

    private static boolean zzb(Bundle bundle) {
        return bundle != null && bundle.containsKey("google.messenger");
    }

    private static synchronized String zza() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private final Task<Bundle> zzc(Bundle bundle) {
        Object object;
        TaskCompletionSource taskCompletionSource;
        String string2;
        block13: {
            Rpc rpc;
            Intent intent;
            block14: {
                Object object2;
                string2 = Rpc.zza();
                taskCompletionSource = new TaskCompletionSource();
                object = this.zzd;
                synchronized (object) {
                    this.zzd.put((Object)string2, taskCompletionSource);
                }
                String string3 = string2;
                Bundle bundle2 = bundle;
                Rpc rpc2 = this;
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (rpc2.zzf.zza() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle2);
                Rpc.zza(rpc2.zze, intent2);
                String string4 = string3;
                intent = intent2;
                rpc = rpc2;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable("Rpc", 3)) {
                    object2 = String.valueOf(intent.getExtras());
                    Log.d("Rpc", new StringBuilder(8 + String.valueOf(object2).length()).append("Sending ").append((String)object2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)((Object)rpc.zzh));
                if (rpc.zzi != null || rpc.zzj != null) {
                    object2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (rpc.zzi != null) {
                            rpc.zzi.send((Message)object2);
                        } else {
                            rpc.zzj.zza((Message)object2);
                        }
                        break block13;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable("Rpc", 3)) break block14;
                        Log.d("Rpc", "Messenger failed, fallback to startService");
                    }
                }
            }
            if (rpc.zzf.zza() == 2) {
                rpc.zze.sendBroadcast(intent);
            } else {
                rpc.zze.startService(intent);
            }
        }
        object = this.zzg.schedule(new zzu(taskCompletionSource), 30L, TimeUnit.SECONDS);
        taskCompletionSource.getTask().addOnCompleteListener(zzc, new zzx(this, string2, (ScheduledFuture)object));
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(String string2, ScheduledFuture scheduledFuture, Task task) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzd;
        synchronized (simpleArrayMap) {
            this.zzd.remove((Object)string2);
        }
        scheduledFuture.cancel(false);
    }

    static final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource) {
        if (taskCompletionSource.trySetException(new IOException("TIMEOUT"))) {
            Log.w("Rpc", "No response");
        }
    }

    final /* synthetic */ Task zza(Bundle bundle, Task task) throws Exception {
        if (!task.isSuccessful()) {
            return task;
        }
        if (!Rpc.zzb((Bundle)task.getResult())) {
            return task;
        }
        return this.zzc(bundle).onSuccessTask(zzc, zzw.zza);
    }

    static final /* synthetic */ Task zza(Bundle bundle) throws Exception {
        if (Rpc.zzb(bundle)) {
            return Tasks.forResult(null);
        }
        return Tasks.forResult(bundle);
    }

    static final /* synthetic */ Bundle zza(Task task) throws Exception {
        if (task.isSuccessful()) {
            return (Bundle)task.getResult();
        }
        if (Log.isLoggable("Rpc", 3)) {
            String string2 = String.valueOf(task.getException());
            Log.d("Rpc", new StringBuilder(22 + String.valueOf(string2).length()).append("Error making request: ").append(string2).toString());
        }
        throw new IOException("SERVICE_NOT_AVAILABLE", task.getException());
    }

    static /* synthetic */ void zza(Rpc rpc, Message message) {
        rpc.zza(message);
    }

    static {
        zzc = zzz.zza;
    }
}

