/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.stats;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.providers.PooledExecutorsProvider;
import com.google.android.gms.common.stats.StatsUtils;
import com.google.android.gms.common.stats.WakeLockTracker;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.stats.zzb;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ShowFirstParty
@ThreadSafe
@KeepForSdk
public class WakeLock {
    private final Object zza = this;
    private final PowerManager.WakeLock zzb;
    private WorkSource zzc;
    private final int zzd;
    private final String zze;
    private final String zzf;
    private final String zzg;
    private final Context zzh;
    private boolean zzi = true;
    private final Map<String, Integer[]> zzj = new HashMap<String, Integer[]>();
    private final Set<Future<?>> zzk = Collections.synchronizedSet(new HashSet());
    private int zzl;
    private AtomicInteger zzm = new AtomicInteger(0);
    private static ScheduledExecutorService zzn;
    private static volatile zza zzo;

    @KeepForSdk
    public WakeLock(@NonNull Context context, int n, @NonNull String string2) {
        this(context, n, string2, null, context == null ? null : context.getPackageName());
    }

    private WakeLock(@NonNull Context context, int n, @NonNull String string2, @Nullable String string3, @NonNull String string4) {
        this(context, n, string2, null, string4, null);
    }

    @SuppressLint(value={"UnwrappedWakeLock"})
    private WakeLock(@NonNull Context context, int n, @NonNull String string2, @Nullable String string3, @NonNull String string4, @Nullable String string5) {
        Preconditions.checkNotNull(context, "WakeLock: context must not be null");
        Preconditions.checkNotEmpty(string2, "WakeLock: wakeLockName must not be empty");
        this.zzd = n;
        this.zzf = null;
        this.zzg = null;
        this.zzh = context.getApplicationContext();
        if (!"com.google.android.gms".equals(context.getPackageName())) {
            String string6 = String.valueOf("*gcore*:");
            String string7 = String.valueOf(string2);
            this.zze = string7.length() != 0 ? string6.concat(string7) : new String(string6);
        } else {
            this.zze = string2;
        }
        this.zzb = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string2);
        if (WorkSourceUtil.hasWorkSourcePermission(context)) {
            String string8 = Strings.isEmptyOrWhitespace(string4) ? context.getPackageName() : string4;
            String string9 = string8;
            Context context2 = context;
            WakeLock wakeLock = this;
            this.zzc = WorkSourceUtil.fromPackage(context2, string9);
            context2 = this.zzc;
            wakeLock = this;
            if (context2 != null && WorkSourceUtil.hasWorkSourcePermission(wakeLock.zzh)) {
                if (wakeLock.zzc != null) {
                    wakeLock.zzc.add((WorkSource)context2);
                } else {
                    wakeLock.zzc = context2;
                }
                WorkSource workSource = wakeLock.zzc;
                WakeLock wakeLock2 = wakeLock;
                try {
                    wakeLock2.zzb.setWorkSource(workSource);
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
                    Log.wtf("WakeLock", runtimeException.toString());
                }
            }
        }
        if (zzn == null) {
            zzn = PooledExecutorsProvider.getInstance().newSingleThreadScheduledExecutor();
        }
    }

    private final List<String> zza() {
        List<String> list = WorkSourceUtil.getNames(this.zzc);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void acquire(long l) {
        WakeLock wakeLock;
        long l2;
        long l3;
        block12: {
            this.zzm.incrementAndGet();
            l3 = l;
            WakeLock wakeLock2 = this;
            l2 = l;
            wakeLock = wakeLock2;
            long l4 = l3;
            Object var11_7 = null;
            WakeLock wakeLock3 = wakeLock2;
            String string2 = wakeLock2.zza(null);
            Object object = wakeLock3.zza;
            synchronized (object) {
                block11: {
                    block10: {
                        boolean bl;
                        if (!(wakeLock3.zzj.isEmpty() && wakeLock3.zzl <= 0 || wakeLock3.zzb.isHeld())) {
                            wakeLock3.zzj.clear();
                            wakeLock3.zzl = 0;
                        }
                        if (!wakeLock3.zzi) break block10;
                        String string3 = string2;
                        WakeLock wakeLock4 = wakeLock3;
                        Integer[] integerArray = wakeLock4.zzj.get(string3);
                        if (integerArray == null) {
                            wakeLock4.zzj.put(string3, new Integer[]{1});
                            bl = true;
                        } else {
                            integerArray[0] = integerArray[0] + 1;
                            bl = false;
                        }
                        if (bl) break block11;
                    }
                    if (wakeLock3.zzi || wakeLock3.zzl != 0) break block12;
                }
                WakeLockTracker.getInstance().registerEvent(wakeLock3.zzh, StatsUtils.getEventKey(wakeLock3.zzb, string2), 7, wakeLock3.zze, string2, null, wakeLock3.zzd, wakeLock3.zza(), l4);
                ++wakeLock3.zzl;
            }
        }
        wakeLock.zzb.acquire();
        if (l3 > 0L) {
            WakeLock wakeLock5 = wakeLock;
            zzn.schedule(new zzb(wakeLock5), l2, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void release() {
        WakeLock wakeLock;
        block13: {
            WakeLock wakeLock2 = this;
            if (wakeLock2.zzm.decrementAndGet() < 0) {
                Log.e("WakeLock", String.valueOf(wakeLock2.zze).concat(" release without a matched acquire!"));
            }
            wakeLock = wakeLock2;
            Object var4_3 = null;
            WakeLock wakeLock3 = wakeLock;
            String string2 = wakeLock.zza(null);
            Object object = wakeLock3.zza;
            synchronized (object) {
                block12: {
                    block11: {
                        boolean bl;
                        if (!wakeLock3.zzi) break block11;
                        String string3 = string2;
                        WakeLock wakeLock4 = wakeLock3;
                        Integer[] integerArray = wakeLock4.zzj.get(string3);
                        if (integerArray == null) {
                            bl = false;
                        } else if (integerArray[0] == 1) {
                            wakeLock4.zzj.remove(string3);
                            bl = true;
                        } else {
                            integerArray[0] = integerArray[0] - 1;
                            bl = false;
                        }
                        if (bl) break block12;
                    }
                    if (wakeLock3.zzi || wakeLock3.zzl != 1) break block13;
                }
                WakeLockTracker.getInstance().registerEvent(wakeLock3.zzh, StatsUtils.getEventKey(wakeLock3.zzb, string2), 8, wakeLock3.zze, string2, null, wakeLock3.zzd, wakeLock3.zza());
                --wakeLock3.zzl;
            }
        }
        wakeLock.zza(0);
    }

    private final void zza(int n) {
        WakeLock wakeLock = this;
        if (wakeLock.zzb.isHeld()) {
            try {
                wakeLock.zzb.release();
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                if (runtimeException.getClass().equals(RuntimeException.class)) {
                    Log.e("WakeLock", String.valueOf(wakeLock.zze).concat(" was already released!"), runtimeException2);
                }
                throw runtimeException2;
            }
            wakeLock.zzb.isHeld();
        }
    }

    private final String zza(String string2) {
        if (this.zzi) {
            if (!TextUtils.isEmpty(string2)) {
                return string2;
            }
            return this.zzf;
        }
        return this.zzf;
    }

    @KeepForSdk
    public void setReferenceCounted(boolean bl) {
        this.zzb.setReferenceCounted(bl);
        this.zzi = bl;
    }

    @KeepForSdk
    public boolean isHeld() {
        return this.zzb.isHeld();
    }

    static /* synthetic */ void zza(WakeLock wakeLock, int n) {
        wakeLock.zza(0);
    }

    static {
        zzo = new com.google.android.gms.stats.zza();
    }

    public static interface zza {
    }
}

