/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class PersistedInstallation {
    private File dataFile;
    @NonNull
    private final FirebaseApp firebaseApp;
    private static final String SETTINGS_FILE_NAME_PREFIX = "PersistedInstallation";
    private static final String FIREBASE_INSTALLATION_ID_KEY = "Fid";
    private static final String AUTH_TOKEN_KEY = "AuthToken";
    private static final String REFRESH_TOKEN_KEY = "RefreshToken";
    private static final String TOKEN_CREATION_TIME_IN_SECONDS_KEY = "TokenCreationEpochInSecs";
    private static final String EXPIRES_IN_SECONDS_KEY = "ExpiresInSecs";
    private static final String PERSISTED_STATUS_KEY = "Status";
    private static final String FIS_ERROR_KEY = "FisError";

    public PersistedInstallation(@NonNull FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDataFile() {
        if (this.dataFile == null) {
            PersistedInstallation persistedInstallation = this;
            synchronized (persistedInstallation) {
                if (this.dataFile == null) {
                    this.dataFile = new File(this.firebaseApp.getApplicationContext().getFilesDir(), "PersistedInstallation." + this.firebaseApp.getPersistenceKey() + ".json");
                }
            }
        }
        return this.dataFile;
    }

    @NonNull
    public PersistedInstallationEntry readPersistedInstallationEntryValue() {
        JSONObject json = this.readJSONFromFile();
        String fid = json.optString(FIREBASE_INSTALLATION_ID_KEY, null);
        int status = json.optInt(PERSISTED_STATUS_KEY, RegistrationStatus.ATTEMPT_MIGRATION.ordinal());
        String authToken = json.optString(AUTH_TOKEN_KEY, null);
        String refreshToken2 = json.optString(REFRESH_TOKEN_KEY, null);
        long tokenCreationTime = json.optLong(TOKEN_CREATION_TIME_IN_SECONDS_KEY, 0L);
        long expiresIn = json.optLong(EXPIRES_IN_SECONDS_KEY, 0L);
        String fisError = json.optString(FIS_ERROR_KEY, null);
        PersistedInstallationEntry prefs = PersistedInstallationEntry.builder().setFirebaseInstallationId(fid).setRegistrationStatus(RegistrationStatus.values()[status]).setAuthToken(authToken).setRefreshToken(refreshToken2).setTokenCreationEpochInSecs(tokenCreationTime).setExpiresInSecs(expiresIn).setFisError(fisError).build();
        return prefs;
    }

    private JSONObject readJSONFromFile() {
        JSONObject jSONObject;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmpBuf = new byte[16384];
        FileInputStream fis = new FileInputStream(this.getDataFile());
        try {
            int numRead;
            while ((numRead = fis.read(tmpBuf, 0, tmpBuf.length)) >= 0) {
                baos.write(tmpBuf, 0, numRead);
            }
            jSONObject = new JSONObject(baos.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JSONException e) {
                return new JSONObject();
            }
        }
        fis.close();
        return jSONObject;
    }

    @NonNull
    public PersistedInstallationEntry insertOrUpdatePersistedInstallationEntry(@NonNull PersistedInstallationEntry prefs) {
        try {
            JSONObject json = new JSONObject();
            json.put(FIREBASE_INSTALLATION_ID_KEY, prefs.getFirebaseInstallationId());
            json.put(PERSISTED_STATUS_KEY, prefs.getRegistrationStatus().ordinal());
            json.put(AUTH_TOKEN_KEY, prefs.getAuthToken());
            json.put(REFRESH_TOKEN_KEY, prefs.getRefreshToken());
            json.put(TOKEN_CREATION_TIME_IN_SECONDS_KEY, prefs.getTokenCreationEpochInSecs());
            json.put(EXPIRES_IN_SECONDS_KEY, prefs.getExpiresInSecs());
            json.put(FIS_ERROR_KEY, prefs.getFisError());
            File tmpFile = File.createTempFile(SETTINGS_FILE_NAME_PREFIX, "tmp", this.firebaseApp.getApplicationContext().getFilesDir());
            FileOutputStream fos = new FileOutputStream(tmpFile);
            fos.write(json.toString().getBytes("UTF-8"));
            fos.close();
            if (!tmpFile.renameTo(this.getDataFile())) {
                throw new IOException("unable to rename the tmpfile to PersistedInstallation");
            }
        }
        catch (IOException | JSONException exception) {
            // empty catch block
        }
        return prefs;
    }

    public void clearForTesting() {
        this.getDataFile().delete();
    }

    public static enum RegistrationStatus {
        ATTEMPT_MIGRATION,
        NOT_GENERATED,
        UNREGISTERED,
        REGISTERED,
        REGISTER_ERROR;

    }
}

