/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zac;
import com.google.android.gms.auth.api.signin.zad;
import com.google.android.gms.auth.api.signin.zae;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @NonNull
    public static final GoogleSignInOptions DEFAULT_SIGN_IN;
    @NonNull
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN;
    @NonNull
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR;
    @VisibleForTesting
    @NonNull
    public static final Scope zaa;
    @VisibleForTesting
    @NonNull
    public static final Scope zab;
    @VisibleForTesting
    @NonNull
    public static final Scope zac;
    @VisibleForTesting
    @NonNull
    public static final Scope zad;
    @VisibleForTesting
    @NonNull
    public static final Scope zae;
    private static Comparator zag;
    @SafeParcelable.VersionField(id=1)
    final int zaf;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList zah;
    @SafeParcelable.Field(id=3, getter="getAccount")
    @Nullable
    private Account zai;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zaj;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zak;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zal;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    @Nullable
    private String zam;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    @Nullable
    private String zan;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList zao;
    @SafeParcelable.Field(id=10, getter="getLogSessionId")
    @Nullable
    private String zap;
    private Map zaq;

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.zah;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(((Scope)arrayList2.get(i)).getScopeUri());
        }
        Collections.sort(arrayList);
        HashAccumulator hashAccumulator = new HashAccumulator();
        hashAccumulator.addObject(arrayList);
        hashAccumulator.addObject(this.zai);
        hashAccumulator.addObject(this.zam);
        hashAccumulator.zaa(this.zal);
        hashAccumulator.zaa(this.zaj);
        hashAccumulator.zaa(this.zak);
        hashAccumulator.addObject(this.zap);
        return hashAccumulator.hash();
    }

    @KeepForSdk
    @Nullable
    public Account getAccount() {
        return this.zai;
    }

    @KeepForSdk
    @Nullable
    public String getLogSessionId() {
        return this.zap;
    }

    @KeepForSdk
    @Nullable
    public String getServerClientId() {
        return this.zam;
    }

    @KeepForSdk
    @NonNull
    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zao;
    }

    @KeepForSdk
    @NonNull
    public ArrayList<Scope> getScopes() {
        ArrayList<Scope> arrayList = new ArrayList<Scope>(this.zah);
        return arrayList;
    }

    static {
        Object object = new Scope("profile");
        zaa = object;
        object = new Scope("email");
        zab = object;
        object = new Scope("openid");
        zac = object;
        object = new Scope("https://www.googleapis.com/auth/games_lite");
        zad = object;
        object = new Scope("https://www.googleapis.com/auth/games");
        zae = object;
        object = new Builder();
        ((Builder)object).requestId();
        ((Builder)object).requestProfile();
        DEFAULT_SIGN_IN = ((Builder)object).build();
        object = new Builder();
        ((Builder)object).requestScopes(zad, new Scope[0]);
        DEFAULT_GAMES_SIGN_IN = ((Builder)object).build();
        CREATOR = object = new zae();
        zag = object = new zac();
    }

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList arrayList, @SafeParcelable.Param(id=3) @Nullable Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) @Nullable String string2, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) ArrayList arrayList2, @SafeParcelable.Param(id=10) @Nullable String string4) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zam(arrayList2), string4);
    }

    private GoogleSignInOptions(int n, ArrayList arrayList, @Nullable Account account, boolean bl, boolean bl2, boolean bl3, @Nullable String string2, @Nullable String string3, Map map2, @Nullable String string4) {
        ArrayList arrayList2;
        this.zaf = n;
        this.zah = arrayList;
        this.zai = account;
        this.zaj = bl;
        this.zak = bl2;
        this.zal = bl3;
        this.zam = string2;
        this.zan = string3;
        this.zao = arrayList2 = new ArrayList(map2.values());
        this.zaq = map2;
        this.zap = string4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader(out);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.zaf);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, 2, this.getScopes(), false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 3, (Parcelable)this.getAccount(), (int)var2_2, false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, 4, this.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, 5, this.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, 6, this.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)var1_1, 7, this.getServerClientId(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 8, this.zan, false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, 9, this.getExtensions(), false);
        SafeParcelWriter.writeString((Parcel)var1_1, 10, this.getLogSessionId(), false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            boolean bl;
            int n;
            boolean bl2;
            int n2;
            GoogleSignInOptions googleSignInOptions;
            googleSignInOptions = googleSignInOptions;
            int n3 = this.zao.size();
            if (n3 > 0 || (n3 = googleSignInOptions.zao.size()) > 0) {
                return false;
            }
            n3 = this.zah.size();
            if (n3 != (n2 = googleSignInOptions.getScopes().size()) || (n3 = (int)(this.zah.containsAll(googleSignInOptions.getScopes()) ? 1 : 0)) == 0) {
                return false;
            }
            Account account = this.zai;
            return (account == null ? (account = googleSignInOptions.getAccount()) == null : (bl2 = account.equals((Object)googleSignInOptions.getAccount()))) && ((n = TextUtils.isEmpty(this.zam)) != 0 ? (n = TextUtils.isEmpty(googleSignInOptions.getServerClientId())) != 0 : (n = this.zam.equals(googleSignInOptions.getServerClientId())) != 0) && (n = this.zal) == (n2 = (int)(googleSignInOptions.isForceCodeForRefreshToken() ? 1 : 0)) && (n = (int)(this.zaj ? 1 : 0)) == (n2 = (int)(googleSignInOptions.isIdTokenRequested() ? 1 : 0)) && (n = (int)(this.zak ? 1 : 0)) == (n2 = (int)(googleSignInOptions.isServerAuthCodeRequested() ? 1 : 0)) && (bl = TextUtils.equals(this.zap, googleSignInOptions.getLogSessionId()));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @KeepForSdk
    public boolean isForceCodeForRefreshToken() {
        return this.zal;
    }

    @KeepForSdk
    public boolean isIdTokenRequested() {
        return this.zaj;
    }

    @KeepForSdk
    public boolean isServerAuthCodeRequested() {
        return this.zak;
    }

    @NonNull
    public Scope[] getScopeArray() {
        ArrayList this_ = ((GoogleSignInOptions)((Object)this_)).zah;
        return this_.toArray(new Scope[this_.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GoogleSignInOptions zab(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        Object object = new JSONObject(string2);
        Object object2 = new HashSet();
        Object object3 = ((JSONObject)object).getJSONArray("scopes");
        int n = ((JSONArray)object3).length();
        for (int i = 0; i < n; ++i) {
            Scope scope = new Scope(((JSONArray)object3).getString(i));
            object2.add(scope);
        }
        Object object4 = ((JSONObject)object).has("accountName") ? ((JSONObject)object).optString("accountName") : null;
        object4 = !TextUtils.isEmpty((CharSequence)object4) ? (object3 = new Account((String)object4, "com.google")) : null;
        ArrayList arrayList = new ArrayList(object2);
        boolean bl = ((JSONObject)object).getBoolean("idTokenRequested");
        boolean bl2 = ((JSONObject)object).getBoolean("serverAuthRequested");
        boolean bl3 = ((JSONObject)object).getBoolean("forceCodeForRefreshToken");
        object2 = ((JSONObject)object).has("serverClientId") ? ((JSONObject)object).optString("serverClientId") : null;
        object = ((JSONObject)object).has("hostedDomain") ? ((JSONObject)object).optString("hostedDomain") : null;
        HashMap hashMap = new HashMap();
        return new GoogleSignInOptions(3, arrayList, (Account)object4, bl, bl2, bl3, (String)object2, (String)object, hashMap, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final String zaf() {
        Object object = new JSONObject();
        try {
            boolean bl;
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zah, zag);
            Object object2 = this.zah.iterator();
            while (bl = object2.hasNext()) {
                jSONArray.put(((Scope)object2.next()).getScopeUri());
            }
            ((JSONObject)object).put("scopes", jSONArray);
            jSONArray = this.zai;
            if (jSONArray != null) {
                object2 = "accountName";
                ((JSONObject)object).put((String)object2, ((Account)jSONArray).name);
            }
            ((JSONObject)object).put("idTokenRequested", this.zaj);
            ((JSONObject)object).put("forceCodeForRefreshToken", this.zal);
            ((JSONObject)object).put("serverAuthRequested", this.zak);
            boolean bl2 = TextUtils.isEmpty(this.zam);
            if (!bl2) {
                ((JSONObject)object).put("serverClientId", this.zam);
            }
            if (bl2 = TextUtils.isEmpty(this.zan)) return ((JSONObject)object).toString();
            ((JSONObject)object).put("hostedDomain", this.zan);
            return ((JSONObject)object).toString();
        }
        catch (JSONException jSONException) {
            object = new RuntimeException(jSONException);
            throw object;
        }
    }

    private static Map zam(@Nullable List object) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (object == null) {
            return hashMap;
        }
        object = object.iterator();
        while (object.hasNext()) {
            GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable = (GoogleSignInOptionsExtensionParcelable)object.next();
            hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
        }
        return hashMap;
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map2, String string4, zad zad2) {
        this(3, arrayList, account, bl, bl2, bl3, string2, string3, map2, string4);
    }

    public static final class Builder {
        private Set zaa;
        private boolean zab;
        private boolean zac;
        private boolean zad;
        @Nullable
        private String zae;
        @Nullable
        private Account zaf;
        @Nullable
        private String zag;
        private Map zah;
        @Nullable
        private String zai;

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder addExtension(@NonNull GoogleSignInOptionsExtension extension) {
            void var1_1;
            if (((Builder)this_).zah.containsKey(var1_1.getExtensionType())) {
                Object this_ = new IllegalStateException("Only one extension per type may be added");
                throw this_;
            }
            List<Scope> list = var1_1.getImpliedScopes();
            if (list != null) {
                ((Builder)this_).zaa.addAll(list);
            }
            list = ((Builder)this_).zah;
            int n = var1_1.getExtensionType();
            Integer n2 = n;
            GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable = new GoogleSignInOptionsExtensionParcelable((GoogleSignInOptionsExtension)var1_1);
            list.put(n2, googleSignInOptionsExtensionParcelable);
            return this_;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder requestEmail() {
            this.zaa.add(zab);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder requestId() {
            this.zaa.add(zac);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder requestIdToken(@NonNull String serverClientId) {
            void var1_1;
            this.zad = true;
            this.zaa((String)var1_1);
            this.zae = var1_1;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder requestProfile() {
            this.zaa.add(zaa);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder requestScopes(@NonNull Scope scope, Scope ... scopes) {
            void var2_2;
            void var1_1;
            this.zaa.add(var1_1);
            this.zaa.addAll(Arrays.asList(var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requestServerAuthCode(@NonNull String serverClientId) {
            void var1_1;
            this.requestServerAuthCode((String)var1_1, false);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder requestServerAuthCode(@NonNull String serverClientId, boolean forceCodeForRefreshToken) {
            void var2_2;
            void var1_1;
            this.zab = true;
            this.zaa((String)var1_1);
            this.zae = var1_1;
            this.zac = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder setAccountName(@NonNull String accountName) {
            void var1_1;
            Account account;
            this.zaf = account = new Account(Preconditions.checkNotEmpty((String)var1_1), "com.google");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @NonNull
        public Builder setHostedDomain(@NonNull String hostedDomain) {
            void var1_1;
            this.zag = Preconditions.checkNotEmpty((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @CanIgnoreReturnValue
        @KeepForSdk
        @NonNull
        public Builder setLogSessionId(@NonNull String logSessionId) {
            void var1_1;
            this.zai = var1_1;
            return this;
        }

        @NonNull
        public GoogleSignInOptions build() {
            if (this.zaa.contains(zae) && this.zaa.contains(zad)) {
                this.zaa.remove(zad);
            }
            if (this.zad && (this.zaf == null || !this.zaa.isEmpty())) {
                this.requestId();
            }
            ArrayList arrayList = new ArrayList(this.zaa);
            GoogleSignInOptions googleSignInOptions = new GoogleSignInOptions(3, arrayList, this.zaf, this.zad, this.zab, this.zac, this.zae, this.zag, this.zah, this.zai, null);
            return googleSignInOptions;
        }

        public Builder() {
            Cloneable cloneable;
            this.zaa = cloneable = new Cloneable();
            this.zah = cloneable;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            void var1_1;
            HashSet hashSet = new HashSet();
            this.zaa = hashSet;
            this.zah = hashSet;
            Preconditions.checkNotNull(var1_1);
            this.zaa = hashSet = new HashSet(((GoogleSignInOptions)var1_1).zah);
            this.zab = ((GoogleSignInOptions)var1_1).zak;
            this.zac = ((GoogleSignInOptions)var1_1).zal;
            this.zad = ((GoogleSignInOptions)var1_1).zaj;
            this.zae = ((GoogleSignInOptions)var1_1).zam;
            this.zaf = ((GoogleSignInOptions)var1_1).zai;
            this.zag = ((GoogleSignInOptions)var1_1).zan;
            this.zah = GoogleSignInOptions.zam(((GoogleSignInOptions)var1_1).zao);
            this.zai = ((GoogleSignInOptions)var1_1).zap;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final String zaa(String string2) {
            Preconditions.checkNotEmpty(string2);
            String string3 = ((Builder)((Object)string3)).zae;
            boolean bl = string3 != null ? string3.equals(string2) : true;
            Preconditions.checkArgument(bl, "two different server client ids provided");
            return string2;
        }
    }
}

