/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.cloudmessaging.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@SafeParcelable.Class(creator="CloudMessageCreator")
public final class CloudMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    @NonNull
    public static final Parcelable.Creator<CloudMessage> CREATOR = new zzb();
    @NonNull
    @SafeParcelable.Field(id=1)
    private Intent zza;
    @GuardedBy(value="this")
    private Map<String, String> zzb;

    @SafeParcelable.Constructor
    public CloudMessage(@NonNull @SafeParcelable.Param(id=1) Intent intent) {
        this.zza = intent;
    }

    @Override
    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CloudMessage cloudMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeParcelable(parcel2, 1, (Parcelable)((Object)cloudMessage.zza), n, false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @NonNull
    public final Intent getIntent() {
        return this.zza;
    }

    @Nullable
    public final String getSenderId() {
        return this.zza.getStringExtra("google.c.sender.id");
    }

    @Nullable
    public final String getFrom() {
        return this.zza.getStringExtra("from");
    }

    @Nullable
    public final String getTo() {
        return this.zza.getStringExtra("google.to");
    }

    @NonNull
    public final synchronized Map<String, String> getData() {
        if (this.zzb == null) {
            Bundle bundle = this.zza.getExtras();
            ArrayMap arrayMap = new ArrayMap();
            if (bundle != null) {
                for (String string2 : bundle.keySet()) {
                    Object object = bundle.get(string2);
                    if (!(object instanceof String)) continue;
                    String string3 = (String)object;
                    if (string2.startsWith("google.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                    arrayMap.put((Object)string2, (Object)string3);
                }
            }
            this.zzb = arrayMap;
        }
        return this.zzb;
    }

    @Nullable
    public final byte[] getRawData() {
        return this.zza.getByteArrayExtra("rawData");
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zza.getStringExtra("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zza.getStringExtra("google.message_id");
        if (string2 == null) {
            string2 = this.zza.getStringExtra("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zza.getStringExtra("message_type");
    }

    public final long getSentTime() {
        Bundle bundle = this.zza.getExtras();
        Object object = bundle != null ? bundle.get("google.sent_time") : null;
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w("CloudMessage", new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Bundle bundle = this.zza.getExtras();
        Object object = bundle != null ? bundle.get("google.ttl") : null;
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w("CloudMessage", new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string2 = this.zza.getStringExtra("google.original_priority");
        if (string2 == null) {
            string2 = this.zza.getStringExtra("google.priority");
        }
        return CloudMessage.zza(string2);
    }

    public final int getPriority() {
        String string2 = this.zza.getStringExtra("google.delivered_priority");
        if (string2 == null) {
            if ("1".equals(this.zza.getStringExtra("google.priority_reduced"))) {
                return 2;
            }
            string2 = this.zza.getStringExtra("google.priority");
        }
        return CloudMessage.zza(string2);
    }

    private static int zza(@Nullable String string2) {
        if ("high".equals(string2)) {
            return 1;
        }
        if ("normal".equals(string2)) {
            return 2;
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface MessagePriority {
    }
}

