/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zaa;
import com.google.android.gms.common.images.zab;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.images.zaf;
import com.google.android.gms.common.images.zag;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zam;
import com.google.android.gms.internal.base.zat;
import com.google.android.gms.internal.base.zau;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zaa;
    private static HashSet zab;
    private static ImageManager zac;
    private final Context zad;
    private final Handler zae;
    private final ExecutorService zaf;
    private final zam zag;
    private final Map zah;
    private final Map zai;
    private final Map zaj;

    @NonNull
    public static ImageManager create(@NonNull Context context) {
        if (zac == null) {
            Context context2;
            ImageManager imageManager;
            zac = imageManager = new ImageManager(context2, false);
        }
        return zac;
    }

    static {
        HashSet hashSet = new HashSet();
        zaa = hashSet;
        zab = hashSet = new HashSet();
    }

    private ImageManager(Context object, boolean bl) {
        this.zad = ((Context)object).getApplicationContext();
        this.zae = object = new zau(Looper.getMainLooper());
        this.zaf = zat.zaa().zab(4, 2);
        object = new zam();
        this.zag = object;
        object = new HashMap();
        this.zah = object;
        object = new HashMap();
        this.zai = object;
        object = new HashMap();
        this.zaj = object;
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, int resId) {
        void var2_2;
        void var1_1;
        zae zae2 = new zae((ImageView)var1_1, (int)var2_2);
        this.zaj(zae2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        zae zae2 = new zae((ImageView)var1_1, (Uri)var2_2);
        this.zaj(zae2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener2, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        zaf zaf2 = new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2);
        this.zaj(zaf2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri, int defaultResId) {
        void var3_3;
        void var2_2;
        void var1_1;
        zae zae2 = new zae((ImageView)var1_1, (Uri)var2_2);
        zae2.zab = var3_3;
        this.zaj(zae2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener2, @NonNull Uri uri, int defaultResId) {
        void var3_3;
        void var2_2;
        void var1_1;
        zaf zaf2 = new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2);
        zaf2.zab = var3_3;
        this.zaj(zaf2);
    }

    static /* bridge */ /* synthetic */ Handler zab(ImageManager imageManager) {
        return imageManager.zae;
    }

    static /* bridge */ /* synthetic */ zam zac(ImageManager imageManager) {
        return imageManager.zag;
    }

    static /* bridge */ /* synthetic */ Object zad() {
        return zaa;
    }

    static /* bridge */ /* synthetic */ HashSet zae() {
        return zab;
    }

    static /* bridge */ /* synthetic */ Map zaf(ImageManager imageManager) {
        return imageManager.zaj;
    }

    static /* bridge */ /* synthetic */ Map zag(ImageManager imageManager) {
        return imageManager.zah;
    }

    static /* bridge */ /* synthetic */ Map zah(ImageManager imageManager) {
        return imageManager.zai;
    }

    public final void zaj(zag zag2) {
        Asserts.checkMainThread("ImageManager.loadImage() must be called in the main thread");
        zab zab2 = new zab(this, zag2);
        zab2.run();
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(@NonNull Uri var1, @Nullable Drawable var2, boolean var3);
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zab;
        private final ArrayList zac;

        ImageReceiver(Uri uri) {
            ImageManager.this = new ArrayList(Looper.getMainLooper());
            super((Handler)((Object)ImageManager.this));
            this.zab = uri;
            this.zac = ImageManager.this = new ArrayList();
        }

        public final void onReceiveResult(int n, Bundle object) {
            Parcelable parcelable = object.getParcelable("com.google.android.gms.extra.fileDescriptor");
            parcelable = (ParcelFileDescriptor)parcelable;
            object = ImageManager.this;
            ExecutorService executorService = ((ImageManager)object).zaf;
            zaa zaa2 = new zaa((ImageManager)object, this.zab, (ParcelFileDescriptor)parcelable);
            executorService.execute(zaa2);
        }

        static /* bridge */ /* synthetic */ ArrayList zaa(ImageReceiver imageReceiver) {
            return imageReceiver.zac;
        }

        public final void zab(zag zag2) {
            Asserts.checkMainThread("ImageReceiver.addImageRequest() must be called in the main thread");
            this.zac.add(zag2);
        }

        public final void zac(zag zag2) {
            Asserts.checkMainThread("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zac.remove(zag2);
        }

        public final void zad() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", this.zab);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)((Object)this));
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.zad.sendBroadcast(intent);
        }
    }
}

