/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.Slashes;
import com.google.firebase.storage.internal.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private static final String TAG = "StorageMetadata";
    @NonNull
    private static final String CONTENT_LANGUAGE = "contentLanguage";
    @NonNull
    private static final String CONTENT_ENCODING = "contentEncoding";
    @NonNull
    private static final String CONTENT_DISPOSITION = "contentDisposition";
    @NonNull
    private static final String CACHE_CONTROL = "cacheControl";
    @NonNull
    private static final String CUSTOM_METADATA_KEY = "metadata";
    @NonNull
    private static final String CONTENT_TYPE_KEY = "contentType";
    @NonNull
    private static final String MD5_HASH_KEY = "md5Hash";
    @NonNull
    private static final String SIZE_KEY = "size";
    @NonNull
    private static final String TIME_UPDATED_KEY = "updated";
    @NonNull
    private static final String TIME_CREATED_KEY = "timeCreated";
    @NonNull
    private static final String META_GENERATION_KEY = "metageneration";
    @NonNull
    private static final String BUCKET_KEY = "bucket";
    @NonNull
    private static final String NAME_KEY = "name";
    @NonNull
    private static final String GENERATION_KEY = "generation";
    private String mPath = null;
    private FirebaseStorage mStorage = null;
    private StorageReference mStorageRef = null;
    private String mBucket = null;
    private String mGeneration = null;
    private MetadataValue<String> mContentType = MetadataValue.withDefaultValue("");
    private String mMetadataGeneration = null;
    private String mCreationTime = null;
    private String mUpdatedTime = null;
    private long mSize;
    private String mMD5Hash = null;
    private MetadataValue<String> mCacheControl = MetadataValue.withDefaultValue("");
    private MetadataValue<String> mContentDisposition = MetadataValue.withDefaultValue("");
    private MetadataValue<String> mContentEncoding = MetadataValue.withDefaultValue("");
    private MetadataValue<String> mContentLanguage = MetadataValue.withDefaultValue("");
    private MetadataValue<Map<String, String>> mCustomMetadata = MetadataValue.withDefaultValue(Collections.emptyMap());

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata original, boolean fullClone) {
        Preconditions.checkNotNull(original);
        this.mPath = original.mPath;
        this.mStorage = original.mStorage;
        this.mStorageRef = original.mStorageRef;
        this.mBucket = original.mBucket;
        this.mContentType = original.mContentType;
        this.mCacheControl = original.mCacheControl;
        this.mContentDisposition = original.mContentDisposition;
        this.mContentEncoding = original.mContentEncoding;
        this.mContentLanguage = original.mContentLanguage;
        this.mCustomMetadata = original.mCustomMetadata;
        if (fullClone) {
            this.mMD5Hash = original.mMD5Hash;
            this.mSize = original.mSize;
            this.mUpdatedTime = original.mUpdatedTime;
            this.mCreationTime = original.mCreationTime;
            this.mMetadataGeneration = original.mMetadataGeneration;
            this.mGeneration = original.mGeneration;
        }
    }

    @Nullable
    public String getContentType() {
        return this.mContentType.getValue();
    }

    @Nullable
    public String getCustomMetadata(@NonNull String key) {
        if (TextUtils.isEmpty(key)) {
            return null;
        }
        Map<String, String> metadata = this.mCustomMetadata.getValue();
        return metadata.get(key);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        Map<String, String> metadata = this.mCustomMetadata.getValue();
        return metadata.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String path = this.getPath();
        if (TextUtils.isEmpty(path)) {
            return null;
        }
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex != -1) {
            return path.substring(lastIndex + 1);
        }
        return path;
    }

    @Nullable
    public String getBucket() {
        return this.mBucket;
    }

    @Nullable
    public String getGeneration() {
        return this.mGeneration;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.mMetadataGeneration;
    }

    public long getCreationTimeMillis() {
        return Util.parseDateTime(this.mCreationTime);
    }

    public long getUpdatedTimeMillis() {
        return Util.parseDateTime(this.mUpdatedTime);
    }

    public long getSizeBytes() {
        return this.mSize;
    }

    @Nullable
    public String getMd5Hash() {
        return this.mMD5Hash;
    }

    @Nullable
    public String getCacheControl() {
        return this.mCacheControl.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.mContentDisposition.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.mContentEncoding.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.mContentLanguage.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.mStorageRef == null && this.mStorage != null) {
            String bucket = this.getBucket();
            String path = this.getPath();
            if (TextUtils.isEmpty(bucket) || TextUtils.isEmpty(path)) {
                return null;
            }
            Uri uri = new Uri.Builder().scheme("gs").authority(bucket).encodedPath(Slashes.preserveSlashEncode(path)).build();
            return new StorageReference(uri, this.mStorage);
        }
        return this.mStorageRef;
    }

    @NonNull
    JSONObject createJSONObject() {
        HashMap<String, Object> jsonData = new HashMap<String, Object>();
        if (this.mContentType.isUserProvided()) {
            jsonData.put(CONTENT_TYPE_KEY, this.getContentType());
        }
        if (this.mCustomMetadata.isUserProvided()) {
            jsonData.put(CUSTOM_METADATA_KEY, new JSONObject(this.mCustomMetadata.getValue()));
        }
        if (this.mCacheControl.isUserProvided()) {
            jsonData.put(CACHE_CONTROL, this.getCacheControl());
        }
        if (this.mContentDisposition.isUserProvided()) {
            jsonData.put(CONTENT_DISPOSITION, this.getContentDisposition());
        }
        if (this.mContentEncoding.isUserProvided()) {
            jsonData.put(CONTENT_ENCODING, this.getContentEncoding());
        }
        if (this.mContentLanguage.isUserProvided()) {
            jsonData.put(CONTENT_LANGUAGE, this.getContentLanguage());
        }
        return new JSONObject(jsonData);
    }

    public static class Builder {
        StorageMetadata mMetadata;
        boolean mFromJSON;

        public Builder() {
            this.mMetadata = new StorageMetadata();
        }

        public Builder(@NonNull StorageMetadata original) {
            this.mMetadata = new StorageMetadata(original, false);
        }

        Builder(JSONObject resultBody, StorageReference thisStorageRef) throws JSONException {
            this(resultBody);
            this.mMetadata.mStorageRef = thisStorageRef;
        }

        Builder(JSONObject resultBody) throws JSONException {
            this.mMetadata = new StorageMetadata();
            if (resultBody != null) {
                this.parseJSON(resultBody);
                this.mFromJSON = true;
            }
        }

        @Nullable
        private String extractString(JSONObject jsonObject, String key) throws JSONException {
            if (jsonObject.has(key) && !jsonObject.isNull(key)) {
                return jsonObject.getString(key);
            }
            return null;
        }

        private void parseJSON(JSONObject jsonObject) throws JSONException {
            String value;
            this.mMetadata.mGeneration = jsonObject.optString(StorageMetadata.GENERATION_KEY);
            this.mMetadata.mPath = jsonObject.optString(StorageMetadata.NAME_KEY);
            this.mMetadata.mBucket = jsonObject.optString(StorageMetadata.BUCKET_KEY);
            this.mMetadata.mMetadataGeneration = jsonObject.optString(StorageMetadata.META_GENERATION_KEY);
            this.mMetadata.mCreationTime = jsonObject.optString(StorageMetadata.TIME_CREATED_KEY);
            this.mMetadata.mUpdatedTime = jsonObject.optString(StorageMetadata.TIME_UPDATED_KEY);
            this.mMetadata.mSize = jsonObject.optLong(StorageMetadata.SIZE_KEY);
            this.mMetadata.mMD5Hash = jsonObject.optString(StorageMetadata.MD5_HASH_KEY);
            if (jsonObject.has(StorageMetadata.CUSTOM_METADATA_KEY) && !jsonObject.isNull(StorageMetadata.CUSTOM_METADATA_KEY)) {
                JSONObject customMetadata = jsonObject.getJSONObject(StorageMetadata.CUSTOM_METADATA_KEY);
                Iterator<String> keyIterator = customMetadata.keys();
                while (keyIterator.hasNext()) {
                    String key = keyIterator.next();
                    this.setCustomMetadata(key, customMetadata.getString(key));
                }
            }
            if ((value = this.extractString(jsonObject, StorageMetadata.CONTENT_TYPE_KEY)) != null) {
                this.setContentType(value);
            }
            if ((value = this.extractString(jsonObject, StorageMetadata.CACHE_CONTROL)) != null) {
                this.setCacheControl(value);
            }
            if ((value = this.extractString(jsonObject, StorageMetadata.CONTENT_DISPOSITION)) != null) {
                this.setContentDisposition(value);
            }
            if ((value = this.extractString(jsonObject, StorageMetadata.CONTENT_ENCODING)) != null) {
                this.setContentEncoding(value);
            }
            if ((value = this.extractString(jsonObject, StorageMetadata.CONTENT_LANGUAGE)) != null) {
                this.setContentLanguage(value);
            }
        }

        @NonNull
        public StorageMetadata build() {
            return new StorageMetadata(this.mMetadata, this.mFromJSON);
        }

        @NonNull
        public Builder setContentLanguage(@Nullable String contentLanguage) {
            this.mMetadata.mContentLanguage = MetadataValue.withUserValue(contentLanguage);
            return this;
        }

        @Nullable
        public String getContentLanguage() {
            return (String)this.mMetadata.mContentLanguage.getValue();
        }

        @NonNull
        public Builder setContentEncoding(@Nullable String contentEncoding) {
            this.mMetadata.mContentEncoding = MetadataValue.withUserValue(contentEncoding);
            return this;
        }

        @Nullable
        public String getContentEncoding() {
            return (String)this.mMetadata.mContentEncoding.getValue();
        }

        @NonNull
        public Builder setContentDisposition(@Nullable String contentDisposition) {
            this.mMetadata.mContentDisposition = MetadataValue.withUserValue(contentDisposition);
            return this;
        }

        @Nullable
        public String getContentDisposition() {
            return (String)this.mMetadata.mContentDisposition.getValue();
        }

        @NonNull
        public Builder setCacheControl(@Nullable String cacheControl) {
            this.mMetadata.mCacheControl = MetadataValue.withUserValue(cacheControl);
            return this;
        }

        @Nullable
        public String getCacheControl() {
            return (String)this.mMetadata.mCacheControl.getValue();
        }

        @NonNull
        public Builder setCustomMetadata(@NonNull String key, @Nullable String value) {
            if (!this.mMetadata.mCustomMetadata.isUserProvided()) {
                this.mMetadata.mCustomMetadata = MetadataValue.withUserValue(new HashMap());
            }
            ((Map)this.mMetadata.mCustomMetadata.getValue()).put(key, value);
            return this;
        }

        @NonNull
        public Builder setContentType(@Nullable String contentType) {
            this.mMetadata.mContentType = MetadataValue.withUserValue(contentType);
            return this;
        }

        @Nullable
        public String getContentType() {
            return (String)this.mMetadata.mContentType.getValue();
        }
    }

    private static class MetadataValue<T> {
        private final boolean userProvided;
        @Nullable
        private final T value;

        MetadataValue(@Nullable T value, boolean userProvided) {
            this.userProvided = userProvided;
            this.value = value;
        }

        static <T> MetadataValue<T> withDefaultValue(T value) {
            return new MetadataValue<T>(value, false);
        }

        static <T> MetadataValue<T> withUserValue(@Nullable T value) {
            return new MetadataValue<T>(value, true);
        }

        boolean isUserProvided() {
            return this.userProvided;
        }

        @Nullable
        T getValue() {
            return this.value;
        }
    }
}

