/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import java.util.Map;
import java.util.Set;
import net.hollowcube.posthog.FeatureFlagState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureFlagStates {
    public static final FeatureFlagStates EMPTY = new FeatureFlagStates(Map.of());
    private final Map<String, FeatureFlagState> states;

    FeatureFlagStates(@NotNull Map<String, FeatureFlagState> states) {
        this.states = states;
    }

    @NotNull
    public FeatureFlagState get(@NotNull String key) {
        return this.states.getOrDefault(key, FeatureFlagState.DISABLED);
    }

    public boolean isEnabled(@NotNull String key) {
        return this.get(key).isEnabled();
    }

    @Nullable
    public String getVariant(@NotNull String key) {
        return this.get(key).getVariant();
    }

    @NotNull
    public Set<String> keySet() {
        return this.states.keySet();
    }

    @NotNull
    public Map<String, FeatureFlagState> getStates() {
        return this.states;
    }

    public String toString() {
        return this.states.toString();
    }
}

