/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.annotations;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.annotations.Alias;
import dev.jorel.commandapi.annotations.Command;
import dev.jorel.commandapi.annotations.Default;
import dev.jorel.commandapi.annotations.Help;
import dev.jorel.commandapi.annotations.NeedsOp;
import dev.jorel.commandapi.annotations.Permission;
import dev.jorel.commandapi.annotations.Subcommand;
import dev.jorel.commandapi.annotations.arguments.AAdvancementArgument;
import dev.jorel.commandapi.annotations.arguments.AAdventureChatArgument;
import dev.jorel.commandapi.annotations.arguments.AAdventureChatComponentArgument;
import dev.jorel.commandapi.annotations.arguments.AAngleArgument;
import dev.jorel.commandapi.annotations.arguments.AAxisArgument;
import dev.jorel.commandapi.annotations.arguments.ABiomeArgument;
import dev.jorel.commandapi.annotations.arguments.ABlockPredicateArgument;
import dev.jorel.commandapi.annotations.arguments.ABlockStateArgument;
import dev.jorel.commandapi.annotations.arguments.ABooleanArgument;
import dev.jorel.commandapi.annotations.arguments.AChatArgument;
import dev.jorel.commandapi.annotations.arguments.AChatColorArgument;
import dev.jorel.commandapi.annotations.arguments.AChatComponentArgument;
import dev.jorel.commandapi.annotations.arguments.ADoubleArgument;
import dev.jorel.commandapi.annotations.arguments.AEnchantmentArgument;
import dev.jorel.commandapi.annotations.arguments.AEntitySelectorArgument;
import dev.jorel.commandapi.annotations.arguments.AEntityType;
import dev.jorel.commandapi.annotations.arguments.AEnvironmentArgument;
import dev.jorel.commandapi.annotations.arguments.AFloatArgument;
import dev.jorel.commandapi.annotations.arguments.AFloatRangeArgument;
import dev.jorel.commandapi.annotations.arguments.AFunctionArgument;
import dev.jorel.commandapi.annotations.arguments.AGreedyStringArgument;
import dev.jorel.commandapi.annotations.arguments.AIntegerArgument;
import dev.jorel.commandapi.annotations.arguments.AIntegerRangeArgument;
import dev.jorel.commandapi.annotations.arguments.AItemStackArgument;
import dev.jorel.commandapi.annotations.arguments.AItemStackPredicateArgument;
import dev.jorel.commandapi.annotations.arguments.ALiteralArgument;
import dev.jorel.commandapi.annotations.arguments.ALocation2DArgument;
import dev.jorel.commandapi.annotations.arguments.ALocationArgument;
import dev.jorel.commandapi.annotations.arguments.ALongArgument;
import dev.jorel.commandapi.annotations.arguments.ALootTableArgument;
import dev.jorel.commandapi.annotations.arguments.AMathOperationArgument;
import dev.jorel.commandapi.annotations.arguments.AMultiLiteralArgument;
import dev.jorel.commandapi.annotations.arguments.ANBTCompoundArgument;
import dev.jorel.commandapi.annotations.arguments.AObjectiveArgument;
import dev.jorel.commandapi.annotations.arguments.AObjectiveCriteriaArgument;
import dev.jorel.commandapi.annotations.arguments.AOfflinePlayerArgument;
import dev.jorel.commandapi.annotations.arguments.AParticleArgument;
import dev.jorel.commandapi.annotations.arguments.APlayerArgument;
import dev.jorel.commandapi.annotations.arguments.APotionEffectArgument;
import dev.jorel.commandapi.annotations.arguments.ARecipeArgument;
import dev.jorel.commandapi.annotations.arguments.ARotationArgument;
import dev.jorel.commandapi.annotations.arguments.AScoreHolderArgument;
import dev.jorel.commandapi.annotations.arguments.AScoreboardSlotArgument;
import dev.jorel.commandapi.annotations.arguments.ASoundArgument;
import dev.jorel.commandapi.annotations.arguments.AStringArgument;
import dev.jorel.commandapi.annotations.arguments.ATeamArgument;
import dev.jorel.commandapi.annotations.arguments.ATextArgument;
import dev.jorel.commandapi.annotations.arguments.ATimeArgument;
import dev.jorel.commandapi.annotations.arguments.AUUIDArgument;
import dev.jorel.commandapi.annotations.arguments.Primitive;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.ScoreHolderArgument;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Annotations
extends AbstractProcessor {
    private final Class<?>[] ARGUMENT_ANNOTATIONS = new Class[]{AAdvancementArgument.class, AAdventureChatArgument.class, AAdventureChatComponentArgument.class, AAngleArgument.class, AAxisArgument.class, ABiomeArgument.class, ABlockPredicateArgument.class, ABlockStateArgument.class, ABooleanArgument.class, AChatArgument.class, AChatColorArgument.class, AChatComponentArgument.class, ADoubleArgument.class, AEnchantmentArgument.class, AEntitySelectorArgument.class, AEntityType.class, AEnvironmentArgument.class, AFloatArgument.class, AFloatRangeArgument.class, AFunctionArgument.class, AGreedyStringArgument.class, AIntegerArgument.class, AIntegerRangeArgument.class, AItemStackArgument.class, AItemStackPredicateArgument.class, ALiteralArgument.class, ALocation2DArgument.class, ALocationArgument.class, ALongArgument.class, ALootTableArgument.class, AMathOperationArgument.class, AMultiLiteralArgument.class, ANBTCompoundArgument.class, AObjectiveArgument.class, AObjectiveCriteriaArgument.class, AOfflinePlayerArgument.class, AParticleArgument.class, APlayerArgument.class, APotionEffectArgument.class, ARecipeArgument.class, ARotationArgument.class, AScoreboardSlotArgument.class, AScoreHolderArgument.class, ASoundArgument.class, AStringArgument.class, ATeamArgument.class, ATextArgument.class, ATimeArgument.class, AUUIDArgument.class};

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.concat(Arrays.stream(new Class[]{Alias.class, Command.class, Default.class, NeedsOp.class, Permission.class, Subcommand.class, Help.class}), Arrays.stream(this.ARGUMENT_ANNOTATIONS)).map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Command.class)) {
            try {
                this.processCommand(roundEnv, element);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String indent(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append("    ");
        }
        return builder.toString();
    }

    private String simpleFromQualified(String name) {
        if (name == null) {
            return null;
        }
        return name.split("\\.")[name.split("\\.").length - 1];
    }

    private SortedSet<String> calculateImports(Element classElement) {
        TreeSet<String> imports = new TreeSet<String>();
        imports.add(CommandAPICommand.class.getCanonicalName());
        if (classElement.getAnnotation(NeedsOp.class) != null) {
            imports.add(CommandPermission.class.getCanonicalName());
        }
        for (Element element : classElement.getEnclosedElements()) {
            if (element.getAnnotation(Subcommand.class) != null) {
                imports.add(MultiLiteralArgument.class.getCanonicalName());
            }
            if (element.getAnnotation(NeedsOp.class) != null) {
                imports.add(CommandPermission.class.getCanonicalName());
            }
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement method = (ExecutableElement)element;
            for (VariableElement variableElement : method.getParameters()) {
                if (this.getArgument(variableElement) == null) continue;
                imports.addAll(Arrays.asList(this.getPrimitive(this.getArgument(variableElement)).value()));
                imports.add("dev.jorel.commandapi.arguments." + this.getArgument(variableElement).annotationType().getSimpleName().substring(1));
                if (this.getArgument(variableElement) instanceof ALocationArgument || this.getArgument(variableElement) instanceof ALocation2DArgument) {
                    imports.add(LocationType.class.getCanonicalName());
                    continue;
                }
                if (this.getArgument(variableElement) instanceof AScoreHolderArgument) {
                    imports.add(ScoreHolderArgument.ScoreHolderType.class.getCanonicalName());
                    continue;
                }
                if (!(this.getArgument(variableElement) instanceof AEntitySelectorArgument)) continue;
                imports.add(EntitySelectorArgument.EntitySelector.class.getCanonicalName());
            }
        }
        for (String string : new TreeSet(imports)) {
            if (!string.contains("<")) continue;
            imports.add(string.substring(0, string.indexOf("<")));
            imports.add(string.substring(string.indexOf("<") + 1, string.indexOf(">")));
        }
        return imports;
    }

    private void emitImports(PrintWriter out, Element classElement) {
        String previousImport = "";
        for (String import_ : this.calculateImports(classElement)) {
            if (previousImport.contains(".") && import_.contains(".") && !previousImport.substring(0, previousImport.indexOf(".")).equals(import_.substring(0, import_.indexOf(".")))) {
                out.println();
            }
            if (!import_.contains(".") || import_.contains("<")) continue;
            out.print("import ");
            out.print(import_);
            out.println(";");
            previousImport = import_;
        }
        out.println();
    }

    private void emitPackage(PrintWriter out, TypeElement commandClass) {
        int lastDot = commandClass.getQualifiedName().toString().lastIndexOf(46);
        if (lastDot > 0) {
            out.print("package ");
            out.print(commandClass.getQualifiedName().toString().substring(0, lastDot));
            out.println(";");
            out.println();
        }
    }

    private int emitSubcommand(PrintWriter out, Element methodElement, int indent) {
        if (methodElement.getAnnotation(Subcommand.class) != null) {
            out.println(this.indent(indent) + ".withArguments(");
            out.print(this.indent(++indent) + "new MultiLiteralArgument(");
            if (methodElement.getAnnotation(Subcommand.class).value().length == 0) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid @Subcommand on " + methodElement.getSimpleName() + " - no subcommand name was found");
            }
            out.print(Arrays.stream(methodElement.getAnnotation(Subcommand.class).value()).map(x -> "\"" + x + "\"").collect(Collectors.joining(", ")));
            out.println(")");
            out.println(this.indent(++indent) + ".setListed(false)");
            if (methodElement.getAnnotation(NeedsOp.class) != null) {
                out.println(this.indent(indent) + ".withPermission(CommandPermission.OP)");
            }
            if (methodElement.getAnnotation(Permission.class) != null) {
                out.print(this.indent(indent) + ".withPermission(\"");
                out.print(methodElement.getAnnotation(Permission.class).value());
                out.println("\")");
            }
            --indent;
            out.println(this.indent(--indent) + ")");
        }
        return indent;
    }

    private <T extends Annotation> Map<Integer, String> emitArgumentsAndGenerateArgumentMapping(PrintWriter out, Element methodElement, int indent) throws IllegalArgumentException {
        HashMap<Integer, String> argumentMapping = new HashMap<Integer, String>();
        ExecutableElement executableMethodElement = (ExecutableElement)methodElement;
        block10: for (int i = 1; i < executableMethodElement.getParameters().size(); ++i) {
            VariableElement parameter = executableMethodElement.getParameters().get(i);
            T argumentAnnotation = this.getArgument(parameter);
            if (argumentAnnotation == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Parameter " + parameter.getSimpleName() + " in method " + methodElement.getSimpleName() + " does not have an argument annotation on it! ");
                throw new IllegalArgumentException();
            }
            this.emitArgument(out, argumentAnnotation, parameter, indent);
            Primitive primitive = this.getPrimitive(argumentAnnotation);
            if (primitive.value().length == 1) {
                argumentMapping.put(i - 1, primitive.value()[0]);
                continue;
            }
            if (argumentAnnotation instanceof AEntitySelectorArgument) {
                AEntitySelectorArgument argument = (AEntitySelectorArgument)argumentAnnotation;
                switch (argument.value()) {
                    case MANY_ENTITIES: {
                        argumentMapping.put(i - 1, primitive.value()[0]);
                        continue block10;
                    }
                    case MANY_PLAYERS: {
                        argumentMapping.put(i - 1, primitive.value()[1]);
                        continue block10;
                    }
                    case ONE_ENTITY: {
                        argumentMapping.put(i - 1, primitive.value()[2]);
                        continue block10;
                    }
                    case ONE_PLAYER: {
                        argumentMapping.put(i - 1, primitive.value()[3]);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + argument.value());
                    }
                }
            }
            if (!(argumentAnnotation instanceof AScoreHolderArgument)) continue;
            AScoreHolderArgument argument = (AScoreHolderArgument)argumentAnnotation;
            switch (argument.value()) {
                case MULTIPLE: {
                    argumentMapping.put(i - 1, primitive.value()[0]);
                    continue block10;
                }
                case SINGLE: {
                    argumentMapping.put(i - 1, primitive.value()[1]);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + argument.value());
                }
            }
        }
        return argumentMapping;
    }

    private int emitExecutes(PrintWriter out, Map<Integer, String> argumentMapping, ExecutableType methodType, TypeElement commandClass, Element methodElement, int indent) {
        String[] firstParam = methodType.getParameterTypes().get(0).toString().split("\\.");
        out.print(this.indent(indent));
        switch (firstParam[firstParam.length - 1]) {
            case "Player": {
                out.print(".executesPlayer");
                break;
            }
            case "ConsoleCommandSender": {
                out.print(".executesConsole");
                break;
            }
            case "BlockCommandSender": {
                out.print(".executesCommandBlock");
                break;
            }
            case "ProxiedCommandSender": {
                out.print(".executesProxy");
                break;
            }
            case "NativeProxyCommandSender": {
                out.print(".executesNative");
                break;
            }
            case "Entity": {
                out.print(".executesEntity");
                break;
            }
            case "CommandSender": {
                out.print(".executes");
                break;
            }
            default: {
                out.print(".executes");
            }
        }
        out.println("((sender, args) -> {");
        out.print(this.indent(++indent));
        if (methodType.getReturnType().toString().equals("int")) {
            out.print("return ");
        }
        out.print(commandClass.getSimpleName());
        out.print(".");
        out.print(methodElement.getSimpleName());
        out.print("(sender");
        for (int i = 0; i < argumentMapping.size(); ++i) {
            String fromArgumentMap = argumentMapping.get(i);
            out.print(", (");
            if (fromArgumentMap.contains("<")) {
                out.print(this.simpleFromQualified(fromArgumentMap.substring(0, fromArgumentMap.indexOf("<"))));
                out.print("<");
                out.print(this.simpleFromQualified(fromArgumentMap.substring(fromArgumentMap.indexOf("<") + 1, fromArgumentMap.indexOf(">"))));
                out.print(">");
            } else {
                out.print(this.simpleFromQualified(fromArgumentMap));
            }
            out.print(") args[");
            out.print(i);
            out.print("]");
        }
        out.println(");");
        out.println(this.indent(--indent) + "})");
        return indent;
    }

    private int emitClassDeclarationStart(PrintWriter out, TypeElement commandClass, int indent) {
        out.println("// This class was automatically generated by the CommandAPI");
        out.print("public class ");
        out.print(commandClass.getSimpleName() + "$Command");
        out.println(" {");
        out.println();
        return ++indent;
    }

    private void emitPermission(PrintWriter out, Element classElement, int indent) {
        if (classElement.getAnnotation(Permission.class) != null) {
            out.print(this.indent(indent) + ".withPermission(\"");
            out.print(classElement.getAnnotation(Permission.class).value());
            out.println("\")");
        }
    }

    private void emitAlias(PrintWriter out, Element classElement, int indent) {
        if (classElement.getAnnotation(Alias.class) != null) {
            out.print(this.indent(indent) + ".withAliases(");
            out.print(Arrays.stream(classElement.getAnnotation(Alias.class).value()).map(x -> "\"" + x + "\"").collect(Collectors.joining(", ")));
            out.println(")");
        }
    }

    private void emitNeedsOp(PrintWriter out, Element classElement, int indent) {
        if (classElement.getAnnotation(NeedsOp.class) != null) {
            out.println(this.indent(indent) + ".withPermission(CommandPermission.OP)");
        }
    }

    private void emitHelp(PrintWriter out, Element classElement, int indent) {
        if (classElement.getAnnotation(Help.class) != null) {
            Help helpAnnotation = classElement.getAnnotation(Help.class);
            if (helpAnnotation.shortDescription().isEmpty()) {
                out.print(this.indent(indent) + ".withFullDescription(\"");
                out.print(helpAnnotation.value());
                out.println("\")");
            } else {
                out.print(this.indent(indent) + ".withHelp(\"");
                out.print(helpAnnotation.shortDescription());
                out.print("\", \"");
                out.print(helpAnnotation.value());
                out.println("\")");
            }
        }
    }

    private <T extends Annotation> void processCommand(RoundEnvironment roundEnv, Element classElement) throws IOException {
        TypeElement commandClass = (TypeElement)classElement;
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(commandClass.getQualifiedName() + "$Command", new Element[0]);
        int indent = 0;
        PrintWriter out = new PrintWriter(builderFile.openWriter());
        try {
            this.emitPackage(out, commandClass);
            this.emitImports(out, classElement);
            this.emitClassDeclarationStart(out, commandClass, indent);
            out.println(this.indent(indent) + "@SuppressWarnings(\"unchecked\")");
            out.println(this.indent(indent) + "public static void register() {");
            out.println();
            ++indent;
            for (Element element : classElement.getEnclosedElements()) {
                if (element.getAnnotation(Default.class) == null && element.getAnnotation(Subcommand.class) == null) continue;
                ExecutableType methodType = (ExecutableType)element.asType();
                if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Method " + element.getSimpleName() + " must be static to be used as a command");
                }
                out.print(this.indent(indent) + "new CommandAPICommand(\"");
                out.print(commandClass.getAnnotation(Command.class).value());
                out.println("\")");
                ++indent;
                indent = this.emitSubcommand(out, element, indent);
                this.emitNeedsOp(out, classElement, indent);
                this.emitPermission(out, classElement, indent);
                this.emitAlias(out, classElement, indent);
                this.emitHelp(out, classElement, indent);
                Map<Integer, String> argumentMapping = null;
                try {
                    argumentMapping = this.emitArgumentsAndGenerateArgumentMapping(out, element, indent);
                }
                catch (IllegalArgumentException e) {
                    out.close();
                    return;
                }
                indent = this.emitExecutes(out, argumentMapping, methodType, commandClass, element, indent);
                out.println(this.indent(indent) + ".register();");
                out.println();
                --indent;
            }
            out.println(this.indent(indent) + "}");
            --indent;
            out.println();
            out.println("}");
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private <T extends Annotation> void emitArgument(PrintWriter out, T argumentAnnotation, VariableElement parameter, int indent) {
        out.print(this.indent(indent) + ".withArguments(new ");
        out.print(argumentAnnotation.annotationType().getSimpleName().substring(1));
        if (argumentAnnotation instanceof AMultiLiteralArgument || argumentAnnotation instanceof ALiteralArgument) {
            out.print("(");
        } else {
            out.print("(\"");
            out.print(parameter.getSimpleName());
            out.print("\"");
        }
        if (argumentAnnotation instanceof AIntegerArgument) {
            AIntegerArgument argument = (AIntegerArgument)argumentAnnotation;
            out.print(", " + argument.min() + ", " + argument.max());
        } else if (argumentAnnotation instanceof ALongArgument) {
            ALongArgument argument = (ALongArgument)argumentAnnotation;
            out.print(", " + argument.min() + "L, " + argument.max() + "L");
        } else if (argumentAnnotation instanceof AFloatArgument) {
            AFloatArgument argument = (AFloatArgument)argumentAnnotation;
            out.print(", " + argument.min() + "F, " + argument.max() + "F");
        } else if (argumentAnnotation instanceof ADoubleArgument) {
            ADoubleArgument argument = (ADoubleArgument)argumentAnnotation;
            out.print(", " + argument.min() + "D, " + argument.max() + "D");
        } else if (argumentAnnotation instanceof ALocation2DArgument) {
            ALocation2DArgument argument = (ALocation2DArgument)argumentAnnotation;
            out.print(", " + LocationType.class.getSimpleName() + "." + argument.value().toString());
        } else if (argumentAnnotation instanceof ALocationArgument) {
            ALocationArgument argument = (ALocationArgument)argumentAnnotation;
            out.print(", " + LocationType.class.getSimpleName() + "." + argument.value().toString());
        } else if (argumentAnnotation instanceof AEntitySelectorArgument) {
            AEntitySelectorArgument argument = (AEntitySelectorArgument)argumentAnnotation;
            out.print(", " + EntitySelectorArgument.EntitySelector.class.getSimpleName() + "." + argument.value().toString());
        } else if (argumentAnnotation instanceof AScoreHolderArgument) {
            AScoreHolderArgument argument = (AScoreHolderArgument)argumentAnnotation;
            out.print(", " + ScoreHolderArgument.ScoreHolderType.class.getSimpleName() + "." + argument.value().toString());
        } else if (argumentAnnotation instanceof AMultiLiteralArgument) {
            AMultiLiteralArgument argument = (AMultiLiteralArgument)argumentAnnotation;
            out.print(Arrays.stream(argument.value()).map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
        } else if (argumentAnnotation instanceof ALiteralArgument) {
            ALiteralArgument argument = (ALiteralArgument)argumentAnnotation;
            out.print("\"");
            out.print(argument.value());
            out.print("\"");
        }
        out.print(")");
        if (argumentAnnotation instanceof ALiteralArgument) {
            out.print(".setListed(true)");
        }
        out.println(")");
    }

    private boolean isArgument(AnnotationMirror mirror) {
        String mirrorName = mirror.getAnnotationType().toString();
        return Arrays.stream(this.ARGUMENT_ANNOTATIONS).map(Class::getCanonicalName).anyMatch(mirrorName::equals);
    }

    private <T extends Annotation> Primitive getPrimitive(T annotation) {
        return annotation.annotationType().getDeclaredAnnotation(Primitive.class);
    }

    private <T extends Annotation> T getArgument(VariableElement tMirror) {
        for (AnnotationMirror annotationMirror : tMirror.getAnnotationMirrors()) {
            if (!this.isArgument(annotationMirror)) continue;
            try {
                return (T)tMirror.getAnnotationsByType(Class.forName(annotationMirror.getAnnotationType().toString()))[0];
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

