/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.config;

import dev.jorel.commandapi.config.ConfigGenerator;
import dev.jorel.commandapi.config.DefaultConfig;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;

public interface ConfigurationAdapter<Configuration> {
    public void setValue(String var1, Object var2);

    public void setComment(String var1, String[] var2);

    public Object getValue(String var1);

    public String[] getComment(String var1);

    public Set<String> getKeys();

    public boolean contains(String var1);

    public void tryCreateSection(String var1);

    public ConfigurationAdapter<Configuration> complete();

    public Configuration config();

    public ConfigurationAdapter<Configuration> createNew();

    public DefaultConfig createDefaultConfig();

    public ConfigurationAdapter<Configuration> loadFromFile() throws IOException;

    public void saveToFile() throws IOException;

    default public void saveDefaultConfig(File directory, Logger logger) {
        ConfigurationAdapter<Configuration> existingConfig;
        ConfigGenerator generator = ConfigGenerator.createNew(this.createDefaultConfig());
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                logger.severe("Failed to create directory for the CommandAPI's config.yml file!");
            }
            existingConfig = this.createNew();
        } else {
            try {
                existingConfig = this.loadFromFile();
            }
            catch (IOException e) {
                logger.severe("Failed to load the config file!");
                logger.severe("Error message: " + e.getMessage());
                logger.severe("Stacktrace:");
                for (StackTraceElement element : e.getStackTrace()) {
                    logger.severe(element.toString());
                }
                return;
            }
        }
        ConfigurationAdapter<Configuration> updatedConfig = generator.generate(existingConfig);
        if (updatedConfig == null) {
            return;
        }
        try {
            updatedConfig.saveToFile();
        }
        catch (IOException e) {
            logger.severe("Failed to save the config file!");
            logger.severe("Error message: " + e.getMessage());
            logger.severe("Stacktrace:");
            for (StackTraceElement element : e.getStackTrace()) {
                logger.severe(element.toString());
            }
        }
    }
}

