/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.executors.IExecutorNormal;
import dev.jorel.commandapi.executors.IExecutorResulting;
import dev.jorel.commandapi.executors.IExecutorTyped;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CustomCommandExecutor<T extends CommandSender> {
    private List<IExecutorNormal<T>> normalExecutors = new ArrayList<IExecutorNormal<T>>();
    private List<IExecutorResulting<T>> resultingExecutors = new ArrayList<IExecutorResulting<T>>();

    public <S extends IExecutorNormal<?>> void addNormalExecutor(S executor) {
        this.normalExecutors.add(executor);
    }

    public <S extends IExecutorResulting<?>> void addResultingExecutor(S executor) {
        this.resultingExecutors.add(executor);
    }

    public int execute(CommandSender sender, Object[] arguments) throws CommandSyntaxException {
        if (!this.resultingExecutors.isEmpty()) {
            try {
                return this.execute(this.resultingExecutors, sender, arguments);
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return 0;
            }
        }
        try {
            return this.execute(this.normalExecutors, sender, arguments);
        }
        catch (WrapperCommandSyntaxException e) {
            throw e.getException();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return 0;
        }
    }

    private int execute(List<? extends IExecutorTyped> executors, CommandSender sender, Object[] args) throws WrapperCommandSyntaxException {
        if (this.isForceNative()) {
            return this.execute(executors, sender, args, ExecutorType.NATIVE);
        }
        if (sender instanceof Player && this.matches(executors, ExecutorType.PLAYER)) {
            return this.execute(executors, sender, args, ExecutorType.PLAYER);
        }
        if (sender instanceof Entity && this.matches(executors, ExecutorType.ENTITY)) {
            return this.execute(executors, sender, args, ExecutorType.ENTITY);
        }
        if (sender instanceof ConsoleCommandSender && this.matches(executors, ExecutorType.CONSOLE)) {
            return this.execute(executors, sender, args, ExecutorType.CONSOLE);
        }
        if (sender instanceof BlockCommandSender && this.matches(executors, ExecutorType.BLOCK)) {
            return this.execute(executors, sender, args, ExecutorType.BLOCK);
        }
        if (sender instanceof ProxiedCommandSender && this.matches(executors, ExecutorType.PROXY)) {
            return this.execute(executors, sender, args, ExecutorType.PROXY);
        }
        if (this.matches(executors, ExecutorType.ALL)) {
            return this.execute(executors, sender, args, ExecutorType.ALL);
        }
        throw new WrapperCommandSyntaxException(new SimpleCommandExceptionType((Message)new LiteralMessage(CommandAPI.getConfiguration().getMissingImplementationMessage().replace("%s", sender.getClass().getSimpleName().toLowerCase()).replace("%S", sender.getClass().getSimpleName()))).create());
    }

    private int execute(List<? extends IExecutorTyped> executors, CommandSender sender, Object[] args, ExecutorType type) throws WrapperCommandSyntaxException {
        for (IExecutorTyped iExecutorTyped : executors) {
            if (iExecutorTyped.getType() != type) continue;
            return iExecutorTyped.executeWith(sender, args);
        }
        throw new NoSuchElementException("Executor had no valid executors for type " + type.toString());
    }

    public List<IExecutorNormal<T>> getNormalExecutors() {
        return this.normalExecutors;
    }

    public List<IExecutorResulting<T>> getResultingExecutors() {
        return this.resultingExecutors;
    }

    public boolean hasAnyExecutors() {
        return !this.normalExecutors.isEmpty() || !this.resultingExecutors.isEmpty();
    }

    public boolean isForceNative() {
        return this.matches(this.normalExecutors, ExecutorType.NATIVE) || this.matches(this.resultingExecutors, ExecutorType.NATIVE);
    }

    private boolean matches(List<? extends IExecutorTyped> executors, ExecutorType type) {
        for (IExecutorTyped iExecutorTyped : executors) {
            if (iExecutorTyped.getType() != type) continue;
            return true;
        }
        return false;
    }

    CustomCommandExecutor<T> mergeExecutor(CustomCommandExecutor<T> executor) {
        CustomCommandExecutor<T> result = new CustomCommandExecutor<T>();
        result.normalExecutors = new ArrayList<IExecutorNormal<T>>(this.normalExecutors);
        result.resultingExecutors = new ArrayList<IExecutorResulting<T>>(this.resultingExecutors);
        result.normalExecutors.addAll(executor.normalExecutors);
        result.resultingExecutors.addAll(executor.resultingExecutors);
        return result;
    }

    public void setNormalExecutors(List<IExecutorNormal<T>> normalExecutors) {
        this.normalExecutors = normalExecutors;
    }

    public void setResultingExecutors(List<IExecutorResulting<T>> resultingExecutors) {
        this.resultingExecutors = resultingExecutors;
    }
}

