/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.StringTooltip;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class Tooltip<S> {
    private final S object;
    private final Message tooltip;

    protected Tooltip(S object, Message tooltip) {
        this.object = object;
        this.tooltip = tooltip;
    }

    public S getSuggestion() {
        return this.object;
    }

    public Message getTooltip() {
        return this.tooltip;
    }

    @Deprecated(forRemoval=true)
    public static <S> Tooltip<S> of(S object, String tooltip) {
        return Tooltip.ofString(object, tooltip);
    }

    public static <S> Tooltip<S> ofString(S object, String tooltip) {
        return Tooltip.ofMessage(object, Tooltip.messageFromString(tooltip));
    }

    public static <S> Tooltip<S> ofMessage(S object, Message tooltip) {
        return new Tooltip<S>(object, tooltip);
    }

    public static <S> Tooltip<S> ofBaseComponents(S object, BaseComponent ... tooltip) {
        return Tooltip.ofMessage(object, Tooltip.messageFromBaseComponents(tooltip));
    }

    public static <S> Tooltip<S> ofAdventureComponent(S object, Component tooltip) {
        return Tooltip.ofMessage(object, Tooltip.messageFromAdventureComponent(tooltip));
    }

    public static <S> Tooltip<S> none(S object) {
        return new Tooltip<S>(object, null);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> none(S ... suggestions) {
        return Tooltip.generate(Object::toString, (S s, T t) -> Tooltip.none(s), suggestions);
    }

    public static <S> Collection<Tooltip<S>> none(Collection<S> suggestions) {
        return Tooltip.generate(Object::toString, (S s, T t) -> Tooltip.none(s), suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateStrings(Function<S, String> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofString, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateStrings(Function<S, String> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofString, suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateMessages(Function<S, Message> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofMessage, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateMessages(Function<S, Message> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofMessage, suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateBaseComponents(Function<S, BaseComponent[]> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofBaseComponents, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateBaseComponents(Function<S, BaseComponent[]> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofBaseComponents, suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateAdvenureComponents(Function<S, Component> tooltipGenerator, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofAdventureComponent, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateAdvenureComponents(Function<S, Component> tooltipGenerator, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, Tooltip::ofAdventureComponent, suggestions);
    }

    @SafeVarargs
    private static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, S ... suggestions) {
        return Tooltip.generate(tooltipGenerator, tooltipWrapper, Arrays.stream(suggestions));
    }

    private static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, Collection<S> suggestions) {
        return Tooltip.generate(tooltipGenerator, tooltipWrapper, suggestions.stream());
    }

    private static <S, T> Collection<Tooltip<S>> generate(Function<S, T> tooltipGenerator, BiFunction<S, T, Tooltip<S>> tooltipWrapper, Stream<S> suggestions) {
        return suggestions.map(suggestion -> (Tooltip)tooltipWrapper.apply(suggestion, tooltipGenerator.apply(suggestion))).toList();
    }

    @SafeVarargs
    public static <S> Tooltip<S>[] arrayOf(Tooltip<S> ... tooltips) {
        return tooltips;
    }

    public static <S> Function<Tooltip<S>, StringTooltip> build(Function<S, String> mapper) {
        return t -> StringTooltip.ofMessage((String)mapper.apply(t.object), t.tooltip);
    }

    public static Message messageFromString(String string) {
        return new LiteralMessage(string);
    }

    public static Message messageFromBaseComponents(BaseComponent ... components) {
        return CommandAPIHandler.getInstance().getNMS().generateMessageFromJson(ComponentSerializer.toString((BaseComponent[])components));
    }

    public static Message messageFromAdventureComponent(Component component) {
        return CommandAPIHandler.getInstance().getNMS().generateMessageFromJson((String)GsonComponentSerializer.gson().serialize(component));
    }
}

