/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.arguments.SuggestionsBranch;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.CommandResult;
import java.util.Arrays;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;

public class CommandArgument
extends Argument<CommandResult>
implements IGreedyArgument {
    SuggestionsBranch replacements = SuggestionsBranch.suggest(new ArgumentSuggestions[0]);

    public CommandArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.applySuggestions();
    }

    private void applySuggestions() {
        super.replaceSuggestions((SuggestionInfo info, SuggestionsBuilder builder) -> {
            Player player;
            Block block;
            CommandSender sender = info.sender();
            SimpleCommandMap commandMap = CommandAPIHandler.getInstance().getNMS().getSimpleCommandMap();
            String command = info.currentArg();
            StringReader context = new StringReader(command);
            if (!command.contains(" ")) {
                ArgumentSuggestions replacement = this.replacements.getNextSuggestion(sender, new String[0]);
                if (replacement != null) {
                    return replacement.suggest(new SuggestionInfo(sender, new Object[0], command, command), builder);
                }
                List results = commandMap.tabComplete(sender, command);
                if (results == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
                }
                if (sender instanceof Player) {
                    for (String result : results) {
                        builder.suggest(result.substring(1));
                    }
                } else {
                    for (String result : results) {
                        builder.suggest(result);
                    }
                }
                return builder.buildFuture();
            }
            String commandLabel = command.substring(0, command.indexOf(" "));
            Command target = commandMap.getCommand(commandLabel);
            if (target == null) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
            }
            String[] arguments = command.split(" ");
            if (!arguments[0].isEmpty() && command.endsWith(" ")) {
                arguments = Arrays.copyOf(arguments, arguments.length + 1);
                arguments[arguments.length - 1] = "";
            }
            builder = builder.createOffset(builder.getStart() + command.lastIndexOf(" ") + 1);
            int lastIndex = arguments.length - 1;
            Object[] previousArguments = Arrays.copyOf(arguments, lastIndex);
            ArgumentSuggestions replacement = this.replacements.getNextSuggestion(sender, (String[])previousArguments);
            if (replacement != null) {
                return replacement.suggest(new SuggestionInfo(sender, previousArguments, command, arguments[lastIndex]), builder);
            }
            arguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            Location location = null;
            if (sender instanceof Player && (block = (player = (Player)sender).getTargetBlockExact(5, FluidCollisionMode.NEVER)) != null) {
                location = block.getLocation();
            }
            for (String tabCompletion : target.tabComplete(sender, commandLabel, arguments, location)) {
                builder.suggest(tabCompletion);
            }
            return builder.buildFuture();
        });
    }

    public CommandArgument replaceSuggestions(ArgumentSuggestions ... suggestions) {
        this.replacements = SuggestionsBranch.suggest(suggestions);
        return this;
    }

    public CommandArgument replaceSuggestions(ArgumentSuggestions suggestions) {
        return this.replaceSuggestions(new ArgumentSuggestions[]{suggestions});
    }

    public Argument<CommandResult> branchSuggestions(SuggestionsBranch ... branches) {
        this.replacements.branch(branches);
        return this;
    }

    @Override
    public Class<CommandResult> getPrimitiveType() {
        return CommandResult.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.COMMAND;
    }

    @Override
    public <CommandSourceStack> CommandResult parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        String command = (String)cmdCtx.getArgument(key, String.class);
        SimpleCommandMap commandMap = nms.getSimpleCommandMap();
        CommandSender sender = nms.getSenderForCommand(cmdCtx, false);
        StringReader context = new StringReader(command);
        String[] arguments = command.split(" ");
        String commandLabel = arguments[0];
        Command target = commandMap.getCommand(commandLabel);
        if (target == null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
        }
        this.replacements.enforceReplacements(sender, arguments);
        return new CommandResult(target, Arrays.copyOfRange(arguments, 1, arguments.length));
    }
}

