/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.EventPriorities;
import dev.robocode.tankroyale.botapi.util.MathUtil;
import dev.robocode.tankroyale.schema.BotIntent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class BaseBot
implements IBaseBot {
    final BaseBotInternals baseBotInternals;

    protected BaseBot() {
        this.baseBotInternals = new BaseBotInternals(this, null, null, null);
    }

    protected BaseBot(BotInfo botInfo) {
        this.baseBotInternals = new BaseBotInternals(this, botInfo, null, null);
    }

    protected BaseBot(BotInfo botInfo, URI serverUrl) {
        this.baseBotInternals = new BaseBotInternals(this, botInfo, serverUrl, null);
    }

    protected BaseBot(BotInfo botInfo, URI serverUrl, String serverSecret) {
        this.baseBotInternals = new BaseBotInternals(this, botInfo, serverUrl, serverSecret);
    }

    @Override
    public final void start() {
        this.baseBotInternals.start();
    }

    @Override
    public void go() {
        this.baseBotInternals.execute();
    }

    @Override
    public final String getVariant() {
        return this.baseBotInternals.getVariant();
    }

    @Override
    public final String getVersion() {
        return this.baseBotInternals.getVersion();
    }

    @Override
    public final int getMyId() {
        return this.baseBotInternals.getMyId();
    }

    @Override
    public final String getGameType() {
        return this.baseBotInternals.getGameSetup().getGameType();
    }

    @Override
    public final int getArenaWidth() {
        return this.baseBotInternals.getGameSetup().getArenaWidth();
    }

    @Override
    public final int getArenaHeight() {
        return this.baseBotInternals.getGameSetup().getArenaHeight();
    }

    @Override
    public final int getNumberOfRounds() {
        return this.baseBotInternals.getGameSetup().getNumberOfRounds();
    }

    @Override
    public final double getGunCoolingRate() {
        return this.baseBotInternals.getGameSetup().getGunCoolingRate();
    }

    @Override
    public final int getMaxInactivityTurns() {
        return this.baseBotInternals.getGameSetup().getMaxInactivityTurns();
    }

    @Override
    public final int getTurnTimeout() {
        return this.baseBotInternals.getGameSetup().getTurnTimeout();
    }

    @Override
    public final int getTimeLeft() {
        return this.baseBotInternals.getTimeLeft();
    }

    @Override
    public final int getRoundNumber() {
        return this.baseBotInternals.getCurrentTickOrThrow().getRoundNumber();
    }

    @Override
    public final int getTurnNumber() {
        return this.baseBotInternals.getCurrentTickOrThrow().getTurnNumber();
    }

    @Override
    public final int getEnemyCount() {
        return this.baseBotInternals.getCurrentTickOrThrow().getBotState().getEnemyCount();
    }

    @Override
    public final double getEnergy() {
        return this.baseBotInternals.getCurrentTickOrThrow().getBotState().getEnergy();
    }

    @Override
    public final boolean isDisabled() {
        return this.getEnergy() == 0.0;
    }

    @Override
    public final double getX() {
        TickEvent tick = this.baseBotInternals.getCurrentTickOrNull();
        if (tick != null) {
            return tick.getBotState().getX();
        }
        return this.baseBotInternals.getInitialPosition().getX();
    }

    @Override
    public final double getY() {
        TickEvent tick = this.baseBotInternals.getCurrentTickOrNull();
        if (tick != null) {
            return tick.getBotState().getY();
        }
        return this.baseBotInternals.getInitialPosition().getY();
    }

    @Override
    public final double getDirection() {
        TickEvent tick = this.baseBotInternals.getCurrentTickOrNull();
        if (tick != null) {
            return tick.getBotState().getDirection();
        }
        return this.baseBotInternals.getInitialPosition().getDirection();
    }

    @Override
    public final double getGunDirection() {
        TickEvent tick = this.baseBotInternals.getCurrentTickOrNull();
        if (tick != null) {
            return tick.getBotState().getGunDirection();
        }
        return this.baseBotInternals.getInitialPosition().getDirection();
    }

    @Override
    public final double getRadarDirection() {
        TickEvent tick = this.baseBotInternals.getCurrentTickOrNull();
        if (tick != null) {
            return tick.getBotState().getRadarDirection();
        }
        return this.baseBotInternals.getInitialPosition().getDirection();
    }

    @Override
    public final double getSpeed() {
        return this.baseBotInternals.getSpeed();
    }

    @Override
    public final double getGunHeat() {
        return this.baseBotInternals.getGunHeat();
    }

    @Override
    public final Collection<BulletState> getBulletStates() {
        return this.baseBotInternals.getBulletStates();
    }

    @Override
    public final List<BotEvent> getEvents() {
        return this.baseBotInternals.getEvents();
    }

    @Override
    public final void clearEvents() {
        this.baseBotInternals.clearEvents();
    }

    @Override
    public final double getTurnRate() {
        return this.baseBotInternals.getTurnRate();
    }

    @Override
    public void setTurnRate(double turnRate) {
        this.baseBotInternals.setTurnRate(turnRate);
    }

    @Override
    public final double getMaxTurnRate() {
        return this.baseBotInternals.getMaxTurnRate();
    }

    @Override
    public final void setMaxTurnRate(double maxTurnRate) {
        this.baseBotInternals.setMaxTurnRate(maxTurnRate);
    }

    @Override
    public final double getGunTurnRate() {
        return this.baseBotInternals.getGunTurnRate();
    }

    @Override
    public void setGunTurnRate(double gunTurnRate) {
        this.baseBotInternals.setGunTurnRate(gunTurnRate);
    }

    @Override
    public final double getMaxGunTurnRate() {
        return this.baseBotInternals.getMaxGunTurnRate();
    }

    @Override
    public final void setMaxGunTurnRate(double maxGunTurnRate) {
        this.baseBotInternals.setMaxGunTurnRate(maxGunTurnRate);
    }

    @Override
    public final double getRadarTurnRate() {
        return this.baseBotInternals.getRadarTurnRate();
    }

    @Override
    public void setRadarTurnRate(double radarTurnRate) {
        this.baseBotInternals.setRadarTurnRate(radarTurnRate);
    }

    @Override
    public final double getMaxRadarTurnRate() {
        return this.baseBotInternals.getMaxRadarTurnRate();
    }

    @Override
    public final void setMaxRadarTurnRate(double maxRadarTurnRate) {
        this.baseBotInternals.setMaxRadarTurnRate(maxRadarTurnRate);
    }

    @Override
    public final double getTargetSpeed() {
        Double targetSpeed = this.baseBotInternals.getBotIntent().getTargetSpeed();
        return targetSpeed == null ? 0.0 : targetSpeed;
    }

    @Override
    public void setTargetSpeed(double targetSpeed) {
        this.baseBotInternals.setTargetSpeed(targetSpeed);
    }

    @Override
    public final double getMaxSpeed() {
        return this.baseBotInternals.getMaxSpeed();
    }

    @Override
    public final void setMaxSpeed(double maxSpeed) {
        this.baseBotInternals.setMaxSpeed(maxSpeed);
    }

    @Override
    public final boolean setFire(double firepower) {
        return this.baseBotInternals.setFire(firepower);
    }

    @Override
    public final double getFirepower() {
        Double firepower = this.baseBotInternals.getBotIntent().getFirepower();
        return firepower == null ? 0.0 : firepower;
    }

    @Override
    public final void setRescan() {
        this.baseBotInternals.getBotIntent().setRescan(true);
    }

    @Override
    public final void setFireAssist(boolean enable) {
        this.baseBotInternals.getBotIntent().setFireAssist(enable);
    }

    @Override
    public final void setInterruptible(boolean interruptible) {
        this.baseBotInternals.setInterruptible(interruptible);
    }

    @Override
    public final void setAdjustGunForBodyTurn(boolean adjust) {
        this.baseBotInternals.getBotIntent().setAdjustGunForBodyTurn(adjust);
    }

    @Override
    public final boolean isAdjustGunForBodyTurn() {
        Boolean adjust = this.baseBotInternals.getBotIntent().getAdjustGunForBodyTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final void setAdjustRadarForBodyTurn(boolean adjust) {
        this.baseBotInternals.getBotIntent().setAdjustRadarForBodyTurn(adjust);
    }

    @Override
    public final boolean isAdjustRadarForBodyTurn() {
        Boolean adjust = this.baseBotInternals.getBotIntent().getAdjustRadarForBodyTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final void setAdjustRadarForGunTurn(boolean adjust) {
        BotIntent botIntent = this.baseBotInternals.getBotIntent();
        botIntent.setAdjustRadarForGunTurn(adjust);
        botIntent.setFireAssist(!adjust);
    }

    @Override
    public final boolean isAdjustRadarForGunTurn() {
        Boolean adjust = this.baseBotInternals.getBotIntent().getAdjustRadarForGunTurn();
        return adjust != null && adjust != false;
    }

    @Override
    public final boolean addCustomEvent(Condition condition) {
        return this.baseBotInternals.addCondition(condition);
    }

    @Override
    public final boolean removeCustomEvent(Condition condition) {
        return this.baseBotInternals.removeCondition(condition);
    }

    @Override
    public final void setStop() {
        this.baseBotInternals.setStop(false);
    }

    @Override
    public final void setStop(boolean overwrite) {
        this.baseBotInternals.setStop(overwrite);
    }

    @Override
    public final void setResume() {
        this.baseBotInternals.setResume();
    }

    @Override
    public final boolean isStopped() {
        return this.baseBotInternals.isStopped();
    }

    @Override
    public final Set<Integer> getTeammateIds() {
        return this.baseBotInternals.getTeammateIds();
    }

    @Override
    public final boolean isTeammate(int botId) {
        return this.baseBotInternals.isTeammate(botId);
    }

    @Override
    public final void broadcastTeamMessage(Object message) {
        this.baseBotInternals.broadcastTeamMessage(message);
    }

    @Override
    public final void sendTeamMessage(int teammateId, Object message) {
        this.baseBotInternals.sendTeamMessage(teammateId, message);
    }

    @Override
    public final Color getBodyColor() {
        return this.baseBotInternals.getBodyColor();
    }

    @Override
    public final void setBodyColor(Color color) {
        this.baseBotInternals.setBodyColor(color);
    }

    @Override
    public final Color getTurretColor() {
        return this.baseBotInternals.getTurretColor();
    }

    @Override
    public final void setTurretColor(Color color) {
        this.baseBotInternals.setTurretColor(color);
    }

    @Override
    public final Color getRadarColor() {
        return this.baseBotInternals.getRadarColor();
    }

    @Override
    public final void setRadarColor(Color color) {
        this.baseBotInternals.setRadarColor(color);
    }

    @Override
    public final Color getBulletColor() {
        return this.baseBotInternals.getBulletColor();
    }

    @Override
    public final void setBulletColor(Color color) {
        this.baseBotInternals.setBulletColor(color);
    }

    @Override
    public final Color getScanColor() {
        return this.baseBotInternals.getScanColor();
    }

    @Override
    public final void setScanColor(Color color) {
        this.baseBotInternals.setScanColor(color);
    }

    @Override
    public final Color getTracksColor() {
        return this.baseBotInternals.getTracksColor();
    }

    @Override
    public final void setTracksColor(Color color) {
        this.baseBotInternals.setTracksColor(color);
    }

    @Override
    public final Color getGunColor() {
        return this.baseBotInternals.getGunColor();
    }

    @Override
    public final void setGunColor(Color color) {
        this.baseBotInternals.setGunColor(color);
    }

    @Override
    public final double calcMaxTurnRate(double speed) {
        return 10.0 - 0.75 * Math.abs(MathUtil.clamp(speed, -8.0, 8.0));
    }

    @Override
    public final double calcBulletSpeed(double firepower) {
        return 20.0 - 3.0 * MathUtil.clamp(firepower, 0.1, 3.0);
    }

    @Override
    public final double calcGunHeat(double firepower) {
        return 1.0 + MathUtil.clamp(firepower, 0.1, 3.0) / 5.0;
    }

    @Override
    public final int getEventPriority(Class<BotEvent> eventClass) {
        return EventPriorities.getPriority(eventClass);
    }

    @Override
    public final void setEventPriority(Class<BotEvent> eventClass, int priority) {
        EventPriorities.setPriority(eventClass, priority);
    }

    @Override
    public final boolean isDebuggingEnabled() {
        return this.baseBotInternals.getCurrentTickOrThrow().getBotState().isDebuggingEnabled();
    }

    @Override
    public final Graphics2D getGraphics() {
        return this.baseBotInternals.getGraphics();
    }
}

