/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotDeathEvent;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.ConnectedEvent;
import dev.robocode.tankroyale.botapi.events.ConnectionErrorEvent;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.GameStartedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.IEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TeamMessageEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.events.WonRoundEvent;
import dev.robocode.tankroyale.botapi.internal.EventHandler;
import java.util.HashMap;
import java.util.Map;

final class BotEventHandlers {
    final EventHandler<ConnectedEvent> onConnected = new EventHandler();
    final EventHandler<DisconnectedEvent> onDisconnected = new EventHandler();
    final EventHandler<ConnectionErrorEvent> onConnectionError = new EventHandler();
    final EventHandler<GameStartedEvent> onGameStarted = new EventHandler();
    final EventHandler<GameEndedEvent> onGameEnded = new EventHandler();
    final EventHandler<GameAbortedEvent> onGameAborted = new EventHandler();
    final EventHandler<RoundStartedEvent> onRoundStarted = new EventHandler();
    final EventHandler<RoundEndedEvent> onRoundEnded = new EventHandler();
    final EventHandler<TickEvent> onTick = new EventHandler();
    final EventHandler<SkippedTurnEvent> onSkippedTurn = new EventHandler();
    final EventHandler<DeathEvent> onDeath = new EventHandler();
    final EventHandler<BotDeathEvent> onBotDeath = new EventHandler();
    final EventHandler<HitBotEvent> onHitBot = new EventHandler();
    final EventHandler<HitWallEvent> onHitWall = new EventHandler();
    final EventHandler<BulletFiredEvent> onBulletFired = new EventHandler();
    final EventHandler<HitByBulletEvent> onHitByBullet = new EventHandler();
    final EventHandler<BulletHitBotEvent> onBulletHit = new EventHandler();
    final EventHandler<BulletHitBulletEvent> onBulletHitBullet = new EventHandler();
    final EventHandler<BulletHitWallEvent> onBulletHitWall = new EventHandler();
    final EventHandler<ScannedBotEvent> onScannedBot = new EventHandler();
    final EventHandler<WonRoundEvent> onWonRound = new EventHandler();
    final EventHandler<CustomEvent> onCustomEvent = new EventHandler();
    final EventHandler<TeamMessageEvent> onTeamMessage = new EventHandler();
    private final Map<Class<? extends IEvent>, EventHandler<? extends IEvent>> eventHandlerMap = new HashMap<Class<? extends IEvent>, EventHandler<? extends IEvent>>();

    BotEventHandlers(IBaseBot baseBot) {
        this.initializeEventHandlers();
        this.subscribeToEventHandlers(baseBot);
    }

    private void initializeEventHandlers() {
        this.eventHandlerMap.put(ConnectedEvent.class, this.onConnected);
        this.eventHandlerMap.put(DisconnectedEvent.class, this.onDisconnected);
        this.eventHandlerMap.put(ConnectionErrorEvent.class, this.onConnectionError);
        this.eventHandlerMap.put(GameStartedEvent.class, this.onGameStarted);
        this.eventHandlerMap.put(GameEndedEvent.class, this.onGameEnded);
        this.eventHandlerMap.put(GameAbortedEvent.class, this.onGameAborted);
        this.eventHandlerMap.put(RoundStartedEvent.class, this.onRoundStarted);
        this.eventHandlerMap.put(RoundEndedEvent.class, this.onRoundEnded);
        this.eventHandlerMap.put(TickEvent.class, this.onTick);
        this.eventHandlerMap.put(SkippedTurnEvent.class, this.onSkippedTurn);
        this.eventHandlerMap.put(DeathEvent.class, this.onDeath);
        this.eventHandlerMap.put(BotDeathEvent.class, this.onBotDeath);
        this.eventHandlerMap.put(HitBotEvent.class, this.onHitBot);
        this.eventHandlerMap.put(HitWallEvent.class, this.onHitWall);
        this.eventHandlerMap.put(BulletFiredEvent.class, this.onBulletFired);
        this.eventHandlerMap.put(HitByBulletEvent.class, this.onHitByBullet);
        this.eventHandlerMap.put(BulletHitBotEvent.class, this.onBulletHit);
        this.eventHandlerMap.put(BulletHitBulletEvent.class, this.onBulletHitBullet);
        this.eventHandlerMap.put(BulletHitWallEvent.class, this.onBulletHitWall);
        this.eventHandlerMap.put(ScannedBotEvent.class, this.onScannedBot);
        this.eventHandlerMap.put(WonRoundEvent.class, this.onWonRound);
        this.eventHandlerMap.put(CustomEvent.class, this.onCustomEvent);
        this.eventHandlerMap.put(TeamMessageEvent.class, this.onTeamMessage);
    }

    private void subscribeToEventHandlers(IBaseBot baseBot) {
        this.onConnected.subscribe(baseBot::onConnected);
        this.onDisconnected.subscribe(baseBot::onDisconnected);
        this.onConnectionError.subscribe(baseBot::onConnectionError);
        this.onGameStarted.subscribe(baseBot::onGameStarted);
        this.onGameEnded.subscribe(baseBot::onGameEnded);
        this.onRoundStarted.subscribe(baseBot::onRoundStarted);
        this.onRoundEnded.subscribe(baseBot::onRoundEnded);
        this.onTick.subscribe(baseBot::onTick);
        this.onSkippedTurn.subscribe(baseBot::onSkippedTurn);
        this.onDeath.subscribe(baseBot::onDeath);
        this.onBotDeath.subscribe(baseBot::onBotDeath);
        this.onHitBot.subscribe(baseBot::onHitBot);
        this.onHitWall.subscribe(baseBot::onHitWall);
        this.onBulletFired.subscribe(baseBot::onBulletFired);
        this.onHitByBullet.subscribe(baseBot::onHitByBullet);
        this.onBulletHit.subscribe(baseBot::onBulletHit);
        this.onBulletHitBullet.subscribe(baseBot::onBulletHitBullet);
        this.onBulletHitWall.subscribe(baseBot::onBulletHitWall);
        this.onScannedBot.subscribe(baseBot::onScannedBot);
        this.onWonRound.subscribe(baseBot::onWonRound);
        this.onCustomEvent.subscribe(baseBot::onCustomEvent);
        this.onTeamMessage.subscribe(baseBot::onTeamMessage);
    }

    void fireEvent(BotEvent event) {
        EventHandler<? extends IEvent> handler = this.eventHandlerMap.get(event.getClass());
        if (handler == null) {
            throw new IllegalStateException("Unhandled event type: " + event);
        }
        handler.publish(event);
    }

    private static final class GameAbortedEvent
    implements IEvent {
        private GameAbortedEvent() {
        }
    }
}

