/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.StringWriter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

class GraphicsState {
    private SVGGraphics2D graphics;

    public GraphicsState() {
        this.init();
    }

    private void init() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.graphics = new SVGGraphics2D(document);
        this.graphics.setSVGCanvasSize(new Dimension(5000, 5000));
        this.graphics.setBackground(new Color(0, 0, 0, 0));
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public String getSVGOutput() {
        try {
            StringWriter writer = new StringWriter();
            this.graphics.stream(writer, true);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void clear() {
        this.graphics.dispose();
        this.init();
    }
}

