/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.util;

import java.awt.Color;
import java.util.regex.Pattern;

public class ColorUtil {
    private static final Pattern NUMERIC_RGB = Pattern.compile("^#[0-9a-fA-F]{3,6}$");
    private static final Pattern HEX_DIGITS = Pattern.compile("^(?:[0-9a-fA-F]{3}|[0-9a-fA-F]{6})$");

    private ColorUtil() {
    }

    public static String toHex(Color color) {
        return color == null ? null : ColorUtil.toHex(color.getRed()) + ColorUtil.toHex(color.getGreen()) + ColorUtil.toHex(color.getBlue());
    }

    private static String toHex(int value) {
        return Integer.toHexString(value >> 4) + Integer.toHexString(value & 0xF);
    }

    public static Color fromString(String str) {
        if (str == null) {
            return null;
        }
        if (NUMERIC_RGB.matcher(str = str.trim()).matches()) {
            return ColorUtil.fromHex(str.substring(1));
        }
        throw new IllegalArgumentException("You must supply the string in numeric RGB format #[0-9a-fA-F], e.g. \"#09C\" or \"#0099CC\"");
    }

    public static Color fromHex(String hexTriplet) {
        if (!HEX_DIGITS.matcher(hexTriplet = hexTriplet.trim()).matches()) {
            throw new IllegalArgumentException("You must supply 3 or 6 hex digits [0-9a-fA-F], e.g. \"09C\" or \"0099CC\"");
        }
        boolean isThreeDigits = hexTriplet.length() == 3;
        int componentLength = isThreeDigits ? 1 : 2;
        int r = Integer.valueOf(hexTriplet.substring(0, componentLength), 16);
        int g = Integer.valueOf(hexTriplet.substring(componentLength, componentLength * 2), 16);
        int b = Integer.valueOf(hexTriplet.substring(componentLength * 2, componentLength * 3), 16);
        if (isThreeDigits) {
            r = r << 4 | r;
            g = g << 4 | g;
            b = b << 4 | b;
        }
        return new Color(r, g, b);
    }
}

