/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import java.util.Objects;

public final class InitialPosition {
    private final Double x;
    private final Double y;
    private final Double direction;

    public InitialPosition(Double x, Double y, Double direction) {
        this.x = x;
        this.y = y;
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitialPosition that = (InitialPosition)o;
        return Objects.equals(this.x, that.x) && Objects.equals(this.y, that.y) && Objects.equals(this.direction, that.direction);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.direction);
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public Double getDirection() {
        return this.direction;
    }

    public String toString() {
        if (this.x == null && this.y == null && this.direction == null) {
            return "";
        }
        Object strX = this.x == null ? "" : this.x;
        Object strY = this.y == null ? "" : this.y;
        Object strDirection = this.direction == null ? "" : this.direction;
        return String.valueOf(strX) + "," + String.valueOf(strY) + "," + String.valueOf(strDirection);
    }

    public static InitialPosition fromString(String initialPosition) {
        if (initialPosition == null || initialPosition.isBlank()) {
            return null;
        }
        String trimmed = initialPosition.trim();
        if (trimmed.replaceAll("[,\\s]", "").isEmpty()) {
            return null;
        }
        String[] values = trimmed.split("\\s*,\\s*|\\s+");
        return InitialPosition.parseInitialPosition(values);
    }

    private static InitialPosition parseInitialPosition(String[] values) {
        if (values.length < 1) {
            return null;
        }
        Double x = InitialPosition.parseDouble(values[0]);
        if (values.length < 2) {
            return new InitialPosition(x, null, null);
        }
        Double y = InitialPosition.parseDouble(values[1]);
        Double direction = null;
        if (values.length >= 3) {
            direction = InitialPosition.parseDouble(values[2]);
        }
        return new InitialPosition(x, y, direction);
    }

    private static Double parseDouble(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Double.parseDouble(str.trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

