/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.graphics;

public final class Color {
    private final int value;
    public static final Color TRANSPARENT = Color.fromRgba(255, 255, 255, 0);
    public static final Color ALICE_BLUE = Color.fromRgb(240, 248, 255);
    public static final Color ANTIQUE_WHITE = Color.fromRgb(250, 235, 215);
    public static final Color AQUA = Color.fromRgb(0, 255, 255);
    public static final Color AQUAMARINE = Color.fromRgb(127, 255, 212);
    public static final Color AZURE = Color.fromRgb(240, 255, 255);
    public static final Color BEIGE = Color.fromRgb(245, 245, 220);
    public static final Color BISQUE = Color.fromRgb(255, 228, 196);
    public static final Color BLACK = Color.fromRgb(0, 0, 0);
    public static final Color BLANCHED_ALMOND = Color.fromRgb(255, 235, 205);
    public static final Color BLUE = Color.fromRgb(0, 0, 255);
    public static final Color BLUE_VIOLET = Color.fromRgb(138, 43, 226);
    public static final Color BROWN = Color.fromRgb(165, 42, 42);
    public static final Color BURLY_WOOD = Color.fromRgb(222, 184, 135);
    public static final Color CADET_BLUE = Color.fromRgb(95, 158, 160);
    public static final Color CHARTREUSE = Color.fromRgb(127, 255, 0);
    public static final Color CHOCOLATE = Color.fromRgb(210, 105, 30);
    public static final Color CORAL = Color.fromRgb(255, 127, 80);
    public static final Color CORNFLOWER_BLUE = Color.fromRgb(100, 149, 237);
    public static final Color CORNSILK = Color.fromRgb(255, 248, 220);
    public static final Color CRIMSON = Color.fromRgb(220, 20, 60);
    public static final Color CYAN = Color.fromRgb(0, 255, 255);
    public static final Color DARK_BLUE = Color.fromRgb(0, 0, 139);
    public static final Color DARK_CYAN = Color.fromRgb(0, 139, 139);
    public static final Color DARK_GOLDENROD = Color.fromRgb(184, 134, 11);
    public static final Color DARK_GRAY = Color.fromRgb(169, 169, 169);
    public static final Color DARK_GREEN = Color.fromRgb(0, 100, 0);
    public static final Color DARK_KHAKI = Color.fromRgb(189, 183, 107);
    public static final Color DARK_MAGENTA = Color.fromRgb(139, 0, 139);
    public static final Color DARK_OLIVE_GREEN = Color.fromRgb(85, 107, 47);
    public static final Color DARK_ORANGE = Color.fromRgb(255, 140, 0);
    public static final Color DARK_ORCHID = Color.fromRgb(153, 50, 204);
    public static final Color DARK_RED = Color.fromRgb(139, 0, 0);
    public static final Color DARK_SALMON = Color.fromRgb(233, 150, 122);
    public static final Color DARK_SEA_GREEN = Color.fromRgb(143, 188, 139);
    public static final Color DARK_SLATE_BLUE = Color.fromRgb(72, 61, 139);
    public static final Color DARK_SLATE_GRAY = Color.fromRgb(47, 79, 79);
    public static final Color DARK_TURQUOISE = Color.fromRgb(0, 206, 209);
    public static final Color DARK_VIOLET = Color.fromRgb(148, 0, 211);
    public static final Color DEEP_PINK = Color.fromRgb(255, 20, 147);
    public static final Color DEEP_SKY_BLUE = Color.fromRgb(0, 191, 255);
    public static final Color DIM_GRAY = Color.fromRgb(105, 105, 105);
    public static final Color DODGER_BLUE = Color.fromRgb(30, 144, 255);
    public static final Color FIREBRICK = Color.fromRgb(178, 34, 34);
    public static final Color FLORAL_WHITE = Color.fromRgb(255, 250, 240);
    public static final Color FOREST_GREEN = Color.fromRgb(34, 139, 34);
    public static final Color FUCHSIA = Color.fromRgb(255, 0, 255);
    public static final Color GAINSBORO = Color.fromRgb(220, 220, 220);
    public static final Color GHOST_WHITE = Color.fromRgb(248, 248, 255);
    public static final Color GOLD = Color.fromRgb(255, 215, 0);
    public static final Color GOLDENROD = Color.fromRgb(218, 165, 32);
    public static final Color GRAY = Color.fromRgb(128, 128, 128);
    public static final Color GREEN = Color.fromRgb(0, 128, 0);
    public static final Color GREEN_YELLOW = Color.fromRgb(173, 255, 47);
    public static final Color HONEYDEW = Color.fromRgb(240, 255, 240);
    public static final Color HOT_PINK = Color.fromRgb(255, 105, 180);
    public static final Color INDIAN_RED = Color.fromRgb(205, 92, 92);
    public static final Color INDIGO = Color.fromRgb(75, 0, 130);
    public static final Color IVORY = Color.fromRgb(255, 255, 240);
    public static final Color KHAKI = Color.fromRgb(240, 230, 140);
    public static final Color LAVENDER = Color.fromRgb(230, 230, 250);
    public static final Color LAVENDER_BLUSH = Color.fromRgb(255, 240, 245);
    public static final Color LAWN_GREEN = Color.fromRgb(124, 252, 0);
    public static final Color LEMON_CHIFFON = Color.fromRgb(255, 250, 205);
    public static final Color LIGHT_BLUE = Color.fromRgb(173, 216, 230);
    public static final Color LIGHT_CORAL = Color.fromRgb(240, 128, 128);
    public static final Color LIGHT_CYAN = Color.fromRgb(224, 255, 255);
    public static final Color LIGHT_GOLDENROD_YELLOW = Color.fromRgb(250, 250, 210);
    public static final Color LIGHT_GRAY = Color.fromRgb(211, 211, 211);
    public static final Color LIGHT_GREEN = Color.fromRgb(144, 238, 144);
    public static final Color LIGHT_PINK = Color.fromRgb(255, 182, 193);
    public static final Color LIGHT_SALMON = Color.fromRgb(255, 160, 122);
    public static final Color LIGHT_SEA_GREEN = Color.fromRgb(32, 178, 170);
    public static final Color LIGHT_SKY_BLUE = Color.fromRgb(135, 206, 250);
    public static final Color LIGHT_SLATE_GRAY = Color.fromRgb(119, 136, 153);
    public static final Color LIGHT_STEEL_BLUE = Color.fromRgb(176, 196, 222);
    public static final Color LIGHT_YELLOW = Color.fromRgb(255, 255, 224);
    public static final Color LIME = Color.fromRgb(0, 255, 0);
    public static final Color LIME_GREEN = Color.fromRgb(50, 205, 50);
    public static final Color LINEN = Color.fromRgb(250, 240, 230);
    public static final Color MAGENTA = Color.fromRgb(255, 0, 255);
    public static final Color MAROON = Color.fromRgb(128, 0, 0);
    public static final Color MEDIUM_AQUAMARINE = Color.fromRgb(102, 205, 170);
    public static final Color MEDIUM_BLUE = Color.fromRgb(0, 0, 205);
    public static final Color MEDIUM_ORCHID = Color.fromRgb(186, 85, 211);
    public static final Color MEDIUM_PURPLE = Color.fromRgb(147, 112, 219);
    public static final Color MEDIUM_SEA_GREEN = Color.fromRgb(60, 179, 113);
    public static final Color MEDIUM_SLATE_BLUE = Color.fromRgb(123, 104, 238);
    public static final Color MEDIUM_SPRING_GREEN = Color.fromRgb(0, 250, 154);
    public static final Color MEDIUM_TURQUOISE = Color.fromRgb(72, 209, 204);
    public static final Color MEDIUM_VIOLET_RED = Color.fromRgb(199, 21, 133);
    public static final Color MIDNIGHT_BLUE = Color.fromRgb(25, 25, 112);
    public static final Color MINT_CREAM = Color.fromRgb(245, 255, 250);
    public static final Color MISTY_ROSE = Color.fromRgb(255, 228, 225);
    public static final Color MOCCASIN = Color.fromRgb(255, 228, 181);
    public static final Color NAVAJO_WHITE = Color.fromRgb(255, 222, 173);
    public static final Color NAVY = Color.fromRgb(0, 0, 128);
    public static final Color OLD_LACE = Color.fromRgb(253, 245, 230);
    public static final Color OLIVE = Color.fromRgb(128, 128, 0);
    public static final Color OLIVE_DRAB = Color.fromRgb(107, 142, 35);
    public static final Color ORANGE = Color.fromRgb(255, 165, 0);
    public static final Color ORANGE_RED = Color.fromRgb(255, 69, 0);
    public static final Color ORCHID = Color.fromRgb(218, 112, 214);
    public static final Color PALE_GOLDENROD = Color.fromRgb(238, 232, 170);
    public static final Color PALE_GREEN = Color.fromRgb(152, 251, 152);
    public static final Color PALE_TURQUOISE = Color.fromRgb(175, 238, 238);
    public static final Color PALE_VIOLET_RED = Color.fromRgb(219, 112, 147);
    public static final Color PAPAYA_WHIP = Color.fromRgb(255, 239, 213);
    public static final Color PEACH_PUFF = Color.fromRgb(255, 218, 185);
    public static final Color PERU = Color.fromRgb(205, 133, 63);
    public static final Color PINK = Color.fromRgb(255, 192, 203);
    public static final Color PLUM = Color.fromRgb(221, 160, 221);
    public static final Color POWDER_BLUE = Color.fromRgb(176, 224, 230);
    public static final Color PURPLE = Color.fromRgb(128, 0, 128);
    public static final Color RED = Color.fromRgb(255, 0, 0);
    public static final Color ROSY_BROWN = Color.fromRgb(188, 143, 143);
    public static final Color ROYAL_BLUE = Color.fromRgb(65, 105, 225);
    public static final Color SADDLE_BROWN = Color.fromRgb(139, 69, 19);
    public static final Color SALMON = Color.fromRgb(250, 128, 114);
    public static final Color SANDY_BROWN = Color.fromRgb(244, 164, 96);
    public static final Color SEA_GREEN = Color.fromRgb(46, 139, 87);
    public static final Color SEA_SHELL = Color.fromRgb(255, 245, 238);
    public static final Color SIENNA = Color.fromRgb(160, 82, 45);
    public static final Color SILVER = Color.fromRgb(192, 192, 192);
    public static final Color SKY_BLUE = Color.fromRgb(135, 206, 235);
    public static final Color SLATE_BLUE = Color.fromRgb(106, 90, 205);
    public static final Color SLATE_GRAY = Color.fromRgb(112, 128, 144);
    public static final Color SNOW = Color.fromRgb(255, 250, 250);
    public static final Color SPRING_GREEN = Color.fromRgb(0, 255, 127);
    public static final Color STEEL_BLUE = Color.fromRgb(70, 130, 180);
    public static final Color TAN = Color.fromRgb(210, 180, 140);
    public static final Color TEAL = Color.fromRgb(0, 128, 128);
    public static final Color THISTLE = Color.fromRgb(216, 191, 216);
    public static final Color TOMATO = Color.fromRgb(255, 99, 71);
    public static final Color TURQUOISE = Color.fromRgb(64, 224, 208);
    public static final Color VIOLET = Color.fromRgb(238, 130, 238);
    public static final Color WHEAT = Color.fromRgb(245, 222, 179);
    public static final Color WHITE = Color.fromRgb(255, 255, 255);
    public static final Color WHITE_SMOKE = Color.fromRgb(245, 245, 245);
    public static final Color YELLOW = Color.fromRgb(255, 255, 0);
    public static final Color YELLOW_GREEN = Color.fromRgb(154, 205, 50);

    private Color(int value) {
        this.value = value;
    }

    public int getR() {
        return this.value >> 24 & 0xFF;
    }

    public int getG() {
        return this.value >> 16 & 0xFF;
    }

    public int getB() {
        return this.value >> 8 & 0xFF;
    }

    public int getA() {
        return this.value & 0xFF;
    }

    public static Color fromRgba(int rgba) {
        return new Color(rgba);
    }

    public static Color fromRgba(int r, int g, int b, int a) {
        return new Color((r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF);
    }

    public static Color fromRgb(int r, int g, int b) {
        return Color.fromRgba(r, g, b, 255);
    }

    public static Color fromRgba(Color baseColor, int a) {
        return Color.fromRgba(baseColor.getR(), baseColor.getG(), baseColor.getB(), a);
    }

    public int toRgba() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.getA() == 255) {
            return String.format("Color(r=%d, g=%d, b=%d)", this.getR(), this.getG(), this.getB());
        }
        return String.format("Color(r=%d, g=%d, b=%d, a=%d)", this.getR(), this.getG(), this.getB(), this.getA());
    }

    public String toHexColor() {
        if (this.getA() == 255) {
            return String.format("#%02X%02X%02X", this.getR(), this.getG(), this.getB());
        }
        return String.format("#%02X%02X%02X%02X", this.getR(), this.getG(), this.getB(), this.getA());
    }
}

