/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.Bot;
import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.EventInterruption;
import dev.robocode.tankroyale.botapi.internal.IStopResumeListener;
import dev.robocode.tankroyale.botapi.internal.InternalEventHandlers;
import java.util.concurrent.Callable;

public final class BotInternals
implements IStopResumeListener {
    private final Bot bot;
    private final BaseBotInternals baseBotInternals;
    private boolean overrideTurnRate;
    private boolean overrideGunTurnRate;
    private boolean overrideRadarTurnRate;
    private boolean overrideTargetSpeed;
    private double previousDirection;
    private double previousGunDirection;
    private double previousRadarDirection;
    private double distanceRemaining;
    private double turnRemaining;
    private double gunTurnRemaining;
    private double radarTurnRemaining;
    private boolean isOverDriving;
    private double savedPreviousDirection;
    private double savedPreviousGunDirection;
    private double savedPreviousRadarDirection;
    private double savedDistanceRemaining;
    private double savedTurnRemaining;
    private double savedGunTurnRemaining;
    private double savedRadarTurnRemaining;

    public BotInternals(Bot bot, BaseBotInternals baseBotInternals) {
        this.bot = bot;
        this.baseBotInternals = baseBotInternals;
        baseBotInternals.setStopResumeHandler(this);
        InternalEventHandlers instantEventHandlers = baseBotInternals.getInstantEventHandlers();
        instantEventHandlers.onNextTurn.subscribe(this::onNextTurn, 110);
        instantEventHandlers.onGameAborted.subscribe(e -> this.onGameAborted(), 100);
        instantEventHandlers.onRoundEnded.subscribe(e -> this.onRoundEnded(), 90);
        instantEventHandlers.onGameEnded.subscribe(this::onGameEnded, 90);
        instantEventHandlers.onDisconnected.subscribe(this::onDisconnected, 90);
        instantEventHandlers.onHitWall.subscribe(e -> this.onHitWall(), 90);
        instantEventHandlers.onHitBot.subscribe(this::onHitBot, 90);
        BotEventHandlers botEventHandlers = baseBotInternals.getBotEventHandlers();
        botEventHandlers.onDeath.subscribe(this::onDeath, 0);
    }

    private void onNextTurn(TickEvent e) {
        if (e.getTurnNumber() == 1) {
            this.onFirstTurn();
        }
        this.processTurn();
    }

    private void onFirstTurn() {
        this.baseBotInternals.stopThread();
        this.clearRemaining();
        this.baseBotInternals.startThread(this.bot);
    }

    private void clearRemaining() {
        this.distanceRemaining = 0.0;
        this.turnRemaining = 0.0;
        this.gunTurnRemaining = 0.0;
        this.radarTurnRemaining = 0.0;
        this.previousDirection = this.bot.getDirection();
        this.previousGunDirection = this.bot.getGunDirection();
        this.previousRadarDirection = this.bot.getRadarDirection();
    }

    private void onGameAborted() {
        this.baseBotInternals.stopThread();
    }

    private void onRoundEnded() {
        this.baseBotInternals.stopThread();
    }

    private void onGameEnded(GameEndedEvent e) {
        this.baseBotInternals.stopThread();
    }

    private void onDisconnected(DisconnectedEvent e) {
        this.baseBotInternals.stopThread();
    }

    private void processTurn() {
        if (this.bot.isDisabled()) {
            this.clearRemaining();
        } else {
            this.updateTurnRemaining();
            this.updateGunTurnRemaining();
            this.updateRadarTurnRemaining();
            this.updateMovement();
        }
    }

    private void onHitWall() {
        this.distanceRemaining = 0.0;
    }

    private void onHitBot(HitBotEvent e) {
        if (e.isRammed()) {
            this.distanceRemaining = 0.0;
        }
    }

    private void onDeath(DeathEvent e) {
        this.baseBotInternals.stopThread();
    }

    public void setTurnRate(double turnRate) {
        this.overrideTurnRate = false;
        this.turnRemaining = BotInternals.toInfiniteValue(turnRate);
        this.baseBotInternals.setTurnRate(turnRate);
    }

    public void setGunTurnRate(double gunTurnRate) {
        this.overrideGunTurnRate = false;
        this.gunTurnRemaining = BotInternals.toInfiniteValue(gunTurnRate);
        this.baseBotInternals.setGunTurnRate(gunTurnRate);
    }

    public void setRadarTurnRate(double radarTurnRate) {
        this.overrideRadarTurnRate = false;
        this.radarTurnRemaining = BotInternals.toInfiniteValue(radarTurnRate);
        this.baseBotInternals.setRadarTurnRate(radarTurnRate);
    }

    private static double toInfiniteValue(double turnRate) {
        if (turnRate > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (turnRate < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    public double getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public double getTurnRemaining() {
        return this.turnRemaining;
    }

    public double getGunTurnRemaining() {
        return this.gunTurnRemaining;
    }

    public double getRadarTurnRemaining() {
        return this.radarTurnRemaining;
    }

    public void setTargetSpeed(double targetSpeed) {
        this.overrideTargetSpeed = false;
        this.distanceRemaining = targetSpeed > 0.0 ? Double.POSITIVE_INFINITY : (targetSpeed < 0.0 ? Double.NEGATIVE_INFINITY : 0.0);
        this.baseBotInternals.setTargetSpeed(targetSpeed);
    }

    public void setForward(double distance) {
        this.overrideTargetSpeed = true;
        if (Double.isNaN(distance)) {
            throw new IllegalArgumentException("'distance' cannot be NaN");
        }
        this.getAndSetNewTargetSpeed(distance);
        this.distanceRemaining = distance;
    }

    public void forward(double distance) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setForward(distance);
            this.waitFor(() -> this.distanceRemaining == 0.0 && this.bot.getSpeed() == 0.0);
        }
    }

    public void setTurnLeft(double degrees) {
        this.overrideTurnRate = true;
        this.turnRemaining = degrees;
        this.baseBotInternals.setTurnRate(degrees);
    }

    public void turnLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnLeft(degrees);
            this.waitFor(() -> this.turnRemaining == 0.0);
        }
    }

    public void setTurnGunLeft(double degrees) {
        this.overrideGunTurnRate = true;
        this.gunTurnRemaining = degrees;
        this.baseBotInternals.setGunTurnRate(degrees);
    }

    public void turnGunLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnGunLeft(degrees);
            this.waitFor(() -> this.gunTurnRemaining == 0.0);
        }
    }

    public void setTurnRadarLeft(double degrees) {
        this.overrideRadarTurnRate = true;
        this.radarTurnRemaining = degrees;
        this.baseBotInternals.setRadarTurnRate(degrees);
    }

    public void turnRadarLeft(double degrees) {
        if (this.bot.isStopped()) {
            this.bot.go();
        } else {
            this.setTurnRadarLeft(degrees);
            this.waitFor(() -> this.radarTurnRemaining == 0.0);
        }
    }

    public void fire(double firepower) {
        this.bot.setFire(firepower);
        this.bot.go();
    }

    public void rescan() {
        EventInterruption.setInterruptible(ScannedBotEvent.class, true);
        this.bot.setRescan();
        this.bot.go();
    }

    public void waitFor(Callable<Boolean> condition) {
        do {
            this.bot.go();
        } while (this.baseBotInternals.isRunning() && !this.call(condition));
    }

    private boolean call(Callable<Boolean> condition) {
        try {
            return condition.call();
        }
        catch (Exception ex) {
            throw new BotException("Condition could not be computed", ex);
        }
    }

    public void stop(boolean overwrite) {
        this.baseBotInternals.setStop(overwrite);
        this.bot.go();
    }

    public void resume() {
        this.baseBotInternals.setResume();
        this.bot.go();
    }

    @Override
    public void onStop() {
        this.savedPreviousDirection = this.previousDirection;
        this.savedPreviousGunDirection = this.previousGunDirection;
        this.savedPreviousRadarDirection = this.previousRadarDirection;
        this.savedDistanceRemaining = this.distanceRemaining;
        this.savedTurnRemaining = this.turnRemaining;
        this.savedGunTurnRemaining = this.gunTurnRemaining;
        this.savedRadarTurnRemaining = this.radarTurnRemaining;
    }

    @Override
    public void onResume() {
        this.previousDirection = this.savedPreviousDirection;
        this.previousGunDirection = this.savedPreviousGunDirection;
        this.previousRadarDirection = this.savedPreviousRadarDirection;
        this.distanceRemaining = this.savedDistanceRemaining;
        this.turnRemaining = this.savedTurnRemaining;
        this.gunTurnRemaining = this.savedGunTurnRemaining;
        this.radarTurnRemaining = this.savedRadarTurnRemaining;
    }

    private void updateTurnRemaining() {
        double delta = this.bot.calcDeltaAngle(this.bot.getDirection(), this.previousDirection);
        this.previousDirection = this.bot.getDirection();
        if (!this.overrideTurnRate) {
            return;
        }
        if (Math.abs(this.turnRemaining) <= Math.abs(delta)) {
            this.turnRemaining = 0.0;
        } else {
            this.turnRemaining -= delta;
            if (this.isNearZero(this.turnRemaining)) {
                this.turnRemaining = 0.0;
            }
        }
        this.baseBotInternals.setTurnRate(this.turnRemaining);
    }

    private void updateGunTurnRemaining() {
        double delta = this.bot.calcDeltaAngle(this.bot.getGunDirection(), this.previousGunDirection);
        this.previousGunDirection = this.bot.getGunDirection();
        if (!this.overrideGunTurnRate) {
            return;
        }
        if (Math.abs(this.gunTurnRemaining) <= Math.abs(delta)) {
            this.gunTurnRemaining = 0.0;
        } else {
            this.gunTurnRemaining -= delta;
            if (this.isNearZero(this.gunTurnRemaining)) {
                this.gunTurnRemaining = 0.0;
            }
        }
        this.baseBotInternals.setGunTurnRate(this.gunTurnRemaining);
    }

    private void updateRadarTurnRemaining() {
        double delta = this.bot.calcDeltaAngle(this.bot.getRadarDirection(), this.previousRadarDirection);
        this.previousRadarDirection = this.bot.getRadarDirection();
        if (!this.overrideRadarTurnRate) {
            return;
        }
        if (Math.abs(this.radarTurnRemaining) <= Math.abs(delta)) {
            this.radarTurnRemaining = 0.0;
        } else {
            this.radarTurnRemaining -= delta;
            if (this.isNearZero(this.radarTurnRemaining)) {
                this.radarTurnRemaining = 0.0;
            }
        }
        this.baseBotInternals.setRadarTurnRate(this.radarTurnRemaining);
    }

    private void updateMovement() {
        if (!this.overrideTargetSpeed) {
            this.distanceRemaining = Math.abs(this.distanceRemaining) < Math.abs(this.bot.getSpeed()) ? 0.0 : (this.distanceRemaining -= this.bot.getSpeed());
        } else if (Double.isInfinite(this.distanceRemaining)) {
            this.baseBotInternals.setTargetSpeed(this.distanceRemaining == Double.POSITIVE_INFINITY ? 8.0 : -8.0);
        } else {
            double distance = this.distanceRemaining;
            double newSpeed = this.getAndSetNewTargetSpeed(distance);
            if (this.isNearZero(newSpeed) && this.isOverDriving) {
                distance = 0.0;
                this.isOverDriving = false;
            }
            if (Math.signum(distance * newSpeed) != -1.0) {
                this.isOverDriving = this.baseBotInternals.getDistanceTraveledUntilStop(newSpeed) > Math.abs(distance);
            }
            this.distanceRemaining = distance - newSpeed;
        }
    }

    private double getAndSetNewTargetSpeed(double distance) {
        double speed = this.baseBotInternals.getNewTargetSpeed(this.bot.getSpeed(), distance);
        this.baseBotInternals.setTargetSpeed(speed);
        return speed;
    }

    private boolean isNearZero(double value) {
        return Math.abs(value) < 1.0E-5;
    }
}

