/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.events.BotDeathEvent;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TeamMessageEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.events.WonRoundEvent;
import java.util.HashMap;
import java.util.Map;

public final class EventPriorities {
    private static final Map<Class<? extends BotEvent>, Integer> EVENT_PRIORITIES = EventPriorities.initializeEventPriorities();

    private EventPriorities() {
    }

    private static Map<Class<? extends BotEvent>, Integer> initializeEventPriorities() {
        HashMap<Class<? extends BotEvent>, Integer> priorities = new HashMap<Class<? extends BotEvent>, Integer>();
        priorities.put(WonRoundEvent.class, 150);
        priorities.put(SkippedTurnEvent.class, 140);
        priorities.put(TickEvent.class, 130);
        priorities.put(CustomEvent.class, 120);
        priorities.put(TeamMessageEvent.class, 110);
        priorities.put(BotDeathEvent.class, 100);
        priorities.put(BulletHitWallEvent.class, 90);
        priorities.put(BulletHitBulletEvent.class, 80);
        priorities.put(BulletHitBotEvent.class, 70);
        priorities.put(BulletFiredEvent.class, 60);
        priorities.put(HitByBulletEvent.class, 50);
        priorities.put(HitWallEvent.class, 40);
        priorities.put(HitBotEvent.class, 30);
        priorities.put(ScannedBotEvent.class, 20);
        priorities.put(DeathEvent.class, 10);
        return priorities;
    }

    public static <T extends BotEvent> void setPriority(Class<T> eventClass, int priority) {
        if (eventClass == null) {
            throw new NullPointerException("Event class cannot be null");
        }
        EVENT_PRIORITIES.put(eventClass, priority);
    }

    public static <T extends BotEvent> int getPriority(Class<T> eventClass) {
        if (eventClass == null) {
            throw new NullPointerException("Event class cannot be null");
        }
        if (!EVENT_PRIORITIES.containsKey(eventClass)) {
            throw new IllegalStateException("Could not get event priority for the class: " + eventClass.getSimpleName());
        }
        return EVENT_PRIORITIES.get(eventClass);
    }
}

