/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.Droid;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.InitialPosition;
import dev.robocode.tankroyale.botapi.events.ConnectedEvent;
import dev.robocode.tankroyale.botapi.events.ConnectionErrorEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.GameStartedEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.BotHandshakeFactory;
import dev.robocode.tankroyale.botapi.internal.InternalEventHandlers;
import dev.robocode.tankroyale.botapi.internal.json.JsonConverter;
import dev.robocode.tankroyale.botapi.mapper.EventMapper;
import dev.robocode.tankroyale.botapi.mapper.GameSetupMapper;
import dev.robocode.tankroyale.botapi.mapper.ResultsMapper;
import dev.robocode.tankroyale.schema.BotHandshake;
import dev.robocode.tankroyale.schema.BotReady;
import dev.robocode.tankroyale.schema.GameEndedEventForBot;
import dev.robocode.tankroyale.schema.GameStartedEventForBot;
import dev.robocode.tankroyale.schema.Message;
import dev.robocode.tankroyale.schema.ServerHandshake;
import dev.robocode.tankroyale.schema.TickEventForBot;
import java.net.URI;
import java.net.http.WebSocket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;

final class WebSocketHandler
implements WebSocket.Listener {
    private final BaseBotInternals baseBotInternals;
    private final URI serverUrl;
    private final String serverSecret;
    private final IBaseBot baseBot;
    private final BotInfo botInfo;
    private final BotEventHandlers botEventHandlers;
    private final InternalEventHandlers internalEventHandlers;
    private final CountDownLatch closedLatch;
    private WebSocket socket;
    private final StringBuilder payload = new StringBuilder();

    WebSocketHandler(BaseBotInternals baseBotInternals, URI serverUrl, String serverSecret, IBaseBot baseBot, BotInfo botInfo, BotEventHandlers botEventHandlers, InternalEventHandlers internalEventHandlers, CountDownLatch closedLatch) {
        this.baseBotInternals = baseBotInternals;
        this.serverUrl = serverUrl;
        this.serverSecret = serverSecret;
        this.baseBot = baseBot;
        this.botInfo = botInfo;
        this.botEventHandlers = botEventHandlers;
        this.internalEventHandlers = internalEventHandlers;
        this.closedLatch = closedLatch;
    }

    @Override
    public void onOpen(WebSocket websocket) {
        this.socket = websocket;
        this.botEventHandlers.onConnected.publish(new ConnectedEvent(this.serverUrl));
        WebSocket.Listener.super.onOpen(websocket);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket websocket, int statusCode, String reason) {
        DisconnectedEvent disconnectedEvent = new DisconnectedEvent(this.serverUrl, true, statusCode, reason);
        this.botEventHandlers.onDisconnected.publish(disconnectedEvent);
        this.internalEventHandlers.onDisconnected.publish(disconnectedEvent);
        this.closedLatch.countDown();
        return null;
    }

    @Override
    public void onError(WebSocket websocket, Throwable error) {
        this.botEventHandlers.onConnectionError.publish(new ConnectionErrorEvent(this.serverUrl, error));
        this.closedLatch.countDown();
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.payload.append(data);
        if (last) {
            JsonObject jsonMsg = JsonConverter.fromJson(this.payload.toString(), JsonObject.class);
            this.payload.delete(0, this.payload.length());
            JsonElement jsonType = jsonMsg.get("type");
            if (jsonType != null) {
                String type = jsonType.getAsString();
                switch (Message.Type.fromValue(type)) {
                    case TICK_EVENT_FOR_BOT: {
                        this.handleTick(jsonMsg);
                        break;
                    }
                    case ROUND_STARTED_EVENT: {
                        this.handleRoundStarted(jsonMsg);
                        break;
                    }
                    case ROUND_ENDED_EVENT_FOR_BOT: {
                        this.handleRoundEnded(jsonMsg);
                        break;
                    }
                    case GAME_STARTED_EVENT_FOR_BOT: {
                        this.handleGameStarted(jsonMsg);
                        break;
                    }
                    case GAME_ENDED_EVENT_FOR_BOT: {
                        this.handleGameEnded(jsonMsg);
                        break;
                    }
                    case SKIPPED_TURN_EVENT: {
                        this.handleSkippedTurn(jsonMsg);
                        break;
                    }
                    case SERVER_HANDSHAKE: {
                        this.handleServerHandshake(jsonMsg);
                        break;
                    }
                    case GAME_ABORTED_EVENT: {
                        this.handleGameAborted();
                        break;
                    }
                    default: {
                        throw new BotException("Unsupported WebSocket message type: " + type);
                    }
                }
            }
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    private void handleTick(JsonObject jsonMsg) {
        if (this.baseBotInternals.getEventHandlingDisabledTurn()) {
            return;
        }
        this.baseBotInternals.setTickStartNanoTime(System.nanoTime());
        TickEventForBot tickEventForBot = JsonConverter.fromJson(jsonMsg, TickEventForBot.class);
        TickEvent mappedTickEvent = EventMapper.map(tickEventForBot, this.baseBot);
        this.baseBotInternals.addEventsFromTick(mappedTickEvent);
        if (this.baseBotInternals.getBotIntent().getRescan() != null && this.baseBotInternals.getBotIntent().getRescan().booleanValue()) {
            this.baseBotInternals.getBotIntent().setRescan(false);
        }
        this.baseBotInternals.setTickEvent(mappedTickEvent);
        mappedTickEvent.getEvents().forEach(this.internalEventHandlers::fireEvent);
        this.internalEventHandlers.onNextTurn.publish(mappedTickEvent);
    }

    private void handleRoundStarted(JsonObject jsonMsg) {
        RoundStartedEvent roundStartedEvent = JsonConverter.fromJson(jsonMsg, RoundStartedEvent.class);
        RoundStartedEvent mappedRoundStartedEvent = new RoundStartedEvent(roundStartedEvent.getRoundNumber());
        this.botEventHandlers.onRoundStarted.publish(mappedRoundStartedEvent);
        this.internalEventHandlers.onRoundStarted.publish(mappedRoundStartedEvent);
    }

    private void handleRoundEnded(JsonObject jsonMsg) {
        RoundEndedEvent roundEndedEvent = JsonConverter.fromJson(jsonMsg, RoundEndedEvent.class);
        RoundEndedEvent mappedRoundEndedEvent = new RoundEndedEvent(roundEndedEvent.getRoundNumber(), roundEndedEvent.getTurnNumber(), roundEndedEvent.getResults());
        this.botEventHandlers.onRoundEnded.publish(mappedRoundEndedEvent);
        this.internalEventHandlers.onRoundEnded.publish(mappedRoundEndedEvent);
    }

    private void handleGameStarted(JsonObject jsonMsg) {
        GameStartedEventForBot gameStartedEventForBot = JsonConverter.fromJson(jsonMsg, GameStartedEventForBot.class);
        this.baseBotInternals.setMyId(gameStartedEventForBot.getMyId());
        HashSet<Integer> teammateIds = gameStartedEventForBot.getTeammateIds() == null ? Set.of() : new HashSet<Integer>(gameStartedEventForBot.getTeammateIds());
        this.baseBotInternals.setTeammateIds(teammateIds);
        this.baseBotInternals.setGameSetup(GameSetupMapper.map(gameStartedEventForBot.getGameSetup()));
        InitialPosition initialPosition = new InitialPosition(gameStartedEventForBot.getStartX(), gameStartedEventForBot.getStartY(), gameStartedEventForBot.getStartDirection());
        this.baseBotInternals.setInitialPosition(initialPosition);
        BotReady ready = new BotReady();
        ready.setType(Message.Type.BOT_READY);
        String msg = JsonConverter.toJson(ready);
        this.socket.sendText(msg, true);
        this.botEventHandlers.onGameStarted.publish(new GameStartedEvent(gameStartedEventForBot.getMyId(), initialPosition, this.baseBotInternals.getGameSetup()));
    }

    private void handleGameEnded(JsonObject jsonMsg) {
        GameEndedEventForBot gameEndedEventForBot = JsonConverter.fromJson(jsonMsg, GameEndedEventForBot.class);
        GameEndedEvent mappedGameEnded = new GameEndedEvent(gameEndedEventForBot.getNumberOfRounds(), ResultsMapper.map(gameEndedEventForBot.getResults()));
        this.botEventHandlers.onGameEnded.publish(mappedGameEnded);
        this.internalEventHandlers.onGameEnded.publish(mappedGameEnded);
    }

    private void handleGameAborted() {
        this.botEventHandlers.onGameAborted.publish(null);
        this.internalEventHandlers.onGameAborted.publish(null);
    }

    private void handleSkippedTurn(JsonObject jsonMsg) {
        if (this.baseBotInternals.getEventHandlingDisabledTurn()) {
            return;
        }
        dev.robocode.tankroyale.schema.SkippedTurnEvent skippedTurnEvent = JsonConverter.fromJson(jsonMsg, dev.robocode.tankroyale.schema.SkippedTurnEvent.class);
        this.botEventHandlers.onSkippedTurn.publish((SkippedTurnEvent)EventMapper.map(skippedTurnEvent, this.baseBot));
    }

    private void handleServerHandshake(JsonObject jsonMsg) {
        ServerHandshake serverHandshake = JsonConverter.fromJson(jsonMsg, ServerHandshake.class);
        this.baseBotInternals.setServerHandshake(serverHandshake);
        boolean isDroid = this.baseBot instanceof Droid;
        BotHandshake botHandshake = BotHandshakeFactory.create(serverHandshake.getSessionId(), this.botInfo, isDroid, this.serverSecret);
        String msg = JsonConverter.toJson(botHandshake);
        this.socket.sendText(msg, true);
    }
}

