/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import dev.robocode.tankroyale.botapi.graphics.Color;
import dev.robocode.tankroyale.botapi.util.ColorUtil;
import dev.robocode.tankroyale.schema.BotDeathEvent;
import dev.robocode.tankroyale.schema.BotHitBotEvent;
import dev.robocode.tankroyale.schema.BotHitWallEvent;
import dev.robocode.tankroyale.schema.BulletFiredEvent;
import dev.robocode.tankroyale.schema.BulletHitBotEvent;
import dev.robocode.tankroyale.schema.BulletHitBulletEvent;
import dev.robocode.tankroyale.schema.BulletHitWallEvent;
import dev.robocode.tankroyale.schema.Event;
import dev.robocode.tankroyale.schema.ScannedBotEvent;
import dev.robocode.tankroyale.schema.TeamMessageEvent;
import dev.robocode.tankroyale.schema.WonRoundEvent;
import java.io.IOException;
import java.lang.reflect.Type;

final class GsonFactory {
    private static Gson gson;

    GsonFactory() {
    }

    static Gson getGson() {
        if (gson == null) {
            gson = GsonFactory.createGson();
        }
        return gson;
    }

    private static Gson createGson() {
        if (gson == null) {
            gson = new GsonBuilder().registerTypeAdapterFactory(GsonFactory.getEventTypeFactory()).registerTypeAdapter((Type)((Object)Color.class), new ColorTypeAdapter()).serializeSpecialFloatingPointValues().create();
        }
        return gson;
    }

    private static RuntimeTypeAdapterFactory<Event> getEventTypeFactory() {
        return RuntimeTypeAdapterFactory.of(Event.class, "type").registerSubtype(BotDeathEvent.class, "BotDeathEvent").registerSubtype(BotHitBotEvent.class, "BotHitBotEvent").registerSubtype(BotHitWallEvent.class, "BotHitWallEvent").registerSubtype(BulletFiredEvent.class, "BulletFiredEvent").registerSubtype(BulletHitBotEvent.class, "BulletHitBotEvent").registerSubtype(BulletHitBulletEvent.class, "BulletHitBulletEvent").registerSubtype(BulletHitWallEvent.class, "BulletHitWallEvent").registerSubtype(ScannedBotEvent.class, "ScannedBotEvent").registerSubtype(WonRoundEvent.class, "WonRoundEvent").registerSubtype(TeamMessageEvent.class, "TeamMessageEvent");
    }

    private static final class ColorTypeAdapter
    extends TypeAdapter<Color> {
        private ColorTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, Color color) throws IOException {
            if (color == null) {
                out.nullValue();
                return;
            }
            String hexColor = String.format("#%02x%02x%02x", color.getR(), color.getG(), color.getB());
            out.value(hexColor);
        }

        @Override
        public Color read(JsonReader in) throws IOException {
            String webColor = in.nextString();
            return ColorUtil.fromHexColor(webColor);
        }
    }
}

