/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.util;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CubeBuilder {
    private Vertex start;
    private float width;
    private float height;
    private float depth;
    private int right1;
    private int right2;
    private int top1;
    private int top2;
    private int left1;
    private int left2;
    private int bottom1;
    private int bottom2;
    private int far1;
    private int far2;
    private int near1;
    private int near2;
    private boolean enableBottom;
    private boolean enableTop;
    private boolean enableFar;
    private boolean enableNear;
    private boolean enableRight;
    private boolean enableLeft;

    public CubeBuilder(Vertex start, float width, float height, float depth) {
        this.start = start;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.near1 = this.near2 = Color.BLACK.getRGB();
        this.far2 = this.near2;
        this.far1 = this.near2;
        this.bottom2 = this.near2;
        this.bottom1 = this.near2;
        this.left2 = this.near2;
        this.left1 = this.near2;
        this.top2 = this.near2;
        this.top1 = this.near2;
        this.right2 = this.near2;
        this.right1 = this.near2;
        this.enableLeft = true;
        this.enableRight = true;
        this.enableNear = true;
        this.enableFar = true;
        this.enableTop = true;
        this.enableBottom = true;
    }

    @Deprecated(forRemoval=true)
    public int getFront1() {
        return this.right1;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setFront1(int front1) {
        this.right1 = front1;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getFront2() {
        return this.right2;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setFront2(int front2) {
        this.right2 = front2;
        return this;
    }

    public int getRight1() {
        return this.right1;
    }

    public CubeBuilder setRight1(int front1) {
        this.right1 = front1;
        return this;
    }

    public int getRight2() {
        return this.right2;
    }

    public CubeBuilder setRight2(int front2) {
        this.right2 = front2;
        return this;
    }

    public int getTop1() {
        return this.top1;
    }

    public CubeBuilder setTop1(int top1) {
        this.top1 = top1;
        return this;
    }

    public int getTop2() {
        return this.top2;
    }

    public CubeBuilder setTop2(int top2) {
        this.top2 = top2;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getBack1() {
        return this.left1;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setBack1(int back1) {
        this.left1 = back1;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getBack2() {
        return this.left2;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setBack2(int back2) {
        this.left2 = back2;
        return this;
    }

    public int getLeft1() {
        return this.left1;
    }

    public CubeBuilder setLeft1(int back1) {
        this.left1 = back1;
        return this;
    }

    public int getLeft2() {
        return this.left2;
    }

    public CubeBuilder setLeft2(int back2) {
        this.left2 = back2;
        return this;
    }

    public int getBottom1() {
        return this.bottom1;
    }

    public CubeBuilder setBottom1(int bottom1) {
        this.bottom1 = bottom1;
        return this;
    }

    public int getBottom2() {
        return this.bottom2;
    }

    public CubeBuilder setBottom2(int bottom2) {
        this.bottom2 = bottom2;
        return this;
    }

    public int getFar1() {
        return this.far1;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setUp1(int up1) {
        this.far1 = up1;
        return this;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setUp2(int up2) {
        this.far2 = up2;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getUp2() {
        return this.far2;
    }

    @Deprecated(forRemoval=true)
    public int getUp1() {
        return this.far1;
    }

    public CubeBuilder setFar1(int up1) {
        this.far1 = up1;
        return this;
    }

    public int getFar2() {
        return this.far2;
    }

    public CubeBuilder setFar2(int up2) {
        this.far2 = up2;
        return this;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setDown2(int down2) {
        this.near2 = down2;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getDown1() {
        return this.near1;
    }

    @Deprecated(forRemoval=true)
    public CubeBuilder setDown1(int down1) {
        this.near1 = down1;
        return this;
    }

    @Deprecated(forRemoval=true)
    public int getDown2() {
        return this.near2;
    }

    public int getNear1() {
        return this.near1;
    }

    public CubeBuilder setNear1(int down1) {
        this.near1 = down1;
        return this;
    }

    public int getNear2() {
        return this.near2;
    }

    public CubeBuilder setNear2(int down2) {
        this.near2 = down2;
        return this;
    }

    public Model cube() {
        final ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        if (this.enableBottom) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z + this.depth), this.bottom1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y, this.start.z), this.bottom2));
        }
        if (this.enableTop) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x, this.start.y + this.height, this.start.z), this.top1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y + this.height, this.start.z), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), this.top2));
        }
        if (this.enableRight) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z), this.right1));
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), this.right2));
        }
        if (this.enableLeft) {
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y + this.height, this.start.z), new Vertex(this.start.x, this.start.y + this.height, this.start.z + this.depth), this.left1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x, this.start.y, this.start.z + this.depth), new Vertex(this.start.x, this.start.y, this.start.z), this.left2));
        }
        if (this.enableFar) {
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z + this.depth), new Vertex(this.start.x, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), this.far1));
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z + this.depth), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.depth), new Vertex(this.start.x, this.start.y, this.start.z + this.depth), this.far2));
        }
        if (this.enableNear) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z), new Vertex(this.start.x, this.start.y + this.height, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z), this.near1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y + this.height, this.start.z), this.near2));
        }
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return triangles;
            }
        };
    }

    public CubeBuilder disableBottom() {
        this.enableBottom = false;
        return this;
    }

    public CubeBuilder disableTop() {
        this.enableTop = false;
        return this;
    }

    public CubeBuilder disableFront() {
        this.enableRight = false;
        return this;
    }

    public CubeBuilder disableBack() {
        this.enableLeft = false;
        return this;
    }

    public CubeBuilder disableUp() {
        this.enableFar = false;
        return this;
    }

    public CubeBuilder disableDown() {
        this.enableNear = false;
        return this;
    }
}

