/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ExportWizard;

public class ExportResourcesAction
extends SelectionListenerAction {
    private static final int SIZING_WIZARD_WIDTH = 470;
    private static final int SIZING_WIZARD_HEIGHT = 550;
    private IWorkbench workbench;

    public ExportResourcesAction(IWorkbench aWorkbench) {
        this(aWorkbench, WorkbenchMessages.getString("ExportResourcesAction.text"));
    }

    public ExportResourcesAction(IWorkbench aWorkbench, String label) {
        super(label);
        this.setToolTipText(WorkbenchMessages.getString("ExportResourcesAction.toolTip"));
        this.setId("export");
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.export_action_context");
        this.workbench = aWorkbench;
    }

    public void run() {
        ISelection workbenchSelection;
        ExportWizard wizard = new ExportWizard();
        List selectedResources = this.getSelectedResources();
        Object selectionToPass = selectedResources.isEmpty() ? ((workbenchSelection = this.workbench.getActiveWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection ? (IStructuredSelection)workbenchSelection : StructuredSelection.EMPTY) : new StructuredSelection(selectedResources);
        wizard.init(this.workbench, (IStructuredSelection)selectionToPass);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ExportResourcesAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ExportResourcesAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.workbench.getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 550);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.export_wizard_context");
        dialog.open();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selectionChanged(selection);
    }
}

