/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;

public class OpenFileAction
extends OpenSystemEditorAction {
    public static final String ID = "org.eclipse.ui.OpenFileAction";
    private IEditorDescriptor editorDescriptor;

    public OpenFileAction(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenFileAction(IWorkbenchPage page, IEditorDescriptor descriptor) {
        super(page);
        this.setText(descriptor == null ? WorkbenchMessages.getString("OpenFileAction.text") : descriptor.getLabel());
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.open_file_action_context");
        this.setToolTipText(WorkbenchMessages.getString("OpenFileAction.toolTip"));
        this.setId(ID);
        this.editorDescriptor = descriptor;
    }

    boolean ensureFileLocal(IFile file) {
        return true;
    }

    void openFile(IFile file) {
        if (this.getWorkbenchPage() == null) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("OpenFileAction.openFileError"), null);
            WorkbenchPlugin.log(WorkbenchMessages.getString("OpenFileAction.openFileErrorTitle"), (IStatus)status);
            return;
        }
        try {
            boolean activate = OpenStrategy.activateOnOpen();
            if (this.editorDescriptor == null) {
                this.getWorkbenchPage().openEditor(file, null, activate);
            } else if (this.ensureFileLocal(file)) {
                this.getWorkbenchPage().openEditor(file, this.editorDescriptor.getId(), activate);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), WorkbenchMessages.getString("OpenFileAction.openFileShellTitle"), ((Throwable)((Object)e)).getMessage(), e);
        }
    }
}

