/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.misc.Assert;

public class OpenSystemEditorAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.OpenSystemEditorAction";
    private IWorkbenchPage workbenchPage;

    public OpenSystemEditorAction(IWorkbenchPage page) {
        super(WorkbenchMessages.getString("OpenSystemEditorAction.text"));
        this.setToolTipText(WorkbenchMessages.getString("OpenSystemEditorAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.open_system_editor_action_context");
        Assert.isNotNull(page);
        this.workbenchPage = page;
    }

    IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    void openFile(IFile file) {
        if (this.getWorkbenchPage() == null) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("OpenSystemEditorAction.pageError"), null);
            WorkbenchPlugin.log(WorkbenchMessages.getString("OpenSystemEditorAction.logTitle"), (IStatus)status);
            return;
        }
        try {
            this.getWorkbenchPage().openSystemEditor(file);
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), WorkbenchMessages.getString("OpenSystemEditorAction.dialogTitle"), ((Throwable)((Object)e)).getMessage(), e);
        }
    }

    public void run() {
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource resource = (IResource)iterator.next();
            if (!(resource instanceof IFile)) continue;
            this.openFile((IFile)resource);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.selectionIsOfType(1);
    }
}

