/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AcceleratorMenu {
    private int[] accelerators;
    private Menu parent;
    private Menu menu;
    private MenuItem item;
    private Control focusControl;
    private SelectionListener selectionListener;
    private VerifyListener verifyListener;
    private Listener menuItemListener;
    private Listener parentListener;
    private Listener focusControlListener;

    public AcceleratorMenu(Menu parent) {
        this.parent = parent;
        this.menu = new Menu(parent.getParent(), 4);
        if (!parent.isVisible()) {
            this.item = new MenuItem(parent, 64, 0);
            this.item.setText("");
            this.item.setMenu(this.menu);
        }
        this.focusControlListener = new Listener(){

            public void handleEvent(Event event) {
                if (AcceleratorMenu.this.verifyListener == null || AcceleratorMenu.this.menu.isDisposed()) {
                    return;
                }
                if (event.type == 1) {
                    switch (event.keyCode) {
                        case 65536: 
                        case 131072: 
                        case 262144: {
                            return;
                        }
                    }
                }
                VerifyEvent verifyEvent = new VerifyEvent(event);
                if (event.text == null) {
                    event.text = "";
                }
                AcceleratorMenu.this.verifyListener.verifyText(verifyEvent);
                event.text = verifyEvent.text;
                event.doit = verifyEvent.doit;
            }
        };
        this.menuItemListener = new Listener(){

            public void handleEvent(Event event) {
                if (AcceleratorMenu.this.selectionListener != null) {
                    SelectionEvent selectionEvent = new SelectionEvent(event);
                    MenuItem item = (MenuItem)event.widget;
                    selectionEvent.detail = item.getAccelerator();
                    AcceleratorMenu.this.selectionListener.widgetSelected(selectionEvent);
                }
            }
        };
        this.parentListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        AcceleratorMenu.this.dispose();
                        break;
                    }
                    case 22: {
                        if (AcceleratorMenu.this.item == null || AcceleratorMenu.this.item.isDisposed()) break;
                        AcceleratorMenu.this.item.setMenu(null);
                        AcceleratorMenu.this.item.dispose();
                        AcceleratorMenu.this.item = null;
                        break;
                    }
                    case 23: {
                        AcceleratorMenu.this.item = new MenuItem(AcceleratorMenu.this.parent, 64, 0);
                        if (AcceleratorMenu.this.menu.isDisposed()) {
                            AcceleratorMenu.this.setAccelerators(AcceleratorMenu.this.getAccelerators());
                            break;
                        }
                        AcceleratorMenu.this.item.setMenu(AcceleratorMenu.this.menu);
                    }
                }
            }
        };
        parent.addListener(22, this.parentListener);
        parent.addListener(23, this.parentListener);
        parent.addListener(12, this.parentListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public void addVerifyListener(VerifyListener listener) {
        this.verifyListener = listener;
        this.setMultiMode(true);
    }

    public boolean isDisposed() {
        return this.item == null || this.item.isDisposed();
    }

    public void dispose() {
        this.setMultiMode(false);
        this.parent.removeListener(22, this.parentListener);
        this.parent.removeListener(23, this.parentListener);
        this.parent.removeListener(12, this.parentListener);
        this.menu.dispose();
        this.menu = null;
        if (this.item != null) {
            this.item.dispose();
        }
        this.item = null;
        this.focusControl = null;
        this.parent = null;
        this.verifyListener = null;
        this.parentListener = null;
        this.selectionListener = null;
        this.focusControlListener = null;
        this.menuItemListener = null;
    }

    public int[] getAccelerators() {
        if (this.accelerators == null) {
            return null;
        }
        int[] accelerators = new int[this.accelerators.length];
        System.arraycopy(this.accelerators, 0, accelerators, 0, this.accelerators.length);
        return accelerators;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        selectionListener = null;
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.verifyListener = null;
        this.setMultiMode(false);
    }

    public void setAccelerators(int[] accelerators) {
        if (Arrays.equals(this.accelerators, accelerators)) {
            return;
        }
        if (accelerators == null) {
            this.accelerators = null;
        } else {
            this.accelerators = new int[accelerators.length];
            System.arraycopy(accelerators, 0, this.accelerators, 0, accelerators.length);
        }
        this.menu.dispose();
        this.menu = new Menu(this.parent.getParent(), 4);
        if (this.item != null) {
            this.item.setMenu(this.menu);
        }
        int i = 0;
        while (i < accelerators.length) {
            int key = accelerators[i];
            MenuItem keyMenuItem = new MenuItem(this.menu, 8);
            keyMenuItem.setAccelerator(key);
            keyMenuItem.addListener(13, this.menuItemListener);
            ++i;
        }
    }

    private void setMultiMode(boolean mode) {
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            this.focusControl.removeListener(1, this.focusControlListener);
            this.focusControl.removeListener(25, this.focusControlListener);
            this.focusControl.removeListener(16, this.focusControlListener);
            this.focusControl.removeListener(12, this.focusControlListener);
        }
        if (mode) {
            Display display = this.menu.getDisplay();
            this.focusControl = display.getFocusControl();
            if (this.focusControl != null) {
                this.focusControl.addListener(1, this.focusControlListener);
                this.focusControl.addListener(25, this.focusControlListener);
                this.focusControl.addListener(16, this.focusControlListener);
                this.focusControl.addListener(12, this.focusControlListener);
            }
        }
    }
}

