/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;

public abstract class ActiveEditorAction
extends PageEventAction {
    private IEditorPart activeEditor;

    protected ActiveEditorAction(String text, IWorkbenchWindow window) {
        super(text, window);
        this.updateState();
    }

    protected void editorActivated(IEditorPart part) {
    }

    protected void editorDeactivated(IEditorPart part) {
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateActiveEditor();
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateActiveEditor();
        this.updateState();
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        super.partDeactivated(part);
        if (part instanceof IEditorPart) {
            this.updateActiveEditor();
            this.updateState();
        }
    }

    private void setActiveEditor(IEditorPart part) {
        if (this.activeEditor == part) {
            return;
        }
        if (this.activeEditor != null) {
            this.editorDeactivated(this.activeEditor);
        }
        this.activeEditor = part;
        if (this.activeEditor != null) {
            this.editorActivated(this.activeEditor);
        }
    }

    private void updateActiveEditor() {
        if (this.getActivePage() == null) {
            this.setActiveEditor(null);
        } else {
            this.setActiveEditor(this.getActivePage().getActiveEditor());
        }
    }

    protected void updateState() {
        this.setEnabled(this.getActiveEditor() != null);
    }
}

