/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

class EditorAreaDropAdapter
extends DropTargetAdapter {
    private WorkbenchPage page;

    public EditorAreaDropAdapter(WorkbenchPage page) {
        this.page = page;
    }

    public void drop(final DropTargetEvent event) {
        Display d = this.page.getWorkbenchWindow().getShell().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                EditorAreaDropAdapter.this.asyncDrop(event);
            }
        });
    }

    private void asyncDrop(DropTargetEvent event) {
        if (EditorInputTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Assert.isTrue(event.data instanceof EditorInputTransfer.EditorInputData[]);
            EditorInputTransfer.EditorInputData[] editorInputs = (EditorInputTransfer.EditorInputData[])event.data;
            try {
                int i = 0;
                while (i < editorInputs.length) {
                    String editorId = editorInputs[i].editorId;
                    IEditorInput editorInput = editorInputs[i].input;
                    this.page.openInternalEditor(editorInput, editorId);
                    ++i;
                }
            }
            catch (PartInitException partInitException) {}
        } else if (MarkerTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Assert.isTrue(event.data instanceof IMarker[]);
            IMarker[] markers = (IMarker[])event.data;
            try {
                int i = 0;
                while (i < markers.length) {
                    this.page.openInternalEditor(markers[i]);
                    ++i;
                }
            }
            catch (PartInitException partInitException) {}
        } else if (ResourceTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Assert.isTrue(event.data instanceof IResource[]);
            IResource[] files = (IResource[])event.data;
            try {
                int i = 0;
                while (i < files.length) {
                    if (files[i] instanceof IFile) {
                        this.page.openInternalEditor((IFile)files[i]);
                    }
                    ++i;
                }
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }
}

