/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistory
implements INavigationHistory {
    private static final int CAPACITY = 50;
    private NavigationHistoryAction backwardAction;
    private NavigationHistoryAction forwardAction;
    private int ignoreEntries;
    private ArrayList history = new ArrayList(50);
    private WorkbenchPage page;
    private int activeEntry = 0;

    public NavigationHistory(WorkbenchPage page) {
        this.page = page;
        page.addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    IEditorPart editor = (IEditorPart)part;
                    IEditorInput input = editor.getEditorInput();
                    String id = editor.getSite().getId();
                    Iterator e = ((AbstractList)NavigationHistory.this.history).iterator();
                    NavigationHistoryEntry firstEntry = null;
                    while (e.hasNext()) {
                        NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
                        if (!id.equals(entry.editorID) || !input.equals(entry.editorInput)) continue;
                        entry.mementoEntry = firstEntry;
                        if (entry.handlePartClosed()) {
                            if (firstEntry != null) continue;
                            firstEntry = entry;
                            continue;
                        }
                        e.remove();
                        entry.dispose();
                    }
                }
            }
        });
    }

    public void clear() {
        this.activeEntry = 0;
        int i = 0;
        while (i < this.history.size()) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.get(i);
            e.dispose();
            ++i;
        }
        this.history = new ArrayList();
        this.updateActions();
    }

    public void markEditor(IEditorPart part) {
        this.addEntry(part, false);
    }

    public void markLocation(IEditorPart part) {
        this.addEntry(part, true);
    }

    NavigationHistoryEntry[] getBackwardEntries() {
        int length = this.activeEntry;
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        int i = 0;
        while (i < this.activeEntry) {
            entries[this.activeEntry - 1 - i] = this.getEntry(i);
            ++i;
        }
        return entries;
    }

    NavigationHistoryEntry[] getForwardEntries() {
        int length = this.history.size() - this.activeEntry - 1;
        length = Math.max(0, length);
        NavigationHistoryEntry[] entries = new NavigationHistoryEntry[length];
        int i = this.activeEntry + 1;
        while (i < this.history.size()) {
            entries[i - this.activeEntry - 1] = this.getEntry(i);
            ++i;
        }
        return entries;
    }

    public INavigationLocation[] getLocations() {
        INavigationLocation[] result = new INavigationLocation[this.history.size()];
        int i = 0;
        while (i < result.length) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.get(i);
            result[i] = e.location;
            ++i;
        }
        return result;
    }

    public INavigationLocation getCurrentLocation() {
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        return entry == null ? null : entry.location;
    }

    public void dispose() {
        Iterator e = ((AbstractList)this.history).iterator();
        while (e.hasNext()) {
            NavigationHistoryEntry entry = (NavigationHistoryEntry)e.next();
            entry.dispose();
        }
    }

    public void setForwardAction(NavigationHistoryAction action) {
        this.forwardAction = action;
        this.updateActions();
    }

    public void setBackwardAction(NavigationHistoryAction action) {
        this.backwardAction = action;
        this.updateActions();
    }

    private NavigationHistoryEntry getEntry(int index) {
        if (index >= 0 && index < this.history.size()) {
            return (NavigationHistoryEntry)this.history.get(index);
        }
        return null;
    }

    private void add(NavigationHistoryEntry entry) {
        this.removeForwardEntries();
        if (this.history.size() == 50) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(0);
            e.dispose();
        }
        this.history.add(entry);
        this.activeEntry = this.history.size() - 1;
    }

    private void removeForwardEntries() {
        int length = this.history.size();
        int i = this.activeEntry + 1;
        while (i < length) {
            NavigationHistoryEntry e = (NavigationHistoryEntry)this.history.remove(this.activeEntry + 1);
            e.dispose();
            ++i;
        }
    }

    private void addEntry(IEditorPart part, boolean markLocation) {
        if (this.ignoreEntries > 0 || part == null) {
            return;
        }
        INavigationLocation location = null;
        if (markLocation && part instanceof INavigationLocationProvider) {
            location = ((INavigationLocationProvider)((Object)part)).createNavigationLocation();
        }
        NavigationHistoryEntry e = new NavigationHistoryEntry(this.page, part, location);
        NavigationHistoryEntry current = this.getEntry(this.activeEntry);
        if (current == null || !e.mergeInto(current)) {
            this.add(e);
        } else {
            this.removeForwardEntries();
        }
        this.updateActions();
    }

    private void printEntries() {
    }

    boolean canForward() {
        return this.activeEntry + 1 >= 0 && this.activeEntry + 1 < this.history.size();
    }

    boolean canBackward() {
        return this.activeEntry - 1 >= 0 && this.activeEntry - 1 < this.history.size();
    }

    private void updateActions() {
        if (this.backwardAction != null) {
            this.backwardAction.update();
        }
        if (this.forwardAction != null) {
            this.forwardAction.update();
        }
    }

    private void gotoEntry(NavigationHistoryEntry entry) {
        if (entry == null) {
            return;
        }
        try {
            ++this.ignoreEntries;
            entry.restoreLocation();
            this.updateActions();
            this.printEntries();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.ignoreEntries;
            throw throwable;
        }
        Object var2_4 = null;
        --this.ignoreEntries;
    }

    private void updateEntry(NavigationHistoryEntry activeEntry) {
        if (activeEntry == null || activeEntry.location == null) {
            return;
        }
        activeEntry.location.update();
    }

    public void forward() {
        if (this.canForward()) {
            this.shiftEntry(true);
        }
    }

    public void backward() {
        if (this.canBackward()) {
            this.shiftEntry(false);
        }
    }

    private void shiftEntry(boolean forward) {
        this.updateEntry(this.getEntry(this.activeEntry));
        this.activeEntry = forward ? ++this.activeEntry : --this.activeEntry;
        NavigationHistoryEntry entry = this.getEntry(this.activeEntry);
        if (entry != null) {
            this.gotoEntry(entry);
        }
    }

    protected void shiftCurrentEntry(NavigationHistoryEntry entry) {
        this.updateEntry(entry);
        this.activeEntry = this.history.indexOf(entry);
        this.gotoEntry(entry);
    }

    void saveState(IMemento memento) {
        NavigationHistoryEntry entry;
        NavigationHistoryEntry cEntry = this.getEntry(this.activeEntry);
        if (cEntry == null || !cEntry.isPersistable()) {
            return;
        }
        ArrayList<NavigationHistoryEntry> list = new ArrayList<NavigationHistoryEntry>(this.history.size());
        int size = this.history.size();
        int i = 0;
        while (i < size) {
            entry = (NavigationHistoryEntry)this.history.get(i);
            if (entry.isPersistable()) {
                list.add(entry);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size) {
            entry = (NavigationHistoryEntry)list.get(i);
            IMemento childMem = memento.createChild("item");
            if (entry == cEntry) {
                childMem.putString("active", "true");
            }
            entry.saveState(childMem, list);
            ++i;
        }
    }

    void restoreState(IMemento memento) {
        NavigationHistoryEntry entry;
        IMemento[] items = memento.getChildren("item");
        if (items.length == 0 && this.page.getActiveEditor() != null) {
            this.markLocation(this.page.getActiveEditor());
        }
        boolean oldHistory = false;
        int j = 0;
        int i = 0;
        while (i < items.length) {
            IMemento item = items[i];
            String entryText = item.getString("historyLabel");
            if (entryText == null) {
                oldHistory = true;
                break;
            }
            if (entryText.equals("")) {
                oldHistory = true;
                break;
            }
            NavigationHistoryEntry entry2 = new NavigationHistoryEntry(this.page);
            this.history.add(entry2);
            entry2.restoreState(item, this.history);
            if (item.getString("active") != null) {
                this.activeEntry = j;
            }
            ++j;
            ++i;
        }
        if (oldHistory) {
            this.history.clear();
            if (this.page.getActiveEditor() != null) {
                this.markLocation(this.page.getActiveEditor());
            }
            return;
        }
        if (items.length != 0 && j == 0 && this.page.getActiveEditor() != null) {
            this.markLocation(this.page.getActiveEditor());
        }
        if ((entry = this.getEntry(this.activeEntry)) != null && entry.editorInput != null && this.page.getActiveEditor() == this.page.findEditor(entry.editorInput)) {
            this.gotoEntry(entry);
        }
    }
}

