/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistoryAction
extends PageEventAction
implements IWorkbenchWindowPulldownDelegate2,
IMenuCreator {
    private boolean forward;
    private Menu historyMenu;
    private int MAX_HISTORY_LENGTH = 9;

    public NavigationHistoryAction(IWorkbenchWindow window, boolean forward) {
        super("", window);
        if (forward) {
            this.setText(WorkbenchMessages.getString("NavigationHistoryAction.forward.text"));
            this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.forward.toolTip"));
        } else {
            this.setText(WorkbenchMessages.getString("NavigationHistoryAction.backward.text"));
            this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.backward.toolTip"));
        }
        this.setEnabled(false);
        this.forward = forward;
        this.setMenuCreator(this);
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.setEnabled(false);
    }

    public void dispose() {
        if (this.historyMenu != null) {
            int i = 0;
            while (i < this.historyMenu.getItemCount()) {
                MenuItem menuItem = this.historyMenu.getItem(i);
                menuItem.setData(null);
                ++i;
            }
            this.historyMenu.dispose();
            this.historyMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        this.dispose();
        this.historyMenu = new Menu(parent);
        final NavigationHistory history = (NavigationHistory)this.getWorkbenchWindow().getActivePage().getNavigationHistory();
        NavigationHistoryEntry[] entries = this.forward ? history.getForwardEntries() : history.getBackwardEntries();
        int i = 0;
        while (i < entries.length) {
            if (i > this.MAX_HISTORY_LENGTH) break;
            String text = entries[i].getHistoryText();
            if (text != null) {
                MenuItem item = new MenuItem(this.historyMenu, 0);
                item.setData((Object)entries[i]);
                item.setText(text);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        history.shiftCurrentEntry((NavigationHistoryEntry)e.widget.getData());
                    }
                });
            }
            ++i;
        }
        return this.historyMenu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        NavigationHistory nh = (NavigationHistory)page.getNavigationHistory();
        if (this.forward) {
            nh.setForwardAction(this);
        } else {
            nh.setBackwardAction(this);
        }
    }

    public void run() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page != null) {
            NavigationHistory nh = (NavigationHistory)page.getNavigationHistory();
            if (this.forward) {
                nh.forward();
            } else {
                nh.backward();
            }
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void update() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        NavigationHistory history = (NavigationHistory)page.getNavigationHistory();
        if (this.forward) {
            this.setEnabled(history.canForward());
            NavigationHistoryEntry[] entries = history.getForwardEntries();
            if (entries.length > 0) {
                NavigationHistoryEntry entry = entries[0];
                String text = WorkbenchMessages.format("NavigationHistoryAction.forward.toolTipName", new String[]{entry.getHistoryText()});
                this.setToolTipText(text);
            } else {
                this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.forward.toolTip"));
            }
        } else {
            this.setEnabled(history.canBackward());
            NavigationHistoryEntry[] entries = history.getBackwardEntries();
            if (entries.length > 0) {
                NavigationHistoryEntry entry = entries[0];
                String text = WorkbenchMessages.format("NavigationHistoryAction.backward.toolTipName", new String[]{entry.getHistoryText()});
                this.setToolTipText(text);
            } else {
                this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.backward.toolTip"));
            }
        }
    }
}

