/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class NewConfigurationInfo {
    private IPluginDescriptor desc;
    private URL baseURL;
    private String featureId;
    private PluginVersionIdentifier versionId;
    private String iniFilename;
    private String propertiesFilename;
    private String mappingsFilename;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";

    protected NewConfigurationInfo(String fId, PluginVersionIdentifier vId, String ini, String properties, String mappings) {
        this.featureId = fId;
        this.versionId = vId;
        this.iniFilename = ini;
        this.propertiesFilename = properties;
        this.mappingsFilename = mappings;
    }

    public void readINIFile() throws CoreException {
        if (this.featureId == null) {
            this.reportINIFailure(null, "Unknown configuration identifier");
            return;
        }
        IPluginRegistry reg = Platform.getPluginRegistry();
        if (reg == null) {
            this.reportINIFailure(null, "Plugin registry is null");
            return;
        }
        if (this.getDescriptor() == null) {
            this.reportINIFailure(null, "Missing plugin descriptor for " + this.featureId);
            return;
        }
        this.baseURL = this.desc.getInstallURL();
        URL iniURL = null;
        try {
            iniURL = this.desc.find(new Path("$nl$").append(this.iniFilename));
            if (iniURL != null) {
                iniURL = Platform.resolve((URL)iniURL);
            }
        }
        catch (IOException iOException) {}
        if (iniURL == null) {
            this.reportINIFailure(null, "Unable to load plugin file: " + this.iniFilename);
            return;
        }
        URL propertiesURL = null;
        try {
            propertiesURL = this.desc.find(new Path("$nl$").append(this.propertiesFilename));
            if (propertiesURL != null) {
                propertiesURL = Platform.resolve((URL)propertiesURL);
            }
        }
        catch (IOException iOException) {
            this.reportINIFailure(null, "Unable to load plugin file: " + this.propertiesFilename);
        }
        URL mappingsURL = null;
        try {
            mappingsURL = this.desc.find(new Path("$nl$").append(this.mappingsFilename));
            if (mappingsURL != null) {
                mappingsURL = Platform.resolve((URL)mappingsURL);
            }
        }
        catch (IOException iOException) {
            this.reportINIFailure(null, "Unable to load mapping file: " + mappingsURL);
        }
        this.readINIFile(iniURL, propertiesURL, mappingsURL);
    }

    public IPluginDescriptor getDescriptor() {
        if (this.desc == null) {
            IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
            IPlatformConfiguration.IFeatureEntry feature = platformConfiguration.findConfiguredFeatureEntry(this.featureId);
            if (feature == null) {
                return null;
            }
            String pluginId = feature.getFeaturePluginIdentifier();
            String pluginVersion = feature.getFeaturePluginVersion();
            IPluginRegistry reg = Platform.getPluginRegistry();
            if (pluginVersion == null) {
                this.desc = reg.getPluginDescriptor(pluginId);
            } else {
                PluginVersionIdentifier vid = new PluginVersionIdentifier(pluginVersion);
                this.desc = reg.getPluginDescriptor(pluginId, vid);
                if (this.desc == null) {
                    this.desc = reg.getPluginDescriptor(pluginId);
                }
            }
        }
        return this.desc;
    }

    protected URL getBaseURL() {
        return this.baseURL;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    protected PluginVersionIdentifier getVersionId() {
        return this.versionId;
    }

    protected String getResourceString(String value, ResourceBundle b, String[] mappings, Hashtable runtimeMappings) {
        String dflt;
        if (value == null) {
            return null;
        }
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (b == null) {
            return dflt;
        }
        String result = null;
        try {
            result = b.getString(key.substring(1));
        }
        catch (MissingResourceException e) {
            this.reportINIFailure(e, "Property \"" + key + "\" not found");
            return dflt;
        }
        if (runtimeMappings != null) {
            Enumeration e = runtimeMappings.keys();
            while (e.hasMoreElements()) {
                String keyValue = (String)e.nextElement();
                int i = result.indexOf(keyValue);
                if (i == -1) continue;
                String s1 = result.substring(0, i);
                String s2 = (String)runtimeMappings.get(keyValue);
                String s3 = result.substring(i + keyValue.length());
                result = String.valueOf(s1) + s2 + s3;
            }
        }
        if (result.indexOf(123) != -1) {
            result = MessageFormat.format(result, mappings);
        }
        return result;
    }

    protected abstract void readINIFile(URL var1, URL var2, URL var3) throws CoreException;

    protected void reportINIFailure(Exception e, String message) {
        if (!WorkbenchPlugin.DEBUG) {
            return;
        }
        Status iniStatus = new Status(4, WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, message, (Throwable)e);
        WorkbenchPlugin.log("Problem reading configuration info for: " + this.getFeatureId(), (IStatus)iniStatus);
    }
}

