/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.ObjectActionContributorReader;
import org.eclipse.ui.internal.ObjectContributorManager;

public class ObjectActionContributorManager
extends ObjectContributorManager {
    private static ObjectActionContributorManager sharedInstance;

    public ObjectActionContributorManager() {
        this.loadContributors();
    }

    private List computeCombinedOrder(Class inputClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = inputClass;
        while (clazz != null) {
            result.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                result.add(interfaces[i]);
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager popupMenu, ISelectionProvider selProv) {
        IObjectActionContributor contributor;
        List results;
        int i;
        ISelection selection = selProv.getSelection();
        if (selection == null) {
            return false;
        }
        ArrayList<ISelection> elements = null;
        if (selection instanceof IStructuredSelection) {
            elements = ((IStructuredSelection)selection).toList();
        } else {
            elements = new ArrayList<ISelection>(1);
            elements.add(selection);
        }
        List commonClasses = this.getCommonClasses(elements);
        if (commonClasses == null || commonClasses.isEmpty()) {
            return false;
        }
        Class resourceClass = this.getCommonResourceClass(elements);
        List contributors = null;
        if (resourceClass == null) {
            if (commonClasses.size() == 1) {
                contributors = this.getContributors((Class)commonClasses.get(0));
            } else {
                contributors = new ArrayList();
                i = 0;
                while (i < commonClasses.size()) {
                    results = this.getContributors((Class)commonClasses.get(i));
                    if (results != null) {
                        contributors.addAll(results);
                    }
                    ++i;
                }
            }
        } else {
            contributors = this.getContributors((Class)commonClasses.get(0), resourceClass);
            i = 1;
            while (i < commonClasses.size()) {
                results = this.getContributors((Class)commonClasses.get(i));
                if (results != null) {
                    contributors.addAll(results);
                }
                ++i;
            }
        }
        if (contributors == null || contributors.isEmpty()) {
            return false;
        }
        boolean actualContributions = false;
        int i2 = 0;
        while (i2 < contributors.size()) {
            contributor = (IObjectActionContributor)contributors.get(i2);
            if (this.isApplicableTo(elements, (IObjectContributor)contributor) && contributor.contributeObjectMenus(popupMenu, selProv)) {
                actualContributions = true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < contributors.size()) {
            contributor = (IObjectActionContributor)contributors.get(i2);
            if (this.isApplicableTo(elements, (IObjectContributor)contributor) && contributor.contributeObjectActions(part, popupMenu, selProv)) {
                actualContributions = true;
            }
            ++i2;
        }
        return actualContributions;
    }

    private Class getCommonClass(Class class1, Class class2) {
        List list1 = this.computeCombinedOrder(class1);
        List list2 = this.computeCombinedOrder(class2);
        int i = 0;
        while (i < list1.size()) {
            int j = 0;
            while (j < list2.size()) {
                Class candidate2;
                Class candidate1 = (Class)list1.get(i);
                if (candidate1.equals(candidate2 = (Class)list2.get(j))) {
                    return candidate1;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Class getCommonClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        Class commonClass = objects.get(0).getClass();
        if (objects.size() == 1) {
            return commonClass;
        }
        int i = 1;
        while (i < objects.size()) {
            Object object = objects.get(i);
            Class<?> newClass = object.getClass();
            if (!newClass.equals(commonClass) && (commonClass = this.getCommonClass(commonClass, newClass)) == null) {
                return null;
            }
            ++i;
        }
        return commonClass;
    }

    private List getCommonClasses(List objects) {
        int j;
        if (objects == null || objects.size() == 0) {
            return null;
        }
        if (objects.size() == 1) {
            ArrayList results = new ArrayList(1);
            results.add(objects.get(0).getClass());
            return results;
        }
        List classes = this.computeClassOrder(objects.get(0).getClass());
        List interfaces = this.computeInterfaceOrder(classes);
        boolean classesEmpty = classes.isEmpty();
        boolean interfacesEmpty = interfaces.isEmpty();
        int i = 1;
        while (i < objects.size()) {
            List results = this.computeClassOrder(objects.get(i).getClass());
            if (!classesEmpty) {
                classesEmpty = true;
                if (results.isEmpty()) {
                    classes.clear();
                } else {
                    j = 0;
                    while (j < classes.size()) {
                        if (classes.get(j) != null) {
                            classesEmpty = false;
                            if (!results.contains(classes.get(j))) {
                                classes.set(j, null);
                            }
                        }
                        ++j;
                    }
                }
            }
            if (!interfacesEmpty) {
                results = this.computeInterfaceOrder(results);
                interfacesEmpty = true;
                if (results.isEmpty()) {
                    interfaces.clear();
                } else {
                    j = 0;
                    while (j < interfaces.size()) {
                        if (interfaces.get(j) != null) {
                            interfacesEmpty = false;
                            if (!results.contains(interfaces.get(j))) {
                                interfaces.set(j, null);
                            }
                        }
                        ++j;
                    }
                }
            }
            if (interfacesEmpty && classesEmpty) {
                return null;
            }
            ++i;
        }
        ArrayList results = new ArrayList(4);
        ArrayList superClasses = new ArrayList(4);
        if (!classesEmpty) {
            j = 0;
            while (j < classes.size()) {
                if (classes.get(j) != null) {
                    superClasses.add(classes.get(j));
                }
                ++j;
            }
            if (!superClasses.isEmpty()) {
                results.add(superClasses.get(0));
            }
        }
        if (!interfacesEmpty) {
            List dropInterfaces = null;
            if (!superClasses.isEmpty()) {
                dropInterfaces = this.computeInterfaceOrder(superClasses);
            }
            int j2 = 0;
            while (j2 < interfaces.size()) {
                if (interfaces.get(j2) != null && dropInterfaces != null && !dropInterfaces.contains(interfaces.get(j2))) {
                    results.add(interfaces.get(j2));
                }
                ++j2;
            }
        }
        return results;
    }

    public static ObjectActionContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new ObjectActionContributorManager();
        }
        return sharedInstance;
    }

    private void loadContributors() {
        ObjectActionContributorReader reader = new ObjectActionContributorReader();
        reader.readPopupContributors(this);
    }

    private Class getCommonResourceClass(List objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        ArrayList<IResource> testList = new ArrayList<IResource>();
        int i = 0;
        while (i < objects.size()) {
            Object object = objects.get(i);
            if (object instanceof IAdaptable) {
                if (!(object instanceof IResource)) {
                    IResource resource = this.getAdaptedResource((IAdaptable)object);
                    if (resource == null) {
                        return null;
                    }
                    testList.add(resource);
                }
            } else {
                return null;
            }
            ++i;
        }
        return this.getCommonClass(testList);
    }
}

