/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchWindow;

public class PartSite
implements IWorkbenchPartSite {
    private IWorkbenchPart part;
    private IWorkbenchPage page;
    private PartPane pane;
    private IConfigurationElement configElement;
    private String extensionID;
    private String pluginID;
    private String extensionName;
    private ISelectionProvider selectionProvider;
    private SubActionBars actionBars;
    private KeyBindingService keyBindingService;

    public PartSite(IWorkbenchPart part, IWorkbenchPage page) {
        this.part = part;
        this.page = page;
        this.extensionID = "org.eclipse.ui.UnknownID";
        this.extensionName = "Unknown Name";
    }

    public void dispose() {
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getId() {
        return this.extensionID;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public PartPane getPane() {
        return this.pane;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public String getPluginId() {
        return this.pluginID;
    }

    public String getRegisteredName() {
        return this.extensionName;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.page.getWorkbenchWindow().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.page.getWorkbenchWindow();
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        new PopupMenuExtender(menuID, menuMgr, selProvider, this.part);
    }

    public void registerContextMenu(MenuManager menuMgr, ISelectionProvider selProvider) {
        this.registerContextMenu(this.getId(), menuMgr, selProvider);
    }

    public void setActionBars(SubActionBars bars) {
        this.actionBars = bars;
    }

    public void setConfigurationElement(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.extensionID = configElement.getAttribute("id");
        IPluginDescriptor pd = configElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        this.pluginID = pd.getUniqueIdentifier();
        String name = configElement.getAttribute("name");
        if (name != null) {
            this.extensionName = name;
        }
    }

    public void setPane(PartPane pane) {
        this.pane = pane;
    }

    public void setPart(IWorkbenchPart newPart) {
        this.part = newPart;
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            this.keyBindingService = new KeyBindingService(((WorkbenchWindow)this.getWorkbenchWindow()).getKeyBindingService(), this);
            this.keyBindingService.setActiveAcceleratorScopeId(this.getInitialScopeId());
        }
        return this.keyBindingService;
    }

    protected String getInitialScopeId() {
        return "org.eclipse.ui.globalScope";
    }
}

