/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActiveEditorAction;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PinEditorAction
extends ActiveEditorAction {
    private IWorkbenchWindow window;
    private boolean visible = false;

    protected PinEditorAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("PinEditorAction.text"), window);
        this.setToolTipText(WorkbenchMessages.getString("PinEditorAction.toolTip"));
        this.setId("org.eclipse.ui.internal.PinEditorAction");
        this.window = window;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void run() {
        IEditorPart editor = this.getActiveEditor();
        ((EditorSite)editor.getEditorSite()).setReuseEditor(!this.isChecked());
    }

    protected void updateState() {
        if (this.window == null) {
            this.setChecked(false);
            this.setEnabled(false);
            return;
        }
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            this.setChecked(false);
            this.setEnabled(false);
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        boolean enabled = editor != null;
        this.setEnabled(enabled);
        if (enabled) {
            EditorSite site = (EditorSite)editor.getEditorSite();
            EditorPane pane = (EditorPane)site.getPane();
            pane.setPinEditorAction(this);
            this.setChecked(!site.getReuseEditor());
        } else {
            this.setChecked(false);
        }
    }
}

