/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.fonts.FontDefinition;

public class PlatformUIPreferenceListener
implements IPropertyChangeListener {
    private Set defaultCheckNames;
    private Set fontNames;

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if ("ENABLED_DECORATORS".equals(propertyName)) {
            WorkbenchPlugin.getDefault().getDecoratorManager().restoreListeners();
        }
        if ("defaultPerspectiveId".equals(propertyName)) {
            IWorkbench workbench = WorkbenchPlugin.getDefault().getWorkbench();
            workbench.getPerspectiveRegistry().setDefaultPerspective((String)event.getNewValue());
        }
        if (this.defaultCheckNames == null) {
            this.initializeFontNames();
        }
        if (this.defaultCheckNames.contains(propertyName)) {
            this.processDefaultsTo(propertyName);
        }
        if (this.fontNames.contains(propertyName)) {
            Object newValue = event.getNewValue();
            FontData[] newSetting = newValue instanceof String ? PreferenceConverter.readFontData((String)((String)newValue)) : (FontData[])newValue;
            JFaceResources.getFontRegistry().put(propertyName, newSetting);
        }
    }

    private void processDefaultsTo(String propertyName) {
        FontDefinition[] definitions = FontDefinition.getDefinitions();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < definitions.length) {
            String defaultsTo = definitions[i].getDefaultsTo();
            if (defaultsTo != null && defaultsTo.equals(propertyName) && store.isDefault(definitions[i].getId())) {
                FontData[] data = PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)defaultsTo);
                JFaceResources.getFontRegistry().put(definitions[i].getId(), data);
            }
            ++i;
        }
    }

    private void initializeFontNames() {
        this.defaultCheckNames = new HashSet();
        this.fontNames = new HashSet();
        FontDefinition[] definitions = FontDefinition.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            this.fontNames.add(definitions[i].getId());
            String defaultsTo = definitions[i].getDefaultsTo();
            if (defaultsTo != null) {
                this.defaultCheckNames.add(defaultsTo);
            }
            ++i;
        }
    }
}

