/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.WelcomePageSelectionDialog;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WelcomeEditorInput;

public class QuickStartAction
extends PartEventAction {
    private static final String EDITOR_ID = "org.eclipse.ui.internal.dialogs.WelcomeEditor";
    private IWorkbench workbench;

    public QuickStartAction() {
        this(PlatformUI.getWorkbench());
    }

    public QuickStartAction(IWorkbench aWorkbench) {
        super(WorkbenchMessages.getString("QuickStart.text"));
        this.setToolTipText(WorkbenchMessages.getString("QuickStart.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.quick_start_action_context");
        this.workbench = aWorkbench;
    }

    public void run() {
        WelcomePageSelectionDialog d;
        AboutInfo[] features = ((Workbench)this.workbench).getConfigurationInfo().getFeaturesInfo();
        ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
        int i = 0;
        while (i < features.length) {
            if (features[i].getWelcomePageURL() != null) {
                welcomeFeatures.add(features[i]);
            }
            ++i;
        }
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (welcomeFeatures.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)WorkbenchMessages.getString("QuickStartMessageDialog.title"), (String)WorkbenchMessages.getString("QuickStartMessageDialog.message"));
            return;
        }
        features = new AboutInfo[welcomeFeatures.size()];
        welcomeFeatures.toArray(features);
        Arrays.sort(features, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                AboutInfo i1 = (AboutInfo)a;
                String name1 = i1.getFeatureLabel();
                AboutInfo i2 = (AboutInfo)b;
                String name2 = i2.getFeatureLabel();
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                return this.coll.compare(name1, name2);
            }
        });
        AboutInfo primaryFeature = ((Workbench)this.workbench).getConfigurationInfo().getAboutInfo();
        int index = -1;
        if (primaryFeature != null) {
            int i2 = 0;
            while (i2 < features.length) {
                if (features[i2].getFeatureId().equals(primaryFeature.getFeatureId())) {
                    index = i2;
                    break;
                }
                ++i2;
            }
        }
        if ((d = new WelcomePageSelectionDialog(shell, features, index)).open() != 0 || d.getResult().length != 1) {
            return;
        }
        AboutInfo feature = (AboutInfo)d.getResult()[0];
        IWorkbenchPage page = null;
        String perspectiveId = feature.getWelcomePerspective();
        if (perspectiveId == null && ((page = window.getActivePage()) == null || page.getPerspective() == null)) {
            perspectiveId = WorkbenchPlugin.getDefault().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (perspectiveId != null) {
            try {
                page = (WorkbenchPage)this.workbench.showPerspective(perspectiveId, window);
            }
            catch (WorkbenchException workbenchException) {
                return;
            }
        }
        page.setEditorAreaVisible(true);
        WelcomeEditorInput input = new WelcomeEditorInput(feature);
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.activate(editor);
            return;
        }
        try {
            page.openEditor(input, EDITOR_ID);
        }
        catch (PartInitException e) {
            Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, WorkbenchMessages.getString("QuickStartAction.openEditorException"), (Throwable)((Object)e));
            ErrorDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)WorkbenchMessages.getString("QuickStartAction.errorDialogTitle"), (String)WorkbenchMessages.getString("QuickStartAction.errorDialogMessage"), (IStatus)status);
        }
    }
}

