/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ActionPresentation;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.IPerspectiveService;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PartDropEvent;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PerspectiveListenerListOld;
import org.eclipse.ui.internal.PerspectivePresentation;
import org.eclipse.ui.internal.SetPagePerspectiveAction;
import org.eclipse.ui.internal.ShortcutBarPart;
import org.eclipse.ui.internal.ShortcutBarPartDragDrop;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WWinKeyBindingService;
import org.eclipse.ui.internal.WWinPartService;
import org.eclipse.ui.internal.WWinPerspectiveService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchActionBuilder;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.KeyManager;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.IActionSet;

public class WorkbenchWindow
extends ApplicationWindow
implements IWorkbenchWindow {
    private int number;
    private Workbench workbench;
    private PageList pageList = new PageList();
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerListOld perspectiveListeners = new PerspectiveListenerListOld();
    private IPartDropListener partDropListener;
    private WWinPerspectiveService perspectiveService = new WWinPerspectiveService(this);
    private WWinKeyBindingService keyBindingService;
    private WWinPartService partService = new WWinPartService(this);
    private IMemento deferredRestoreState;
    private ActionPresentation actionPresentation;
    private WWinActionBars actionBars;
    private Label separator2;
    private Label separator3;
    private ToolBarManager shortcutBar;
    private ShortcutBarPart shortcutBarPart;
    private ShortcutBarPartDragDrop shortcutDND;
    private WorkbenchActionBuilder actionBuilder;
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    private String workspaceLocation;
    private Menu perspectiveBarMenu;
    private Menu fastViewBarMenu;
    private MenuItem restoreItem;
    private CoolBarManager coolBarManager = new CoolBarManager();
    private Label noOpenPerspective;
    private boolean showShortcutBar = true;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    static /* synthetic */ Class class$0;

    public WorkbenchWindow(Workbench workbench, int number) {
        super(null);
        this.workbench = workbench;
        this.number = number;
        this.addMenuBar();
        this.addToolBar(0x800000);
        this.addStatusLine();
        this.addShortcutBar(8389184);
        this.updateBarVisibility();
        this.actionPresentation = new ActionPresentation(this);
        this.actionBuilder = ((Workbench)this.getWorkbench()).createActionBuilder(this);
        this.actionBuilder.buildActions();
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-showlocation".equalsIgnoreCase(args[i])) {
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.partDropListener = new IPartDropListener(){

            public void dragOver(PartDropEvent e) {
                WorkbenchPage page = WorkbenchWindow.this.getActiveWorkbenchPage();
                Perspective persp = page.getActivePerspective();
                PerspectivePresentation presentation = persp.getPresentation();
                presentation.onPartDragOver(e);
            }

            public void drop(PartDropEvent e) {
                WorkbenchPage page = WorkbenchWindow.this.getActiveWorkbenchPage();
                Perspective persp = page.getActivePerspective();
                PerspectivePresentation presentation = persp.getPresentation();
                presentation.onPartDrop(e);
            }
        };
    }

    public void addPageListener(IPageListener l) {
        this.pageListeners.addPageListener(l);
    }

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    void addPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        SetPagePerspectiveAction action = new SetPagePerspectiveAction(perspective, page);
        this.shortcutBar.appendToGroup(GRP_PERSPECTIVES, (IAction)action);
        this.shortcutBar.update(false);
    }

    protected void addShortcutBar(int style) {
        if (this.getShell() == null && this.shortcutBar == null) {
            this.shortcutBar = new ToolBarManager(style);
        }
    }

    protected void addToolBar(int style) {
        if (this.getShell() == null) {
            this.coolBarManager = new CoolBarManager(style);
        }
    }

    private boolean busyClose() {
        this.closing = true;
        this.updateDisabled = true;
        int count = this.workbench.getWorkbenchWindowCount();
        if (count <= 1 && !this.workbench.isClosing()) {
            return this.workbench.close();
        }
        if (!this.okToClose()) {
            return false;
        }
        return this.hardClose();
    }

    protected IWorkbenchPage busyOpenPage(String perspID, IAdaptable input) throws WorkbenchException {
        IWorkbenchPage newPage = null;
        if (this.pageList.isEmpty()) {
            newPage = new WorkbenchPage(this, perspID, input);
            this.pageList.add(newPage);
            this.firePageOpened(newPage);
            this.setActivePage(newPage);
        } else {
            IWorkbenchWindow window = this.getWorkbench().openWorkbenchWindow(perspID, input);
            newPage = window.getActivePage();
        }
        return newPage;
    }

    public int open() {
        int r = super.open();
        this.workbench.fireWindowOpened(this);
        return r;
    }

    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = WorkbenchWindow.this.busyClose();
            }
        });
        return ret[0];
    }

    protected boolean isClosing() {
        return this.closing || this.workbench.isClosing();
    }

    protected boolean isToolBarLocked() {
        return this.getCoolBarManager().isLayoutLocked();
    }

    private void closeAllPages() {
        this.setActivePage(null);
        PageList oldList = this.pageList;
        this.pageList = new PageList();
        Iterator iterator = oldList.iterator();
        while (iterator.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            this.firePageClosed(page);
            page.dispose();
        }
        if (!this.closing) {
            this.showEmptyWindowMessage();
        }
    }

    public void closeAllPages(boolean save) {
        boolean ret;
        if (save && !(ret = this.saveAllPages(true))) {
            return;
        }
        this.closeAllPages();
    }

    protected boolean closePage(IWorkbenchPage in, boolean save) {
        WorkbenchPage newPage;
        boolean oldIsActive;
        if (!this.pageList.contains(in)) {
            return false;
        }
        WorkbenchPage oldPage = (WorkbenchPage)in;
        if (save && oldPage.isSaveNeeded() && !oldPage.saveAllEditors(true)) {
            return false;
        }
        boolean bl = oldIsActive = oldPage == this.getActiveWorkbenchPage();
        if (oldIsActive) {
            this.setActivePage(null);
        }
        this.pageList.remove(oldPage);
        this.firePageClosed(oldPage);
        oldPage.dispose();
        if (oldIsActive && (newPage = this.pageList.getNextActive()) != null) {
            this.setActivePage(newPage);
        }
        if (!this.closing && this.pageList.isEmpty()) {
            this.showEmptyWindowMessage();
        }
        return true;
    }

    private void showEmptyWindowMessage() {
        Composite parent = this.getClientComposite();
        if (this.noOpenPerspective == null) {
            this.noOpenPerspective = new Label(parent, 0);
            this.noOpenPerspective.setText(WorkbenchMessages.getString("WorkbenchWindow.noPerspective"));
            this.noOpenPerspective.setBounds(parent.getClientArea());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setLayout(this.getLayout());
        shell.setSize(800, 600);
        this.separator2 = new Label((Composite)shell, 258);
        this.createShortcutBar(shell);
        this.separator3 = new Label((Composite)shell, 514);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.workbench_window_context");
        this.trackShellActivation(shell);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null && event.type == 3) {
                    Point pt;
                    ToolBar toolBar;
                    if (event.widget instanceof ToolBar && (toolBar = (ToolBar)event.widget).getItem(pt = new Point(event.x, event.y)) != null) {
                        return;
                    }
                    currentPage.toggleFastView(null);
                }
            }
        };
        this.getToolBarControl().addListener(3, listener);
        Control[] children = ((Composite)this.getStatusLineManager().getControl()).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] != null) {
                children[i].addListener(3, listener);
            }
            ++i;
        }
        this.getShortcutBar().getControl().addListener(3, listener);
    }

    private void createShortcutBar(Shell shell) {
        if (this.shortcutBar == null) {
            return;
        }
        this.shortcutBar.createControl((Composite)shell);
        this.shortcutBarPart = new ShortcutBarPart(this.shortcutBar);
        this.enableDragShortcutBarPart();
        ToolBar tb = this.shortcutBar.getControl();
        tb.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    WorkbenchWindow.this.showShortcutBarPopup(e);
                }
            }
        });
    }

    protected Control createToolBarControl(Shell shell) {
        CoolBarManager manager = this.getCoolBarManager();
        return manager.createControl((Composite)shell);
    }

    protected ToolBarManager createToolBarManager(int style) {
        return null;
    }

    protected MenuManager createMenuManager() {
        final MenuManager result = super.createMenuManager();
        result.setOverrides(new IContributionManagerOverrides(){

            public Integer getAccelerator(IContributionItem item) {
                if (!(item instanceof ActionContributionItem)) {
                    return null;
                }
                ActionContributionItem aci = (ActionContributionItem)item;
                String defId = aci.getAction().getActionDefinitionId();
                if (defId == null) {
                    int accelerator = aci.getAction().getAccelerator();
                    if (accelerator != 0) {
                        KeySequence keySequence = KeySequence.create(KeyStroke.create(accelerator));
                        KeyManager keyManager = KeyManager.getInstance();
                        Map keySequenceMapForMode = keyManager.getKeyMachine().getKeySequenceMapForMode();
                        if (keySequenceMapForMode.get(keySequence) == null) {
                            return null;
                        }
                    }
                    return new Integer(0);
                }
                return new Integer(0);
            }

            public String getAcceleratorText(IContributionItem item) {
                if (!(item instanceof ActionContributionItem)) {
                    return null;
                }
                ActionContributionItem aci = (ActionContributionItem)item;
                String defId = aci.getAction().getActionDefinitionId();
                if (defId == null) {
                    int accelerator = aci.getAction().getAccelerator();
                    if (accelerator != 0) {
                        KeySequence keySequence = KeySequence.create(KeyStroke.create(accelerator));
                        KeyManager keyManager = KeyManager.getInstance();
                        Map keySequenceMapForMode = keyManager.getKeyMachine().getKeySequenceMapForMode();
                        if (keySequenceMapForMode.get(keySequence) == null) {
                            return null;
                        }
                    }
                    return "";
                }
                String acceleratorText = KeyManager.getInstance().getTextForAction(defId);
                if (acceleratorText != null && "carbon".equals(SWT.getPlatform())) {
                    acceleratorText = this.replaceSubstring(acceleratorText, "Alt", "\u2325");
                    acceleratorText = this.replaceSubstring(acceleratorText, "Command", "\u2318");
                    acceleratorText = this.replaceSubstring(acceleratorText, "Ctrl", "\u2303");
                    acceleratorText = this.replaceSubstring(acceleratorText, "Shift", "\u21e7");
                    acceleratorText = "   " + this.replaceSubstring(acceleratorText, "+", "");
                }
                return acceleratorText != null ? acceleratorText : "";
            }

            private String replaceSubstring(String str, String pattern, String replace) {
                int slen = str.length();
                int plen = pattern.length();
                int s = 0;
                int e = 0;
                StringBuffer result2 = new StringBuffer(slen * 2);
                char[] chars = new char[slen];
                while ((e = str.indexOf(pattern, s)) >= 0) {
                    str.getChars(s, e, chars, 0);
                    result2.append(chars, 0, e - s).append(replace);
                    s = e + plen;
                }
                str.getChars(s, slen, chars, 0);
                result2.append(chars, 0, slen - s);
                return result2.toString();
            }

            public String getText(IContributionItem item) {
                String text;
                int index;
                if (!(item instanceof MenuManager)) {
                    return null;
                }
                MenuManager itemManager = (MenuManager)item;
                IContributionManager parent = itemManager.getParent();
                if (parent != result) {
                    if (parent instanceof SubMenuManager) {
                        if ((parent = ((SubMenuManager)parent).getParent()) != result) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if ((index = (text = itemManager.getMenuText()).indexOf(38)) < 0 || index == text.length() - 1) {
                    return text;
                }
                char altChar = Character.toUpperCase(text.charAt(index + 1));
                String defId = WorkbenchWindow.this.keyBindingService.getDefinitionId(0x10000 | altChar);
                if (defId == null) {
                    return text;
                }
                if (index == 0) {
                    return text.substring(1);
                }
                return String.valueOf(text.substring(0, index)) + text.substring(index + 1);
            }

            public Boolean getEnabled(IContributionItem item) {
                return null;
            }
        });
        return result;
    }

    void enableDragShortcutBarPart() {
        Control control = this.shortcutBarPart.getControl();
        if (control != null && this.shortcutDND == null) {
            this.shortcutDND = new ShortcutBarPartDragDrop(this.shortcutBarPart, control);
            this.shortcutDND.addDropListener(this.partDropListener);
        }
    }

    IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        IContributionItem[] array = this.shortcutBar.getItems();
        int length = array.length;
        int i = 0;
        while (i < length) {
            SetPagePerspectiveAction sp;
            IAction action;
            IContributionItem item = array[i];
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof SetPagePerspectiveAction && (sp = (SetPagePerspectiveAction)action).handles(perspective, page)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void firePageActivated(IWorkbenchPage page) {
        this.pageListeners.firePageActivated(page);
        this.partService.pageActivated(page);
    }

    private void firePageClosed(IWorkbenchPage page) {
        this.pageListeners.firePageClosed(page);
        this.partService.pageClosed(page);
    }

    private void firePageOpened(IWorkbenchPage page) {
        this.pageListeners.firePageOpened(page);
        this.partService.pageOpened(page);
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
        this.perspectiveService.firePerspectiveActivated(page, perspective);
    }

    void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        this.perspectiveService.firePerspectiveChanged(page, perspective, changeId);
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveService.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveService.firePerspectiveOpened(page, perspective);
    }

    public IActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    public IWorkbenchPage getActivePage() {
        return this.pageList.getActive();
    }

    WorkbenchPage getActiveWorkbenchPage() {
        return this.pageList.getActive();
    }

    protected CoolBar getCoolBarControl() {
        return this.getCoolBarManager().getControl();
    }

    public CoolBarManager getCoolBarManager() {
        return this.coolBarManager;
    }

    protected Composite getClientComposite() {
        return (Composite)this.getContents();
    }

    public MenuManager getMenuManager() {
        return this.getMenuBarManager();
    }

    public int getNumber() {
        return this.number;
    }

    public IWorkbenchPage[] getPages() {
        return this.pageList.getPages();
    }

    public IPartService getPartService() {
        return this.partService;
    }

    public WWinKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            this.keyBindingService = new WWinKeyBindingService(this);
            this.updateActiveActions();
        }
        return this.keyBindingService;
    }

    private void updateActiveActions() {
        if (this.keyBindingService == null) {
            this.getKeyBindingService();
        } else {
            IActionSet[] sets = this.actionPresentation.getActionSets();
            this.keyBindingService.registerActionSets(sets);
        }
    }

    protected Layout getLayout() {
        return new WorkbenchWindowLayout();
    }

    public IPerspectiveService getPerspectiveService() {
        return this.perspectiveService;
    }

    protected Label getSeparator2() {
        return this.separator2;
    }

    protected Label getSeparator3() {
        return this.separator3;
    }

    public ISelectionService getSelectionService() {
        return this.partService.getSelectionService();
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public ToolBarManager getShortcutBar() {
        return this.shortcutBar;
    }

    ShortcutBarPartDragDrop getShortcutDND() {
        return this.shortcutDND;
    }

    public boolean getShowShortcutBar() {
        return this.showShortcutBar;
    }

    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    public boolean getShowToolBar() {
        return this.showToolBar;
    }

    protected StatusLineManager getStatusLineManager() {
        return super.getStatusLineManager();
    }

    protected Control getToolBarControl() {
        return this.getCoolBarControl();
    }

    public ToolBarManager getToolBarManager() {
        return null;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    private boolean hardClose() {
        try {
            this.closing = true;
            this.updateDisabled = true;
            this.actionPresentation.clearActionSets();
            this.closeAllPages();
            this.actionBuilder.dispose();
            if (this.keyBindingService != null) {
                this.keyBindingService.dispose();
            }
            this.workbench.fireWindowClosed(this);
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public boolean isApplicationMenu(String menuID) {
        return this.actionBuilder.isContainerMenu(menuID);
    }

    void lockToolBar(boolean lock) {
        this.getCoolBarManager().lockLayout(lock);
    }

    public boolean okToClose() {
        return this.workbench.isClosing() || this.saveAllPages(true);
    }

    public IWorkbenchPage openPage(final String perspId, final IAdaptable input) throws WorkbenchException {
        Assert.isNotNull(perspId);
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchWindow.this.busyOpenPage(perspId, input);
                }
                catch (WorkbenchException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchWindow.exceptionMessage"));
    }

    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        String perspId = this.workbench.getPerspectiveRegistry().getDefaultPerspective();
        return this.openPage(perspId, input);
    }

    public void removePageListener(IPageListener l) {
        this.pageListeners.removePageListener(l);
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    void removePerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            this.shortcutBar.remove(item);
            this.shortcutBar.update(false);
        }
    }

    private IStatus unableToRestorePage(IMemento pageMem) {
        String pageName = pageMem.getString("label");
        if (pageName == null) {
            pageName = "";
        }
        return new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.format("WorkbenchWindow.unableToRestorePerspective", new String[]{pageName}), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus restoreState(IMemento memento, IPerspectiveDescriptor activeDescriptor) {
        Assert.isNotNull(this.getShell());
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("WorkbenchWindow.problemsRestoringWindow"), null);
        if ("true".equals(memento.getString("maximized"))) {
            this.getShell().setMaximized(true);
        } else if (!"true".equals(memento.getString("minimized"))) {
            Integer bigInt = memento.getInteger("x");
            int x = bigInt;
            bigInt = memento.getInteger("y");
            int y = bigInt;
            bigInt = memento.getInteger("width");
            int width = bigInt;
            bigInt = memento.getInteger("height");
            int height = bigInt;
            this.getShell().setBounds(x, y, width, height);
        }
        Integer locked = memento.getInteger("toolbarLayout");
        boolean state = locked != null && locked == 1;
        this.lockToolBar(state);
        IWorkbenchPage newActivePage = null;
        IMemento[] pageArray = memento.getChildren("page");
        int i = 0;
        while (i < pageArray.length) {
            block18: {
                IMemento pageMem = pageArray[i];
                IMemento inputMem = pageMem.getChild("input");
                String factoryID = inputMem.getString("factoryID");
                if (factoryID == null) {
                    WorkbenchPlugin.log("Unable to restore page - no input factory ID.");
                    result.add(this.unableToRestorePage(pageMem));
                } else {
                    IAdaptable input;
                    Object var14_19;
                    block19: {
                        try {
                            UIStats.start(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                            IElementFactory factory = WorkbenchPlugin.getDefault().getElementFactory(factoryID);
                            if (factory == null) {
                                WorkbenchPlugin.log("Unable to restore pagee - cannot instantiate input factory: " + factoryID);
                                result.add(this.unableToRestorePage(pageMem));
                                var14_19 = null;
                                UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                                break block18;
                            }
                            input = factory.createElement(inputMem);
                            if (input != null) break block19;
                            WorkbenchPlugin.log("Unable to restore page - cannot instantiate input element: " + factoryID);
                            result.add(this.unableToRestorePage(pageMem));
                            var14_19 = null;
                            UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                            break block18;
                        }
                        catch (Throwable throwable) {
                            var14_19 = null;
                            UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                            throw throwable;
                        }
                    }
                    var14_19 = null;
                    UIStats.end(UIStats.RESTORE_WORKBENCH, "WorkbenchPageFactory");
                    WorkbenchPage newPage = null;
                    try {
                        newPage = new WorkbenchPage(this, input);
                        result.add(newPage.restoreState(pageMem, activeDescriptor));
                        this.pageList.add(newPage);
                        this.firePageOpened(newPage);
                    }
                    catch (WorkbenchException e) {
                        WorkbenchPlugin.log("Unable to restore perspective - constructor failed.");
                        result.add(e.getStatus());
                        break block18;
                    }
                    String strFocus = pageMem.getString("focus");
                    if (strFocus != null && strFocus.length() > 0) {
                        newActivePage = newPage;
                    }
                }
            }
            ++i;
        }
        if (this.pageList.isEmpty()) {
            try {
                IWorkspaceRoot root = WorkbenchPlugin.getPluginWorkspace().getRoot();
                String defPerspID = this.workbench.getPerspectiveRegistry().getDefaultPerspective();
                WorkbenchPage newPage = new WorkbenchPage(this, defPerspID, (IAdaptable)root);
                this.pageList.add(newPage);
                this.firePageOpened(newPage);
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Unable to create default perspective - constructor failed.");
                result.add(e.getStatus());
                String productName = this.workbench.getConfigurationInfo().getAboutInfo().getProductName();
                if (productName == null) {
                    productName = "";
                }
                this.getShell().setText(productName);
            }
        }
        if (newActivePage == null) {
            newActivePage = this.pageList.getNextActive();
        }
        this.setActivePage(newActivePage);
        IWorkbenchPart part = newActivePage.getActivePart();
        if (part != null) {
            this.getKeyBindingService().update(part, true);
        }
        return result;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block6: {
            ToolBarManager shortcutBar = this.getShortcutBar();
            ToolBar shortcutBarControl = null;
            if (shortcutBar != null) {
                shortcutBarControl = shortcutBar.getControl();
            }
            boolean shortcutbarWasEnabled = false;
            if (shortcutBarControl != null) {
                shortcutbarWasEnabled = shortcutBarControl.isEnabled();
            }
            try {
                if (shortcutBarControl != null && !shortcutBarControl.isDisposed()) {
                    shortcutBarControl.setEnabled(false);
                }
                super.run(fork, cancelable, runnable);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (shortcutBarControl != null && !shortcutBarControl.isDisposed()) {
                    shortcutBarControl.setEnabled(shortcutbarWasEnabled);
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (shortcutBarControl == null || shortcutBarControl.isDisposed()) break block6;
            shortcutBarControl.setEnabled(shortcutbarWasEnabled);
        }
    }

    private boolean saveAllPages(boolean bConfirm) {
        boolean bRet = true;
        Iterator iterator = this.pageList.iterator();
        while (bRet && iterator.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            bRet = page.saveAllEditors(bConfirm);
        }
        return bRet;
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("WorkbenchWindow.problemsSavingWindow"), null);
        if (this.getShell().getMaximized()) {
            memento.putString("maximized", "true");
        } else if (this.getShell().getMinimized()) {
            memento.putString("minimized", "true");
        } else {
            Rectangle bounds = this.getShell().getBounds();
            memento.putInteger("x", bounds.x);
            memento.putInteger("y", bounds.y);
            memento.putInteger("width", bounds.width);
            memento.putInteger("height", bounds.height);
        }
        int state = this.isToolBarLocked() ? 1 : 0;
        memento.putInteger("toolbarLayout", state);
        Iterator iterator = this.pageList.iterator();
        while (iterator.hasNext()) {
            IPersistableElement persistable;
            WorkbenchPage page = (WorkbenchPage)iterator.next();
            IAdaptable input = page.getInput();
            if (input == null) {
                WorkbenchPlugin.log("Unable to save page input: " + page);
                continue;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((persistable = (IPersistableElement)input.getAdapter((Class)clazz)) == null) {
                WorkbenchPlugin.log("Unable to save page input: " + input);
                continue;
            }
            IMemento pageMem = memento.createChild("page");
            pageMem.putString("label", page.getLabel());
            result.add(page.saveState(pageMem));
            if (page == this.getActiveWorkbenchPage()) {
                pageMem.putString("focus", "true");
            }
            IMemento inputMem = pageMem.createChild("input");
            inputMem.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(inputMem);
        }
        return result;
    }

    void selectPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page, boolean selected) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            IAction action = ((ActionContributionItem)item).getAction();
            action.setChecked(selected);
        }
    }

    public void setActivePage(final IWorkbenchPage in) {
        if (this.getActiveWorkbenchPage() == in) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                WorkbenchPage newPage;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    currentPage.onDeactivate();
                }
                if (in == null || WorkbenchWindow.this.pageList.contains(in)) {
                    WorkbenchWindow.this.pageList.setActive(in);
                }
                if ((newPage = WorkbenchWindow.this.pageList.getActive()) != null) {
                    newPage.onActivate();
                    WorkbenchWindow.this.firePageActivated(newPage);
                    if (newPage.getPerspective() != null) {
                        WorkbenchWindow.this.firePerspectiveActivated(newPage, newPage.getPerspective());
                    }
                }
                if (WorkbenchWindow.this.isClosing()) {
                    return;
                }
                WorkbenchWindow.this.updateDisabled = false;
                WorkbenchWindow.this.updateTitle();
                WorkbenchWindow.this.updateActionSets();
                WorkbenchWindow.this.shortcutBar.update(false);
                if (newPage != null && newPage.getPerspective() != null) {
                    newPage.setToolBarLayout();
                }
                WorkbenchWindow.this.getMenuManager().update("text");
                if (WorkbenchWindow.this.noOpenPerspective != null && in != null) {
                    WorkbenchWindow.this.noOpenPerspective.dispose();
                    WorkbenchWindow.this.noOpenPerspective = null;
                }
            }
        });
    }

    public void setShowShortcutBar(boolean show) {
        this.showShortcutBar = show;
    }

    public void setShowStatusLine(boolean show) {
        this.showStatusLine = show;
    }

    public void setShowToolBar(boolean show) {
        this.showToolBar = show;
    }

    private void showShortcutBarPopup(MouseEvent e) {
        Point pt = new Point(e.x, e.y);
        ToolBar toolBar = this.shortcutBar.getControl();
        ToolItem toolItem = toolBar.getItem(pt);
        if (toolItem == null) {
            return;
        }
        Object data = toolItem.getData();
        if (data instanceof ShowFastViewContribution) {
            if (this.fastViewBarMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                MenuItem closeItem = new MenuItem(menu, 0);
                closeItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
                closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.fastViewBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            IViewReference ref = (IViewReference)toolItem.getData("FastView");
                            WorkbenchWindow.this.getActiveWorkbenchPage().hideView(ref);
                        }
                    }
                });
                this.restoreItem = new MenuItem(menu, 32);
                this.restoreItem.setText(WorkbenchMessages.getString("WorkbenchWindow.restore"));
                this.restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.fastViewBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            IViewReference ref = (IViewReference)toolItem.getData("FastView");
                            WorkbenchWindow.this.getActiveWorkbenchPage().removeFastView(ref);
                        }
                    }
                });
                this.fastViewBarMenu = menu;
            }
            this.restoreItem.setSelection(true);
            this.fastViewBarMenu.setData((Object)toolItem);
            if (this.fastViewBarMenu != null) {
                pt = toolBar.toDisplay(pt);
                this.fastViewBarMenu.setLocation(pt.x, pt.y);
                this.fastViewBarMenu.setVisible(true);
            }
        }
        if (!(data instanceof ActionContributionItem)) {
            return;
        }
        IAction action = ((ActionContributionItem)data).getAction();
        if (action instanceof SetPagePerspectiveAction) {
            if (this.perspectiveBarMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.perspectiveBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            ActionContributionItem item = (ActionContributionItem)toolItem.getData();
                            SetPagePerspectiveAction action = (SetPagePerspectiveAction)item.getAction();
                            action.getPage().closePerspective(action.getPerspective(), true);
                        }
                    }
                });
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.closeAll"));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ToolItem toolItem = (ToolItem)WorkbenchWindow.this.perspectiveBarMenu.getData();
                        if (toolItem != null && !toolItem.isDisposed()) {
                            ActionContributionItem item = (ActionContributionItem)toolItem.getData();
                            SetPagePerspectiveAction action = (SetPagePerspectiveAction)item.getAction();
                            action.getPage().closeAllPerspectives(true);
                        }
                    }
                });
                this.perspectiveBarMenu = menu;
            }
            this.perspectiveBarMenu.setData((Object)toolItem);
            if (this.perspectiveBarMenu != null) {
                pt = toolBar.toDisplay(pt);
                this.perspectiveBarMenu.setLocation(pt.x, pt.y);
                this.perspectiveBarMenu.setVisible(true);
            }
        }
    }

    protected boolean toolBarChildrenExist() {
        CoolBar coolBarControl = this.getCoolBarControl();
        return coolBarControl.getItemCount() > 0;
    }

    private void trackShellActivation(Shell shell) {
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IEditorPart editor;
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellActivated();
                    }
                    if ((editor = currentPage.getActiveEditor()) != null) {
                        PartSite site = (PartSite)editor.getSite();
                        site.getPane().shellActivated();
                    }
                    WorkbenchWindow.this.workbench.fireWindowActivated(WorkbenchWindow.this);
                }
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IEditorPart editor;
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellDeactivated();
                    }
                    if ((editor = currentPage.getActiveEditor()) != null) {
                        PartSite site = (PartSite)editor.getSite();
                        site.getPane().shellDeactivated();
                    }
                    WorkbenchWindow.this.workbench.fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled) {
            return;
        }
        this.getMenuBarManager().updateAll(false);
        this.getCoolBarManager().update(false);
        this.getStatusLineManager().update(false);
    }

    public void updateActionSets() {
        if (this.updateDisabled) {
            return;
        }
        WorkbenchPage currentPage = this.getActiveWorkbenchPage();
        if (currentPage == null) {
            this.actionPresentation.clearActionSets();
        } else {
            this.actionPresentation.setActionSets(currentPage.getActionSets());
        }
        this.updateActionBars();
        String path = "window/launch";
        IMenuManager manager = this.getMenuBarManager().findMenuUsingPath(path);
        IContributionItem item = this.getMenuBarManager().findUsingPath(path);
        this.updateActiveActions();
        if (manager == null || item == null) {
            return;
        }
        item.setVisible(manager.getItems().length >= 2);
    }

    void updatePerspectiveShortcut(IPerspectiveDescriptor oldDesc, IPerspectiveDescriptor newDesc, WorkbenchPage page) {
        if (this.updateDisabled) {
            return;
        }
        IContributionItem item = this.findPerspectiveShortcut(oldDesc, page);
        if (item != null) {
            SetPagePerspectiveAction action = (SetPagePerspectiveAction)((ActionContributionItem)item).getAction();
            action.update(newDesc);
            if (page == this.getActiveWorkbenchPage()) {
                this.updateTitle();
            }
        }
    }

    public void updateBarVisibility() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.setShowShortcutBar(store.getBoolean("SHOW_SHORTCUT_BAR"));
        this.setShowStatusLine(store.getBoolean("SHOW_STATUS_LINE"));
        this.setShowToolBar(store.getBoolean("SHOW_TOOL_BAR"));
    }

    public void updateTitle() {
        WorkbenchPage currentPage;
        if (this.updateDisabled) {
            return;
        }
        String title = this.workbench.getConfigurationInfo().getAboutInfo().getProductName();
        if (title == null) {
            title = "";
        }
        if (this.workspaceLocation != null) {
            title = WorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{title, this.workspaceLocation});
        }
        if ((currentPage = this.getActiveWorkbenchPage()) != null) {
            IAdaptable input;
            IPerspectiveDescriptor persp = currentPage.getPerspective();
            String label = "";
            if (persp != null) {
                label = persp.getLabel();
            }
            if ((input = currentPage.getInput()) != null && !input.equals(ResourcesPlugin.getWorkspace().getRoot())) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = WorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{label, title});
            }
        }
        this.getShell().setText(title);
    }

    class WorkbenchWindowLayout
    extends Layout {
        WorkbenchWindowLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = new Point(0, 0);
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                boolean skip = false;
                if (w == WorkbenchWindow.this.getToolBarControl()) {
                    skip = true;
                    result.y += 23;
                } else if (WorkbenchWindow.this.getShortcutBar() != null && w == WorkbenchWindow.this.getShortcutBar().getControl()) {
                    skip = true;
                }
                if (!skip) {
                    Point e = w.computeSize(wHint, hHint, flushCache);
                    result.x = Math.max(result.x, e.x);
                    result.y += e.y + 0;
                }
                ++i;
            }
            result.x += 23;
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Point e;
                Control w = ws[i];
                if (i == 0) {
                    Point e2 = w.computeSize(-1, -1, flushCache);
                    w.setBounds(clientArea.x, clientArea.y, clientArea.width, e2.y);
                    clientArea.y += e2.y;
                    clientArea.height -= e2.y;
                } else if (w == WorkbenchWindow.this.getSeparator2()) {
                    if (WorkbenchWindow.this.getShowToolBar()) {
                        Point e3 = w.computeSize(-1, -1, flushCache);
                        w.setBounds(clientArea.x, clientArea.y, clientArea.width, e3.y);
                        clientArea.y += e3.y;
                        clientArea.height -= e3.y;
                    } else {
                        w.setBounds(0, 0, 0, 0);
                    }
                } else if (w == WorkbenchWindow.this.getToolBarControl()) {
                    if (WorkbenchWindow.this.getShowToolBar()) {
                        int height = 23;
                        if (WorkbenchWindow.this.toolBarChildrenExist()) {
                            e = w.computeSize(clientArea.width, -1, flushCache);
                            height = e.y;
                        }
                        w.setBounds(clientArea.x, clientArea.y, clientArea.width, height);
                        clientArea.y += height;
                        clientArea.height -= height;
                    } else {
                        w.setBounds(0, 0, 0, 0);
                    }
                } else if (WorkbenchWindow.this.getStatusLineManager() != null && w == WorkbenchWindow.this.getStatusLineManager().getControl()) {
                    if (WorkbenchWindow.this.getShowStatusLine()) {
                        ToolBar bar;
                        ToolBar widget;
                        int width = 0;
                        if (WorkbenchWindow.this.getShortcutBar() != null && WorkbenchWindow.this.getShowShortcutBar() && (widget = WorkbenchWindow.this.getShortcutBar().getControl()) != null && widget instanceof ToolBar && (bar = widget).getItemCount() > 0) {
                            ToolItem item = bar.getItem(0);
                            width = item.getWidth();
                            Rectangle trim = bar.computeTrim(0, 0, width, width);
                            width = trim.width;
                        }
                        e = w.computeSize(-1, -1, flushCache);
                        w.setBounds(clientArea.x + width, clientArea.y + clientArea.height - e.y, clientArea.width - width, e.y);
                        clientArea.height -= e.y + 0;
                    } else {
                        w.setBounds(0, 0, 0, 0);
                    }
                } else if (WorkbenchWindow.this.getShortcutBar() != null && w == WorkbenchWindow.this.getShortcutBar().getControl()) {
                    if (WorkbenchWindow.this.getShowShortcutBar()) {
                        ToolBar bar;
                        int width = 23;
                        if (w instanceof ToolBar && (bar = (ToolBar)w).getItemCount() > 0) {
                            ToolItem item = bar.getItem(0);
                            width = item.getWidth();
                            Rectangle trim = bar.computeTrim(0, 0, width, width);
                            width = trim.width;
                        }
                        w.setBounds(clientArea.x, clientArea.y, width, clientArea.height);
                        clientArea.x += width + 0;
                        clientArea.width -= width + 0;
                    } else {
                        w.setBounds(0, 0, 0, 0);
                    }
                } else if (w == WorkbenchWindow.this.getSeparator3()) {
                    if (WorkbenchWindow.this.getShowShortcutBar()) {
                        Point e4 = w.computeSize(-1, -1, flushCache);
                        w.setBounds(clientArea.x, clientArea.y, e4.x, clientArea.height);
                        clientArea.x += e4.x;
                    } else {
                        w.setBounds(0, 0, 0, 0);
                    }
                } else {
                    w.setBounds(clientArea.x + 3, clientArea.y + 3 + 0, clientArea.width - 6, clientArea.height - 0 - 6);
                }
                ++i;
            }
        }
    }

    class PageList {
        private List pageList = new ArrayList(4);
        private List pageStack = new ArrayList(4);
        private Object active;

        public boolean add(Object object) {
            this.pageList.add(object);
            this.pageStack.add(0, object);
            return true;
        }

        public Iterator iterator() {
            return this.pageList.iterator();
        }

        public boolean contains(Object object) {
            return this.pageList.contains(object);
        }

        public boolean remove(Object object) {
            if (this.active == object) {
                this.active = null;
            }
            this.pageStack.remove(object);
            return this.pageList.remove(object);
        }

        public boolean isEmpty() {
            return this.pageList.isEmpty();
        }

        public IWorkbenchPage[] getPages() {
            int nSize = this.pageList.size();
            IWorkbenchPage[] retArray = new IWorkbenchPage[nSize];
            this.pageList.toArray(retArray);
            return retArray;
        }

        public void setActive(Object page) {
            if (this.active == page) {
                return;
            }
            this.active = page;
            if (page != null) {
                this.pageStack.remove(page);
                this.pageStack.add(page);
            }
        }

        public WorkbenchPage getActive() {
            return (WorkbenchPage)this.active;
        }

        public WorkbenchPage getNextActive() {
            if (this.active == null) {
                if (this.pageStack.isEmpty()) {
                    return null;
                }
                return (WorkbenchPage)this.pageStack.get(this.pageStack.size() - 1);
            }
            if (this.pageStack.size() < 2) {
                return null;
            }
            return (WorkbenchPage)this.pageStack.get(this.pageStack.size() - 2);
        }
    }
}

