/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class GestureConfiguration
implements Comparable {
    private static final int HASH_INITIAL = 11;
    private static final int HASH_FACTOR = 21;
    private static Comparator nameComparator;
    private String description;
    private String id;
    private String name;
    private String parent;
    private String plugin;

    public static GestureConfiguration create(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        return new GestureConfiguration(description, id, name, parent, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((GestureConfiguration)left).name, ((GestureConfiguration)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List gestureConfigurations) throws IllegalArgumentException {
        if (gestureConfigurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, GestureConfiguration> sortedMap = new TreeMap<String, GestureConfiguration>();
        Iterator iterator = gestureConfigurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof GestureConfiguration)) {
                throw new IllegalArgumentException();
            }
            GestureConfiguration gestureConfiguration = (GestureConfiguration)object;
            sortedMap.put(gestureConfiguration.id, gestureConfiguration);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List gestureConfigurations) throws IllegalArgumentException {
        if (gestureConfigurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, GestureConfiguration> sortedMap = new TreeMap<String, GestureConfiguration>();
        Iterator iterator = gestureConfigurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof GestureConfiguration)) {
                throw new IllegalArgumentException();
            }
            GestureConfiguration gestureConfiguration = (GestureConfiguration)object;
            sortedMap.put(gestureConfiguration.name, gestureConfiguration);
        }
        return sortedMap;
    }

    private GestureConfiguration(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        GestureConfiguration item = (GestureConfiguration)object;
        int compareTo = this.id.compareTo(item.id);
        if (compareTo == 0 && (compareTo = this.name.compareTo(item.name)) == 0) {
            Util.compare((Comparable)((Object)this.description), (Comparable)((Object)item.description));
            if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.parent), (Comparable)((Object)item.parent))) == 0) {
                compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)item.plugin));
            }
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GestureConfiguration)) {
            return false;
        }
        GestureConfiguration gestureConfiguration = (GestureConfiguration)object;
        return Util.equals(this.description, gestureConfiguration.description) && this.id.equals(gestureConfiguration.id) && this.name.equals(gestureConfiguration.name) && Util.equals(this.parent, gestureConfiguration.parent) && Util.equals(this.plugin, gestureConfiguration.plugin);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 11;
        result = result * 21 + Util.hashCode(this.description);
        result = result * 21 + this.id.hashCode();
        result = result * 21 + this.name.hashCode();
        result = result * 21 + Util.hashCode(this.parent);
        result = result * 21 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

