/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.commands.ActiveGestureConfiguration;
import org.eclipse.ui.internal.commands.ActiveKeyConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.GestureBinding;
import org.eclipse.ui.internal.commands.GestureConfiguration;
import org.eclipse.ui.internal.commands.GestureSequence;
import org.eclipse.ui.internal.commands.GestureStroke;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyConfiguration;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.commands.RegionalGestureBinding;
import org.eclipse.ui.internal.commands.RegionalKeyBinding;
import org.eclipse.ui.internal.commands.Scope;

final class Persistence {
    static final String PACKAGE_BASE = "commands";
    static final String PACKAGE_FULL = "org.eclipse.ui.commands";
    static final String TAG_ACTIVE_GESTURE_CONFIGURATION = "activeGestureConfiguration";
    static final String TAG_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration";
    static final String TAG_CATEGORY = "category";
    static final String TAG_COMMAND = "command";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_GESTURE_BINDING = "gestureBinding";
    static final String TAG_GESTURE_CONFIGURATION = "gestureConfiguration";
    static final String TAG_GESTURE_STRING = "gestureString";
    static final String TAG_GESTURE_SEQUENCE = "gestureSequence";
    static final String TAG_GESTURE_STROKE = "gestureStroke";
    static final String TAG_ID = "id";
    static final String TAG_KEY_BINDING = "keyBinding";
    static final String TAG_KEY_CONFIGURATION = "keyConfiguration";
    static final String TAG_KEY_SEQUENCE = "keySequence";
    static final String TAG_KEY_STRING = "keyString";
    static final String TAG_KEY_STROKE = "keyStroke";
    static final String TAG_LOCALE = "locale";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT = "parent";
    static final String TAG_PLATFORM = "platform";
    static final String TAG_PLUGIN = "plugin";
    static final String TAG_RANK = "rank";
    static final String TAG_REGIONAL_GESTURE_BINDING = "regionalGestureBinding";
    static final String TAG_REGIONAL_KEY_BINDING = "regionalKeyBinding";
    static final String TAG_SCOPE = "scope";
    static final String TAG_VALUE = "value";
    static final Integer ZERO = new Integer(0);
    static final GestureSequence ZERO_LENGTH_GESTURE_SEQUENCE = GestureSequence.create();
    static final KeySequence ZERO_LENGTH_KEY_SEQUENCE = KeySequence.create();
    static final String ZERO_LENGTH_STRING = "";

    static ActiveGestureConfiguration readActiveGestureConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        String value = memento.getString(TAG_VALUE);
        if (value == null) {
            value = ZERO_LENGTH_STRING;
        }
        return ActiveGestureConfiguration.create(plugin, value);
    }

    static List readActiveGestureConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ActiveGestureConfiguration> list = new ArrayList<ActiveGestureConfiguration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActiveGestureConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static ActiveKeyConfiguration readActiveKeyConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        String value = memento.getString(TAG_VALUE);
        if (value == null) {
            value = ZERO_LENGTH_STRING;
        }
        return ActiveKeyConfiguration.create(plugin, value);
    }

    static List readActiveKeyConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ActiveKeyConfiguration> list = new ArrayList<ActiveKeyConfiguration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActiveKeyConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Category readCategory(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = ZERO_LENGTH_STRING;
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = ZERO_LENGTH_STRING;
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Category.create(description, id, name, plugin);
    }

    static List readCategories(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Category> list = new ArrayList<Category>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCategory(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Command readCommand(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String category = memento.getString(TAG_CATEGORY);
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = ZERO_LENGTH_STRING;
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = ZERO_LENGTH_STRING;
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Command.create(category, description, id, name, plugin);
    }

    static List readCommands(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Command> list = new ArrayList<Command>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCommand(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static GestureBinding readGestureBinding(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String scope;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String command = memento.getString(TAG_COMMAND);
        String gestureConfiguration = memento.getString(TAG_GESTURE_CONFIGURATION);
        if (gestureConfiguration == null) {
            gestureConfiguration = ZERO_LENGTH_STRING;
        }
        GestureSequence gestureSequence = null;
        IMemento mementoGestureSequence = memento.getChild(TAG_GESTURE_SEQUENCE);
        if (mementoGestureSequence != null) {
            gestureSequence = Persistence.readGestureSequence(mementoGestureSequence);
        } else {
            String gestureString = memento.getString(TAG_GESTURE_STRING);
            if (gestureString != null) {
                try {
                    gestureSequence = GestureSequence.parse(gestureString);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (gestureSequence == null) {
            gestureSequence = ZERO_LENGTH_GESTURE_SEQUENCE;
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        Integer rank = memento.getInteger(TAG_RANK);
        if (rank == null) {
            rank = ZERO;
        }
        if ((scope = memento.getString(TAG_SCOPE)) == null) {
            scope = ZERO_LENGTH_STRING;
        }
        return GestureBinding.create(command, gestureConfiguration, gestureSequence, plugin, rank, scope);
    }

    static List readGestureBindings(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<GestureBinding> list = new ArrayList<GestureBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readGestureBinding(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static GestureConfiguration readGestureConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = ZERO_LENGTH_STRING;
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = ZERO_LENGTH_STRING;
        }
        String parent = memento.getString(TAG_PARENT);
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return GestureConfiguration.create(description, id, name, parent, plugin);
    }

    static List readGestureConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<GestureConfiguration> list = new ArrayList<GestureConfiguration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readGestureConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static GestureSequence readGestureSequence(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(TAG_GESTURE_STROKE);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<GestureStroke> gestureStrokes = new ArrayList<GestureStroke>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            gestureStrokes.add(Persistence.readGestureStroke(mementos[i]));
            ++i;
        }
        return GestureSequence.create(gestureStrokes);
    }

    static GestureStroke readGestureStroke(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Integer value = memento.getInteger(TAG_VALUE);
        if (value == null) {
            value = ZERO;
        }
        return GestureStroke.create(value);
    }

    static KeyBinding readKeyBinding(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String scope;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String command = memento.getString(TAG_COMMAND);
        String keyConfiguration = memento.getString(TAG_KEY_CONFIGURATION);
        if (keyConfiguration == null) {
            keyConfiguration = ZERO_LENGTH_STRING;
        }
        KeySequence keySequence = null;
        IMemento mementoKeySequence = memento.getChild(TAG_KEY_SEQUENCE);
        if (mementoKeySequence != null) {
            keySequence = Persistence.readKeySequence(mementoKeySequence);
        } else {
            String keyString = memento.getString(TAG_KEY_STRING);
            if (keyString != null) {
                try {
                    keySequence = KeySequence.parse(keyString);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (keySequence == null) {
            keySequence = ZERO_LENGTH_KEY_SEQUENCE;
        }
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        Integer rank = memento.getInteger(TAG_RANK);
        if (rank == null) {
            rank = ZERO;
        }
        if ((scope = memento.getString(TAG_SCOPE)) == null) {
            scope = ZERO_LENGTH_STRING;
        }
        return KeyBinding.create(command, keyConfiguration, keySequence, plugin, rank, scope);
    }

    static List readKeyBindings(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyBinding> list = new ArrayList<KeyBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readKeyBinding(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static KeyConfiguration readKeyConfiguration(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = ZERO_LENGTH_STRING;
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = ZERO_LENGTH_STRING;
        }
        String parent = memento.getString(TAG_PARENT);
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return KeyConfiguration.create(description, id, name, parent, plugin);
    }

    static List readKeyConfigurations(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyConfiguration> list = new ArrayList<KeyConfiguration>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readKeyConfiguration(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static KeySequence readKeySequence(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(TAG_KEY_STROKE);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            keyStrokes.add(Persistence.readKeyStroke(mementos[i]));
            ++i;
        }
        return KeySequence.create(keyStrokes);
    }

    static KeyStroke readKeyStroke(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Integer value = memento.getInteger(TAG_VALUE);
        if (value == null) {
            value = ZERO;
        }
        return KeyStroke.create(value);
    }

    static RegionalGestureBinding readRegionalGestureBinding(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String platform;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento mementoGestureBinding = memento.getChild(TAG_GESTURE_BINDING);
        GestureBinding gestureBinding = null;
        gestureBinding = mementoGestureBinding == null ? GestureBinding.create(null, ZERO_LENGTH_STRING, ZERO_LENGTH_GESTURE_SEQUENCE, null, 0, ZERO_LENGTH_STRING) : Persistence.readGestureBinding(mementoGestureBinding, pluginOverride);
        String locale = memento.getString(TAG_LOCALE);
        if (locale == null) {
            locale = ZERO_LENGTH_STRING;
        }
        if ((platform = memento.getString(TAG_PLATFORM)) == null) {
            platform = ZERO_LENGTH_STRING;
        }
        return RegionalGestureBinding.create(gestureBinding, locale, platform);
    }

    static List readRegionalGestureBindings(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<RegionalGestureBinding> list = new ArrayList<RegionalGestureBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readRegionalGestureBinding(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static RegionalKeyBinding readRegionalKeyBinding(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String platform;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento mementoKeyBinding = memento.getChild(TAG_KEY_BINDING);
        KeyBinding keyBinding = null;
        keyBinding = mementoKeyBinding == null ? KeyBinding.create(null, ZERO_LENGTH_STRING, ZERO_LENGTH_KEY_SEQUENCE, null, 0, ZERO_LENGTH_STRING) : Persistence.readKeyBinding(mementoKeyBinding, pluginOverride);
        String locale = memento.getString(TAG_LOCALE);
        if (locale == null) {
            locale = ZERO_LENGTH_STRING;
        }
        if ((platform = memento.getString(TAG_PLATFORM)) == null) {
            platform = ZERO_LENGTH_STRING;
        }
        return RegionalKeyBinding.create(keyBinding, locale, platform);
    }

    static List readRegionalKeyBindings(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<RegionalKeyBinding> list = new ArrayList<RegionalKeyBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readRegionalKeyBinding(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static Scope readScope(IMemento memento, String pluginOverride) throws IllegalArgumentException {
        String name;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        if (id == null) {
            id = ZERO_LENGTH_STRING;
        }
        if ((name = memento.getString(TAG_NAME)) == null) {
            name = ZERO_LENGTH_STRING;
        }
        String parent = memento.getString(TAG_PARENT);
        String plugin = pluginOverride != null ? pluginOverride : memento.getString(TAG_PLUGIN);
        return Scope.create(description, id, name, parent, plugin);
    }

    static List readScopes(IMemento memento, String name, String pluginOverride) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Scope> list = new ArrayList<Scope>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readScope(mementos[i], pluginOverride));
            ++i;
        }
        return list;
    }

    static void writeActiveGestureConfiguration(IMemento memento, ActiveGestureConfiguration activeGestureConfiguration) throws IllegalArgumentException {
        if (memento == null || activeGestureConfiguration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_PLUGIN, activeGestureConfiguration.getPlugin());
        memento.putString(TAG_VALUE, activeGestureConfiguration.getValue());
    }

    static void writeActiveGestureConfigurations(IMemento memento, String name, List activeGestureConfigurations) throws IllegalArgumentException {
        if (memento == null || name == null || activeGestureConfigurations == null) {
            throw new IllegalArgumentException();
        }
        activeGestureConfigurations = new ArrayList(activeGestureConfigurations);
        Iterator iterator = activeGestureConfigurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof ActiveGestureConfiguration) continue;
            throw new IllegalArgumentException();
        }
        iterator = activeGestureConfigurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActiveGestureConfiguration(memento.createChild(name), (ActiveGestureConfiguration)iterator.next());
        }
    }

    static void writeActiveKeyConfiguration(IMemento memento, ActiveKeyConfiguration activeKeyConfiguration) throws IllegalArgumentException {
        if (memento == null || activeKeyConfiguration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_PLUGIN, activeKeyConfiguration.getPlugin());
        memento.putString(TAG_VALUE, activeKeyConfiguration.getValue());
    }

    static void writeActiveKeyConfigurations(IMemento memento, String name, List activeKeyConfigurations) throws IllegalArgumentException {
        if (memento == null || name == null || activeKeyConfigurations == null) {
            throw new IllegalArgumentException();
        }
        activeKeyConfigurations = new ArrayList(activeKeyConfigurations);
        Iterator iterator = activeKeyConfigurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof ActiveKeyConfiguration) continue;
            throw new IllegalArgumentException();
        }
        iterator = activeKeyConfigurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActiveKeyConfiguration(memento.createChild(name), (ActiveKeyConfiguration)iterator.next());
        }
    }

    static void writeCategory(IMemento memento, Category category) throws IllegalArgumentException {
        if (memento == null || category == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, category.getDescription());
        memento.putString(TAG_ID, category.getId());
        memento.putString(TAG_NAME, category.getName());
        memento.putString(TAG_PLUGIN, category.getPlugin());
    }

    static void writeCategories(IMemento memento, String name, List categories) throws IllegalArgumentException {
        if (memento == null || name == null || categories == null) {
            throw new IllegalArgumentException();
        }
        categories = new ArrayList(categories);
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Category) continue;
            throw new IllegalArgumentException();
        }
        iterator = categories.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategory(memento.createChild(name), (Category)iterator.next());
        }
    }

    static void writeCommand(IMemento memento, Command command) throws IllegalArgumentException {
        if (memento == null || command == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_CATEGORY, command.getCategory());
        memento.putString(TAG_DESCRIPTION, command.getDescription());
        memento.putString(TAG_ID, command.getId());
        memento.putString(TAG_NAME, command.getName());
        memento.putString(TAG_PLUGIN, command.getPlugin());
    }

    static void writeCommands(IMemento memento, String name, List commands) throws IllegalArgumentException {
        if (memento == null || name == null || commands == null) {
            throw new IllegalArgumentException();
        }
        commands = new ArrayList(commands);
        Iterator iterator = commands.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Command) continue;
            throw new IllegalArgumentException();
        }
        iterator = commands.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCommand(memento.createChild(name), (Command)iterator.next());
        }
    }

    static void writeGestureBinding(IMemento memento, GestureBinding gestureBinding) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_COMMAND, gestureBinding.getCommand());
        memento.putString(TAG_GESTURE_CONFIGURATION, gestureBinding.getGestureConfiguration());
        Persistence.writeGestureSequence(memento.createChild(TAG_GESTURE_SEQUENCE), gestureBinding.getGestureSequence());
        memento.putString(TAG_PLUGIN, gestureBinding.getPlugin());
        memento.putInteger(TAG_RANK, gestureBinding.getRank());
        memento.putString(TAG_SCOPE, gestureBinding.getScope());
    }

    static void writeGestureBindings(IMemento memento, String name, List gestureBindings) throws IllegalArgumentException {
        if (memento == null || name == null || gestureBindings == null) {
            throw new IllegalArgumentException();
        }
        gestureBindings = new ArrayList(gestureBindings);
        Iterator iterator = gestureBindings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof GestureBinding) continue;
            throw new IllegalArgumentException();
        }
        iterator = gestureBindings.iterator();
        while (iterator.hasNext()) {
            Persistence.writeGestureBinding(memento.createChild(name), (GestureBinding)iterator.next());
        }
    }

    static void writeGestureConfiguration(IMemento memento, GestureConfiguration gestureConfiguration) throws IllegalArgumentException {
        if (memento == null || gestureConfiguration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, gestureConfiguration.getDescription());
        memento.putString(TAG_ID, gestureConfiguration.getId());
        memento.putString(TAG_NAME, gestureConfiguration.getName());
        memento.putString(TAG_PARENT, gestureConfiguration.getParent());
        memento.putString(TAG_PLUGIN, gestureConfiguration.getPlugin());
    }

    static void writeGestureConfigurations(IMemento memento, String name, List gestureConfigurations) throws IllegalArgumentException {
        if (memento == null || name == null || gestureConfigurations == null) {
            throw new IllegalArgumentException();
        }
        gestureConfigurations = new ArrayList(gestureConfigurations);
        Iterator iterator = gestureConfigurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof GestureConfiguration) continue;
            throw new IllegalArgumentException();
        }
        iterator = gestureConfigurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeGestureConfiguration(memento.createChild(name), (GestureConfiguration)iterator.next());
        }
    }

    static void writeGestureSequence(IMemento memento, GestureSequence gestureSequence) throws IllegalArgumentException {
        if (memento == null || gestureSequence == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = gestureSequence.getGestureStrokes().iterator();
        while (iterator.hasNext()) {
            Persistence.writeGestureStroke(memento.createChild(TAG_GESTURE_STROKE), (GestureStroke)iterator.next());
        }
    }

    static void writeGestureStroke(IMemento memento, GestureStroke gestureStroke) throws IllegalArgumentException {
        if (memento == null || gestureStroke == null) {
            throw new IllegalArgumentException();
        }
        memento.putInteger(TAG_VALUE, gestureStroke.getValue());
    }

    static void writeKeyBinding(IMemento memento, KeyBinding keyBinding) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_COMMAND, keyBinding.getCommand());
        memento.putString(TAG_KEY_CONFIGURATION, keyBinding.getKeyConfiguration());
        Persistence.writeKeySequence(memento.createChild(TAG_KEY_SEQUENCE), keyBinding.getKeySequence());
        memento.putString(TAG_PLUGIN, keyBinding.getPlugin());
        memento.putInteger(TAG_RANK, keyBinding.getRank());
        memento.putString(TAG_SCOPE, keyBinding.getScope());
    }

    static void writeKeyBindings(IMemento memento, String name, List keyBindings) throws IllegalArgumentException {
        if (memento == null || name == null || keyBindings == null) {
            throw new IllegalArgumentException();
        }
        keyBindings = new ArrayList(keyBindings);
        Iterator iterator = keyBindings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof KeyBinding) continue;
            throw new IllegalArgumentException();
        }
        iterator = keyBindings.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeyBinding(memento.createChild(name), (KeyBinding)iterator.next());
        }
    }

    static void writeKeyConfiguration(IMemento memento, KeyConfiguration keyConfiguration) throws IllegalArgumentException {
        if (memento == null || keyConfiguration == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, keyConfiguration.getDescription());
        memento.putString(TAG_ID, keyConfiguration.getId());
        memento.putString(TAG_NAME, keyConfiguration.getName());
        memento.putString(TAG_PARENT, keyConfiguration.getParent());
        memento.putString(TAG_PLUGIN, keyConfiguration.getPlugin());
    }

    static void writeKeyConfigurations(IMemento memento, String name, List keyConfigurations) throws IllegalArgumentException {
        if (memento == null || name == null || keyConfigurations == null) {
            throw new IllegalArgumentException();
        }
        keyConfigurations = new ArrayList(keyConfigurations);
        Iterator iterator = keyConfigurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof KeyConfiguration) continue;
            throw new IllegalArgumentException();
        }
        iterator = keyConfigurations.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeyConfiguration(memento.createChild(name), (KeyConfiguration)iterator.next());
        }
    }

    static void writeKeySequence(IMemento memento, KeySequence keySequence) throws IllegalArgumentException {
        if (memento == null || keySequence == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = keySequence.getKeyStrokes().iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeyStroke(memento.createChild(TAG_KEY_STROKE), (KeyStroke)iterator.next());
        }
    }

    static void writeKeyStroke(IMemento memento, KeyStroke keyStroke) throws IllegalArgumentException {
        if (memento == null || keyStroke == null) {
            throw new IllegalArgumentException();
        }
        memento.putInteger(TAG_VALUE, keyStroke.getValue());
    }

    static void writeRegionalGestureBinding(IMemento memento, RegionalGestureBinding regionalGestureBinding) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Persistence.writeGestureBinding(memento.createChild(TAG_GESTURE_BINDING), regionalGestureBinding.getGestureBinding());
        memento.putString(TAG_LOCALE, regionalGestureBinding.getLocale());
        memento.putString(TAG_PLATFORM, regionalGestureBinding.getPlatform());
    }

    static void writeRegionalGestureBindings(IMemento memento, String name, List regionalGestureBindings) throws IllegalArgumentException {
        if (memento == null || name == null || regionalGestureBindings == null) {
            throw new IllegalArgumentException();
        }
        regionalGestureBindings = new ArrayList(regionalGestureBindings);
        Iterator iterator = regionalGestureBindings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof RegionalGestureBinding) continue;
            throw new IllegalArgumentException();
        }
        iterator = regionalGestureBindings.iterator();
        while (iterator.hasNext()) {
            Persistence.writeRegionalGestureBinding(memento.createChild(name), (RegionalGestureBinding)iterator.next());
        }
    }

    static void writeRegionalKeyBinding(IMemento memento, RegionalKeyBinding regionalKeyBinding) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Persistence.writeKeyBinding(memento.createChild(TAG_KEY_BINDING), regionalKeyBinding.getKeyBinding());
        memento.putString(TAG_LOCALE, regionalKeyBinding.getLocale());
        memento.putString(TAG_PLATFORM, regionalKeyBinding.getPlatform());
    }

    static void writeRegionalKeyBindings(IMemento memento, String name, List regionalKeyBindings) throws IllegalArgumentException {
        if (memento == null || name == null || regionalKeyBindings == null) {
            throw new IllegalArgumentException();
        }
        regionalKeyBindings = new ArrayList(regionalKeyBindings);
        Iterator iterator = regionalKeyBindings.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof RegionalKeyBinding) continue;
            throw new IllegalArgumentException();
        }
        iterator = regionalKeyBindings.iterator();
        while (iterator.hasNext()) {
            Persistence.writeRegionalKeyBinding(memento.createChild(name), (RegionalKeyBinding)iterator.next());
        }
    }

    static void writeScope(IMemento memento, Scope scope) throws IllegalArgumentException {
        if (memento == null || scope == null) {
            throw new IllegalArgumentException();
        }
        memento.putString(TAG_DESCRIPTION, scope.getDescription());
        memento.putString(TAG_ID, scope.getId());
        memento.putString(TAG_NAME, scope.getName());
        memento.putString(TAG_PARENT, scope.getParent());
        memento.putString(TAG_PLUGIN, scope.getPlugin());
    }

    static void writeScopes(IMemento memento, String name, List scopes) throws IllegalArgumentException {
        if (memento == null || name == null || scopes == null) {
            throw new IllegalArgumentException();
        }
        scopes = new ArrayList(scopes);
        Iterator iterator = scopes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Scope) continue;
            throw new IllegalArgumentException();
        }
        iterator = scopes.iterator();
        while (iterator.hasNext()) {
            Persistence.writeScope(memento.createChild(name), (Scope)iterator.next());
        }
    }

    private Persistence() {
    }
}

