/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;

class DecorationBuilder
implements IDecoration {
    private static int DECORATOR_ARRAY_SIZE = 5;
    private List prefixes = new ArrayList();
    private List suffixes = new ArrayList();
    private ImageDescriptor[] descriptors = new ImageDescriptor[DECORATOR_ARRAY_SIZE];
    LightweightDecoratorDefinition currentDefinition;
    private boolean valueSet = false;

    DecorationBuilder() {
    }

    void setCurrentDefinition(LightweightDecoratorDefinition definition) {
        this.currentDefinition = definition;
    }

    public void addOverlay(ImageDescriptor overlay) {
        int quadrant = this.currentDefinition.getQuadrant();
        if (this.descriptors[quadrant] == null) {
            this.descriptors[quadrant] = overlay;
        }
        this.valueSet = true;
    }

    public void addPrefix(String prefixString) {
        this.prefixes.add(prefixString);
        this.valueSet = true;
    }

    public void addSuffix(String suffixString) {
        this.suffixes.add(suffixString);
        this.valueSet = true;
    }

    DecorationResult createResult() {
        DecorationResult newResult = new DecorationResult(new ArrayList(this.prefixes), new ArrayList(this.suffixes), this.descriptors);
        return newResult;
    }

    void clearContents() {
        this.prefixes.clear();
        this.suffixes.clear();
        this.descriptors = new ImageDescriptor[DECORATOR_ARRAY_SIZE];
        this.valueSet = false;
    }

    boolean hasValue() {
        return this.valueSet;
    }
}

