/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DeclarativeDecorator;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;

class LightweightDecoratorDefinition
extends DecoratorDefinition {
    private ILightweightLabelDecorator decorator;
    private int quadrant;
    private String iconLocation;
    private String decoratorClass;

    LightweightDecoratorDefinition(String identifier, String label, String decoratorDescription, ActionExpression expression, boolean isAdaptable, boolean initEnabled, int quadrantValue, String iconPath, IConfigurationElement element) {
        super(identifier, label, decoratorDescription, expression, isAdaptable, initEnabled, element);
        this.iconLocation = iconPath;
        this.quadrant = quadrantValue;
    }

    protected ILightweightLabelDecorator internalGetDecorator() throws CoreException {
        if (this.labelProviderCreationFailed) {
            return null;
        }
        final CoreException[] exceptions = new CoreException[1];
        if (this.decorator == null) {
            if (this.definingElement.getAttribute("class") == null) {
                this.decorator = new DeclarativeDecorator(this.definingElement, this.iconLocation);
            } else {
                Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.format("DecoratorManager.ErrorActivatingDecorator", new String[]{this.getName()})){

                    public void run() {
                        try {
                            LightweightDecoratorDefinition.this.decorator = (ILightweightLabelDecorator)WorkbenchPlugin.createExtension(LightweightDecoratorDefinition.this.definingElement, "class");
                            LightweightDecoratorDefinition.this.decorator.addListener((ILabelProviderListener)WorkbenchPlugin.getDefault().getDecoratorManager());
                        }
                        catch (CoreException exception) {
                            exceptions[0] = exception;
                        }
                    }
                });
            }
        } else {
            return this.decorator;
        }
        if (this.decorator == null) {
            this.labelProviderCreationFailed = true;
            this.setEnabled(false);
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        return this.decorator;
    }

    protected IBaseLabelProvider internalGetLabelProvider() throws CoreException {
        return this.internalGetDecorator();
    }

    public boolean isFull() {
        return false;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            ILightweightLabelDecorator currentDecorator = this.internalGetDecorator();
            if (currentDecorator != null) {
                currentDecorator.decorate(element, decoration);
            }
        }
        catch (CoreException exception) {
            this.handleCoreException(exception);
        }
    }

    public ILightweightLabelDecorator getDecorator() {
        return this.decorator;
    }
}

