/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.fonts.FontDefinition;
import org.eclipse.ui.internal.misc.Sorter;

public class FontPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Hashtable labelsToDefinitions;
    private Hashtable fontDataSettings;
    private List fontList;
    private Button changeFontButton;
    private Button useSystemButton;
    private Text descriptionText;
    private Font appliedDialogFont;
    private ArrayList dialogFontWidgets = new ArrayList();
    private String DEFAULT_TOKEN = "DEFAULT";
    private Label valueControl;
    private DefaultPreviewer previewer;

    private void applyDialogFont(Control control) {
        control.setFont(JFaceResources.getDialogFont());
        this.dialogFontWidgets.add(control);
    }

    private void updateForDialogFontChange(Font newFont) {
        Iterator iterator = ((AbstractList)this.dialogFontWidgets).iterator();
        while (iterator.hasNext()) {
            ((Control)iterator.next()).setFont(newFont);
        }
    }

    public Control createContents(Composite parent) {
        WorkbenchHelp.setHelp(this.getControl(), "org.eclipse.ui.font_preference_page_context");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FontPreferencePage.this.appliedDialogFont != null) {
                    FontPreferencePage.this.appliedDialogFont.dispose();
                }
            }
        });
        Font defaultFont = parent.getFont();
        Composite mainColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        mainColumn.setFont(defaultFont);
        mainColumn.setLayout((Layout)layout);
        this.createFontList(mainColumn);
        Composite previewColumn = new Composite(mainColumn, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        previewColumn.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        previewColumn.setLayoutData((Object)data);
        previewColumn.setFont(defaultFont);
        this.createPreviewControl(previewColumn);
        this.createValueControl(previewColumn);
        Composite buttonColumn = new Composite(previewColumn, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonColumn.setLayout((Layout)layout);
        data = new GridData(128);
        buttonColumn.setLayoutData((Object)data);
        buttonColumn.setFont(defaultFont);
        this.createUseDefaultsControl(buttonColumn, WorkbenchMessages.getString("FontsPreference.useSystemFont"));
        this.createChangeControl(buttonColumn, JFaceResources.getString((String)"openChange"));
        this.createDescriptionControl(parent);
        return mainColumn;
    }

    public FontPreferencePage() {
        this.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
    }

    private void createFontList(Composite firstColumn) {
        Composite parent = new Composite(firstColumn, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        parent.setLayoutData((Object)data);
        Label label = new Label(parent, 16384);
        label.setText(WorkbenchMessages.getString("FontsPreference.fonts"));
        this.applyDialogFont((Control)label);
        this.fontList = new List(parent, 2048);
        data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        this.fontList.setLayoutData((Object)data);
        this.applyDialogFont((Control)this.fontList);
        this.fontList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDefinition selectedFontDefinition = FontPreferencePage.this.getSelectedFontDefinition();
                if (selectedFontDefinition == null) {
                    FontPreferencePage.this.changeFontButton.setEnabled(false);
                    FontPreferencePage.this.useSystemButton.setEnabled(false);
                } else {
                    FontPreferencePage.this.changeFontButton.setEnabled(true);
                    FontPreferencePage.this.useSystemButton.setEnabled(true);
                    FontPreferencePage.this.updateForSelectedFontDefinition(selectedFontDefinition);
                }
            }
        });
        Set names = this.labelsToDefinitions.keySet();
        int nameSize = names.size();
        Object[] unsortedItems = new String[nameSize];
        names.toArray(unsortedItems);
        Sorter sorter = new Sorter(){
            private Collator collator = Collator.getInstance();

            public boolean compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return this.collator.compare(s1, s2) < 0;
            }
        };
        Object[] sortedItems = sorter.sort(unsortedItems);
        String[] listItems = new String[nameSize];
        System.arraycopy(sortedItems, 0, listItems, 0, nameSize);
        this.fontList.setItems(listItems);
    }

    private FontDefinition getSelectedFontDefinition() {
        String[] selection = this.fontList.getSelection();
        if (selection.length == 1) {
            return (FontDefinition)this.labelsToDefinitions.get(selection[0]);
        }
        return null;
    }

    private void createChangeControl(Composite parent, String changeButtonLabel) {
        this.changeFontButton = new Button(parent, 8);
        this.changeFontButton.setText(changeButtonLabel);
        this.applyDialogFont((Control)this.changeFontButton);
        this.setButtonLayoutData(this.changeFontButton);
        this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDefinition definition = FontPreferencePage.this.getSelectedFontDefinition();
                if (definition != null) {
                    FontDialog fontDialog = new FontDialog(FontPreferencePage.this.changeFontButton.getShell());
                    FontData[] currentData = FontPreferencePage.this.getFontDataSetting(definition);
                    fontDialog.setFontData(currentData[0]);
                    FontData font = fontDialog.open();
                    if (font != null) {
                        FontData[] fonts = new FontData[]{font};
                        FontPreferencePage.this.fontDataSettings.put(definition.getId(), fonts);
                        FontPreferencePage.this.updateForSelectedFontDefinition(definition);
                    }
                }
            }
        });
        this.changeFontButton.setEnabled(false);
    }

    private void createUseDefaultsControl(Composite parent, String useSystemLabel) {
        this.useSystemButton = new Button(parent, 0x1000008);
        this.useSystemButton.setText(useSystemLabel);
        this.applyDialogFont((Control)this.useSystemButton);
        this.setButtonLayoutData(this.useSystemButton);
        this.useSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDefinition definition = FontPreferencePage.this.getSelectedFontDefinition();
                if (definition != null) {
                    FontData[] defaultFontData = JFaceResources.getDefaultFont().getFontData();
                    FontPreferencePage.this.fontDataSettings.put(definition.getId(), defaultFontData);
                    FontPreferencePage.this.updateForSelectedFontDefinition(definition);
                }
            }
        });
        this.useSystemButton.setEnabled(false);
    }

    private void createPreviewControl(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(WorkbenchMessages.getString("FontsPreference.preview"));
        this.applyDialogFont((Control)label);
        this.previewer = new DefaultPreviewer(parent);
        Control control = this.previewer.getControl();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = this.previewer.getPreferredHeight();
        control.setLayoutData((Object)gd);
    }

    private void createDescriptionControl(Composite mainComposite) {
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(WorkbenchMessages.getString("FontsPreference.description"));
        this.applyDialogFont((Control)descriptionLabel);
        this.descriptionText = new Text(textComposite, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.applyDialogFont((Control)this.descriptionText);
    }

    private void createValueControl(Composite parent) {
        this.valueControl = new Label(parent, 0x1000000);
        this.valueControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FontPreferencePage.this.valueControl = null;
            }
        });
        this.applyDialogFont((Control)this.valueControl);
        GridData gd = new GridData(832);
        gd.grabExcessHorizontalSpace = true;
        this.valueControl.setLayoutData((Object)gd);
    }

    private void updateForSelectedFontDefinition(FontDefinition definition) {
        FontData[] font = this.getFontDataSetting(definition);
        this.valueControl.setText(StringConverter.asString((FontData)font[0]));
        this.previewer.setFont(font);
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(WorkbenchMessages.getString("PreferencePage.noDescription"));
        } else {
            this.descriptionText.setText(text);
        }
    }

    private FontData[] getFontDataSetting(FontDefinition definition) {
        String fontId = definition.getId();
        Object setting = this.fontDataSettings.get(fontId);
        if (this.DEFAULT_TOKEN.equals(setting)) {
            return this.getDefaultFont(definition);
        }
        return (FontData[])setting;
    }

    private FontData[] getDefaultFont(FontDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)definition.getId());
        }
        FontDefinition defaultDefinition = this.getDefinition(defaultsTo);
        if (defaultDefinition == null) {
            return JFaceResources.getDefaultFont().getFontData();
        }
        return this.getFontDataSetting(defaultDefinition);
    }

    public void init(IWorkbench workbench) {
        this.labelsToDefinitions = new Hashtable();
        this.fontDataSettings = new Hashtable();
        FontDefinition[] definitions = this.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            FontDefinition definition = definitions[i];
            this.labelsToDefinitions.put(definition.getLabel(), definition);
            FontData[] settingValue = this.getPreferenceStore().isDefault(definition.getId()) ? this.DEFAULT_TOKEN : JFaceResources.getFont((String)definition.getId()).getFontData();
            this.fontDataSettings.put(definition.getId(), settingValue);
            ++i;
        }
    }

    protected void performDefaults() {
        FontDefinition currentSelection = this.getSelectedFontDefinition();
        FontDefinition[] definitions = this.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            FontDefinition definition = definitions[i];
            this.fontDataSettings.put(definition.getId(), this.DEFAULT_TOKEN);
            if (definition.equals(currentSelection)) {
                this.updateForSelectedFontDefinition(definition);
            }
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        FontDefinition[] definitions = this.getDefinitions();
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < definitions.length) {
            FontDefinition definition = definitions[i];
            String preferenceId = definition.getId();
            String registryKey = definition.getId();
            Object setValue = this.fontDataSettings.get(preferenceId);
            if (this.DEFAULT_TOKEN.equals(setValue)) {
                store.setToDefault(registryKey);
            } else {
                FontData[] newData = (FontData[])setValue;
                if (!newData.equals(PreferenceConverter.getFontData((IPreferenceStore)store, (String)registryKey))) {
                    PreferenceConverter.setValue((IPreferenceStore)store, (String)registryKey, (FontData[])newData);
                }
            }
            ++i;
        }
        return super.performOk();
    }

    private FontDefinition[] getDefinitions() {
        return FontDefinition.getDefinitions();
    }

    private FontDefinition getDefinition(String registryKey) {
        FontDefinition[] definitions = this.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            if (definitions[i].getId().equals(registryKey)) {
                return definitions[i];
            }
            ++i;
        }
        return null;
    }

    private boolean hasSetting(FontDefinition definition) {
        return this.fontDataSettings.get(definition.getId()) instanceof FontData[];
    }

    protected void performApply() {
        super.performApply();
        Font oldFont = this.appliedDialogFont;
        FontData[] newData = this.getFontDataSetting(this.getDefinition("org.eclipse.jface.dialogfont"));
        this.appliedDialogFont = new Font((Device)this.getControl().getDisplay(), newData);
        this.updateForDialogFontChange(this.appliedDialogFont);
        this.getApplyButton().setFont(this.appliedDialogFont);
        this.getDefaultsButton().setFont(this.appliedDialogFont);
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    private static class DefaultPreviewer {
        private Text text;
        private Font font;

        public DefaultPreviewer(Composite parent) {
            this.text = new Text(parent, 2120);
            this.text.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ DefaultPreviewer this$1;
                {
                    this.this$1 = defaultPreviewer;
                }

                public void widgetDisposed(DisposeEvent e) {
                    if (DefaultPreviewer.access$0(this.this$1) != null) {
                        DefaultPreviewer.access$0(this.this$1).dispose();
                    }
                }
            });
        }

        public Control getControl() {
            return this.text;
        }

        public void setFont(FontData[] fontData) {
            FontData[] bestData;
            if (this.font != null) {
                this.font.dispose();
            }
            if ((bestData = JFaceResources.getFontRegistry().bestDataArray(fontData, this.text.getDisplay())) == null) {
                return;
            }
            this.font = new Font((Device)this.text.getDisplay(), bestData);
            this.text.setFont(this.font);
            this.text.setText(WorkbenchMessages.getString("FontsPreference.SampleText"));
        }

        public int getPreferredHeight() {
            return 120;
        }

        static /* synthetic */ Font access$0(DefaultPreviewer defaultPreviewer) {
            return defaultPreviewer.font;
        }
    }
}

