/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.MultiStepWizard;

public class MultiStepWizardDialog
extends WizardDialog {
    private MultiStepWizard multiStepWizard;

    public MultiStepWizardDialog(Shell parentShell, MultiStepWizard newWizard) {
        super(parentShell, (IWizard)newWizard);
        this.multiStepWizard = newWizard;
        this.multiStepWizard.setWizardDialog(this);
    }

    void forceClose() {
        super.finishPressed();
    }

    protected void backPressed() {
        if (this.multiStepWizard.isConfigureStepMode()) {
            this.multiStepWizard.getStepContainer().backPressed();
        } else {
            super.backPressed();
        }
    }

    protected void finishPressed() {
        if (this.multiStepWizard.isConfigureStepMode()) {
            boolean success = this.multiStepWizard.getStepContainer().performFinish();
            if (success) {
                this.multiStepWizard.getStepContainer().processCurrentStep();
            }
        } else {
            super.finishPressed();
        }
    }

    MultiStepWizard getMultiStepWizard() {
        return this.multiStepWizard;
    }

    protected void helpPressed() {
        if (this.multiStepWizard.isConfigureStepMode()) {
            this.multiStepWizard.getStepContainer().helpPressed();
        } else {
            super.helpPressed();
        }
    }

    protected void nextPressed() {
        if (this.multiStepWizard.isConfigureStepMode()) {
            this.multiStepWizard.getStepContainer().nextPressed();
        } else {
            super.nextPressed();
        }
    }

    void setFinishLabel(String label) {
        Button button = this.getButton(16);
        if (button == null) {
            return;
        }
        if (label == null) {
            if (!button.getText().equals(IDialogConstants.FINISH_LABEL)) {
                button.setText(IDialogConstants.FINISH_LABEL);
                button.getParent().layout(true);
            }
        } else {
            button.setText(label);
            button.getParent().layout(true);
        }
    }

    void updateAll() {
        super.update();
    }

    void updateLayout() {
        super.updateSize(this.getCurrentPage());
    }
}

